import abc
import threading


class Installer(object):
    def __init__(self):
        pass

    @abc.abstractmethod
    def install(self):
        return True

    @abc.abstractmethod
    def check(self):
        return True

    @abc.abstractmethod
    def rollback(self):
        return True


class ThreadInstaller(Installer):
    def __init__(self, node_list):
        """

        :param node_list: Node Object list，The Node object must have the ip, user, user_pwd, root, root_pwd attribute.
        """
        super(ThreadInstaller, self).__init__()
        self.node_list = node_list
        self.install_result = dict()
        self.check_result = dict()
        self.rollback_result = dict()

    @abc.abstractmethod
    def install_thread(self, node):
        """

        :param node: Node Object，The Node object must have the ip, user, user_pwd, root, root_pwd attribute.
        :return:
        """
        pass

    @abc.abstractmethod
    def check_thread(self, node):
        """

        :param node: Node Object，The Node object must have the ip, user, user_pwd, root, root_pwd attribute.
        :return:
        """
        pass

    @abc.abstractmethod
    def rollback_thread(self, node):
        """

        :param node: Node Object，The Node object must have the ip, user, user_pwd, root, root_pwd attribute.
        :return:
        """
        pass

    def exec_thread(self, target_exec):
        _threads = []
        for node in self.node_list:
            _t = threading.Thread(target=target_exec,
                                  args=(node,))
            _threads.append(_t)
        for thread in _threads:
            thread.start()
        for thread in _threads:
            thread.join()
        return True

    def install(self, do_rollback=False):
        if do_rollback:
            self.rollback()
        self.exec_thread(self.install_thread)
        for node in self.node_list:
            if not self.install_result.get(node.node_ip, False):
                return False
        return True

    def check(self):
        self.exec_thread(self.check_thread)
        for node in self.node_list:
            if not self.check_result.get(node.node_ip, False):
                return False
        return True

    def rollback(self):
        self.exec_thread(self.rollback_thread)
        for node in self.node_list:
            if not self.rollback_result.get(node.node_ip, False):
                return False
        return True
