from enum import Enum

CSBS_PROVIDER_ID = 'fc4d5750-22e7-4798-8a46-f48f62c4c1da'
VBS_PROVIDER_ID = '1dc03359-1301-467b-9972-1a7599ae791d'
FILESET_PROVIDER_ID = 'a412e702-4f0d-4d3c-9594-fe448d1ad6fa'
KARBOR_USER = 'djmanager'
VM_NAME = 'csbs_vm01'
VPC_NAME = 'csbs_vpc'
SUBNET_NAME = 'csbs_subnet'
KEYPAIR_NAME = 'csbs_keypair'
ECS_PRODUCT_TYPE = 'ecs'
EVS_PRODUCT_TYPE = 'evs'
EVS_NAME = 'vbs_disk'
EVS_SIZE = 1
VPC_PRODUCT_TYPE = 'vpc'
OPT_TYPE_ON = "start"
OPT_TYPE_OFF = "stop"

FSBS_POLICY_NAME_PRE = "fsbs_policy"
CSBS_POLICY_NAME_PRE = "csbs_autoplan"
VBS_POLICY_NAME_PRE = "vbs_autoplan"
POLICY_EXPIRED_TIME = 5

MINIMUM_QUOTA = 102400

CSBS_SERVICE_NAME = "CSBS-VBS"

PKG_SUFFIX_X86 = '_CBS_Karbor_X86.zip'
PKG_SUFFIX_ARM = '_CBS_Karbor_ARM.zip'

ENV_CONFIG_PATH = 'plugins/CSBS/conf/upgrade/env_param.ini'

AUTH_API = "/v3/auth/tokens"
REGISTER_ACCOUNT_API = "/rest/mounpwdservice/v1/account"

QUOTA_TYPE_DICT = {
    'backup_capacity': {
        'service_type': 'csbs',
        'product_name_zn': '云服务器备份',
        'product_name_en': 'Cloud Server Backup Service',
        'cn_label': '备份',
        'en_label': 'Backup'
    },
    'copy_capacity': {
        'service_type': 'csbs',
        'product_name_zn': '云服务器备份',
        'product_name_en': 'Cloud Server Backup Service',
        'cn_label': '复制',
        'en_label': 'Replication'
    },
    'volume_backup_capacity': {
        'service_type': 'vbs',
        'product_name_zn': '云硬盘备份',
        'product_name_en': 'Volume Backup Service',
        'cn_label': '备份',
        'en_label': 'Backup'
    },
    'volume_copy_capacity': {
        'service_type': 'vbs',
        'product_name_zn': '云硬盘备份',
        'product_name_en': 'Volume Backup Service',
        'cn_label': '复制',
        'en_label': 'Replication'
    },
    'fileset_backup_capacity': {
        'service_type': 'csbs',
        'product_name_zn': '文件集备份',
        'product_name_en': 'File Set Backup',
        'cn_label': '应用备份',
        'en_label': 'AppBackup'
    },
    'database_backup_capacity': {
        'service_type': 'csbs',
        'product_name_zn': '数据库备份',
        'product_name_en': 'Database Backup',
        'cn_label': '应用备份',
        'en_label': 'AppBackup'
    }
}

OP_LOG_TYPE = ('backup', 'copy', 'replication', 'restore', 'delete', 'sync',
               'vault_delete', 'remove_resource', 'export_log')

VMS_NAME = {
    "KARBOR1": 'Service-CSBS',
    "KARBOR2": 'Service-CSBS2',
    "KARBOR3": 'Service-CSBS3',
    "KARBOR_HA1": 'Service-CSBS',
    "KARBOR_HA2": 'Service-CSBSdr'
}

TASK_FILE = "plugins/CSBS/conf/upgrade/test_tasks.ini"

EULEROS = {
    "EL2R8": "eulerosv2r8",
    "EL2R9": "eulerosv2r9",
    "EL2R10": "eulerosv2r10",
    "EL2R11": "eulerosv2r11"
}


class CipherType(Enum):
    GENERAL_CIPHER = "generalCipher"
    SM_COMPATIBLE = "SMCompatible"


# HCCI error code
class HHCIErrorCode(Enum):
    RUN_SSH_CMD = 125002
