import os

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.ssh_client import SshClient


class KarborInstaller(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.karbor_util = KarborUtil(project_id, pod_id)
        nod_list = self.karbor_util.get_karbor_node_list()
        super(KarborInstaller, self).__init__(nod_list)
        self.param_tool = ParamTool(project_id, pod_id)
        self.ssh_client = SshClient()

    def exec_cmds(self, node, cmds):
        karbor_client = self.ssh_client.get_ssh_client(node)
        sed_cmd_list = [
            "sed -i s/'PermitRootLogin no'/'PermitRootLogin yes'/g "
            "/etc/ssh/sshd_config",
            "sed -i s/'ChallengeResponseAuthentication yes'"
            "/'ChallengeResponseAuthentication no'/g /etc/ssh/sshd_config",
            "sed -i /^UsePrivilegeSeparation.*/d /etc/ssh/sshd_config",
            "sed -i /^PasswordAuthentication.*/d /etc/ssh/sshd_config",
            "sed -i /^AllowUsers.*/d /etc/ssh/sshd_config"]
        sed_cmds = ";".join(sed_cmd_list)
        self.ssh_client.ssh_exec_command_return(karbor_client, sed_cmds)
        restart_cmds = "service sshd restart"
        self.ssh_client.ssh_exec_command_return(karbor_client, restart_cmds)
        work_dir = self.karbor_util.get_installer_workdir()
        self.upload_sysini(node)
        cd_cmd = "cd %s/CSBS/install_scripts" % work_dir
        self.ssh_client.ssh_exec_command_return(karbor_client, cd_cmd)
        result = self.ssh_client.ssh_exec_command_return(karbor_client, cmds)
        self.ssh_client.ssh_close(karbor_client)
        return self.ssh_client.is_ssh_cmd_executed(result)

    def install_thread(self, node):
        config = os.path.basename(self.param_tool.get_installer_config())
        cmds = "bash install_karbor.sh install '%s'" % config
        self.install_result[node.node_ip] = self.exec_cmds(node, cmds)

    def check_thread(self, node):
        cmds = "bash install_karbor.sh check"
        self.check_result[node.node_ip] = self.exec_cmds(node, cmds)

    def rollback_thread(self, node):
        cmds = "bash install_karbor.sh rollback"
        self.rollback_result[node.node_ip] = self.exec_cmds(node, cmds)

    def upload_sysini(self, karbor_node):
        work_dir = self.karbor_util.get_installer_workdir()
        sysini_path = self.param_tool.get_installer_config()
        if os.path.exists(sysini_path):
            self.ssh_client.put(karbor_node.node_ip, "root", karbor_node.root_pwd, sysini_path, work_dir)
