import utils.common.log as logger

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import karbor_cpshelper


class SecurityGroups(node_installer.Installer):
    def __init__(self, project_id, pod_id):
        super(SecurityGroups, self).__init__()
        self.karbor_util = KarborUtil(project_id, pod_id)
        self.pod_id = pod_id

    def install(self):
        cps_node = karbor_cpshelper.CPSInfo(self.pod_id).get_cps_node()
        cps_tool = karbor_cpshelper.CpsHelper(cps_node)
        karbor_ip_list = self.karbor_util.get_karbor_ip_list()
        float_ip1 = self.karbor_util.get_karbor_float_ip()
        float_ip2 = self.karbor_util.get_karbor_internal_float_ip()
        for karbor in karbor_ip_list:
            logger.info('Execute allowed_address_pairs, karbor ip:{}'.format(karbor))
            if not cps_tool.allowed_address_pairs(karbor, float_ip1, float_ip2):
                logger.error('Failed executing allowed_address_pairs, karbor ip:{}'.format(karbor))
                return False
        return True

    def check(self):
        return True

    def rollback(self):
        return True
