import configparser
import os
import stat


class ReadConfig(object):

    def __init__(self):
        cur_path = os.path.dirname(os.path.realpath(__file__))
        file_name = os.path.join(cur_path, "sys.ini")
        self.config = configparser.ConfigParser()
        self.config.read(file_name)

    def set_ini(self, obj):
        ini_path = obj.get_agent_config_ini_path()
        self.config.set("SYSTEM", "timezone", obj.timezone)
        self.config.set("SYSTEM", "agentproxy_nodes", obj.all_ips)
        self.config.set("SYSTEM", "haproxy_float_ip", obj.management_float_ip)
        self.config.set("SYSTEM", "current_region", obj.region_id)
        self.config.set("SYSTEM", "ip_version", obj.get_ip_version())
        self.config.set("SYSTEM", "net_mask", obj.karbor_proxy_ip0_subnet_mask)
        if hasattr(obj, 'kms_address'):
            self.config.set("SYSTEM", "kms_endpoint", obj.kms_address)
        self.config.set("IAM", "iam_address", obj.iam_karbor_address)
        self.config.set("OC", "oc_address", obj.om_url)

        flags = os.O_RDWR | os.O_CREAT
        modes = stat.S_IRUSR | stat.S_IWUSR
        self.config.write(os.fdopen(os.open(ini_path, flags, modes), 'w'))
