import utils.common.log as logger
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class ConfigKarbor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.karbor_node_list = self.karbor_util.get_karbor_node_list()[:2]
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._exec_config_karbor()
        except Exception as err:
            logger.info(f"Failed to config karbor, err_msg: {str(err)}.")
            return Message(RESULT_CODE['ERROR'], err, err)

    def _exec_config_karbor(self):
        self._config_karbor()
        self._restart_karbor_service()
        return Message(RESULT_CODE['SUCCESS'])

    def _config_karbor(self):
        karbor_ip_list = self.karbor_util.get_karbor_ip_list()
        karbor_ip_old = ",".join(karbor_ip_list)
        karbor_ip_new = ",".join(karbor_ip_list[:2])
        logger.info("Start to ssh karbor nodes and config karbor.")
        cmd_list = [
            'source /opt/huawei/dj/inst/utils.sh',
            f'sed -i "s#{karbor_ip_old}#{karbor_ip_new}#g" /opt/huawei/dj/cfg/sys.ini',
            'sed -i "s#karbor1,karbor2,karbor3#karbor1,karbor2#g" /opt/huawei/dj/cfg/sys.ini',
            'sed -i "s#profile =.*#profile = private_recover#g" /opt/huawei/dj/cfg/sys.ini',
            'db_float_ip=$(get_info gaussdb_float_ip);'
            f'sed -i "s#{karbor_ip_list[-1]}#${{db_float_ip}}#g" '
            '/opt/huawei/dj/etc/zookeeper/conf/zoo.cfg /opt/huawei/dj/etc/zookeeper/conf_arb/zoo.cfg',
            'rm -rf /opt/huawei/dj/bin/zookeeper/data/version-2',
            'rm -rf /opt/huawei/dj/bin/zookeeper/data_arb/version-2',
            'rm -rf /opt/huawei/dj/bin/rabbitmq/rabbit@${HOSTNAME}'
        ]
        cmds = ";".join(cmd_list)
        for node in self.karbor_node_list:
            karbor_client = self.ssh_client.get_ssh_client(node)
            result = self.ssh_client.ssh_exec_command_return(karbor_client, cmds)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                logger.error("Failed to exec cmds on karbor node, "
                             f"node ip:{node.node_ip}.")
                self.ssh_client.ssh_close(karbor_client)
                raise Exception("Failed to exec cmds on karbor node, "
                                f"node ip:{node.node_ip}.")
            logger.info("Succeed to exec cmds on karbor node, "
                        f"node ip:{node.node_ip}.")
            self.ssh_client.ssh_close(karbor_client)
        logger.info("Succeed to config all karbor nodes.")

    def _restart_karbor_service(self):
        cmd = "source /opt/huawei/dj/inst/utils.sh;DJserviceControl restart"
        logger.info("Start to restart service for all karbor nodes.")
        for node in self.karbor_node_list:
            karbor_client = self.ssh_client.get_ssh_client(node)
            result = self.ssh_client.ssh_exec_command_return(karbor_client, cmd)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                logger.error("Failed to restart karbor service, "
                             f"node ip:{node.node_ip}.")
                self.ssh_client.ssh_close(karbor_client)
                raise Exception("Failed to restart karbor service, "
                                f"node ip:{node.node_ip}.")
            logger.info("Succeed to restart karbor service, "
                        f"node ip:{node.node_ip}.")
            self.ssh_client.ssh_close(karbor_client)
        logger.info("Succeed to restart service for all karbor nodes.")
