# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.scripts.upgrade.ab_test.base import BaseTest


class QueryHostInfo(BaseTest):
    def __init__(self, project_id, pod_id, regionid_list=None):
        self.test_job_name = "sub_job_testcsbs_queryhostinfo"
        super(QueryHostInfo, self).__init__(project_id)
        self.pod_id = pod_id

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self.execute_test_job_tasks()
        except Exception as err:
            logger.trace()
            logger.error("Execute test job sub_job_testcsbs_queryhostinfo failed,"
                         " msg: {}.".format(err))
            return Message(500, HCCIException(645010))
        else:
            logger.info('Execute test job({}) '
                        'success.'.format(self.test_job_name))
            return Message(200)
