import utils.common.log as logger

from plugins.CSBS.common.upgrade import constant
from plugins.CSBS.scripts.upgrade.ab_test.tasks.test_util import get_checkpoint_item_detail
from plugins.CSBS.scripts.upgrade.ab_test.tasks.test_util import waiting_checkpoint_item_available

logger.init("CSBS-VBS")


class RestoreTest(object):
    def __init__(self, context, http_client):
        self.context = context
        self.http_client = http_client
        self.console_host = self.context.basic_mo_test["console_host"]
        self.project_id = self.context.user_info['project_id']

    def csbs_restore(self):
        csbs_backup_info = self.context.csbs_backup_info
        checkpoint_item_id = csbs_backup_info["checkpoint_item_id"]
        provider_id = constant.CSBS_PROVIDER_ID
        self._restore(checkpoint_item_id, provider_id)

    def vbs_restore(self):
        vbs_backup_info = self.context.vbs_backup_info
        checkpoint_item_id = vbs_backup_info["checkpoint_item_id"]
        provider_id = constant.VBS_PROVIDER_ID
        self._restore(checkpoint_item_id, provider_id)

    def _restore(self, checkpoint_item_id, provider_id):
        logger.info("Start to get copy information.")
        _, ret = get_checkpoint_item_detail(self.http_client,
                                            self.console_host,
                                            self.project_id,
                                            checkpoint_item_id)
        resource_id = ret["checkpoint_item"]["resource_id"]
        checkpoint_id = ret["checkpoint_item"]["checkpoint_id"]
        volume_backups = \
            ret["checkpoint_item"]["extend_info"]["volume_backups"]
        backup_id_list = []
        volume_id_list = []
        for volume_backup in volume_backups:
            backup_id_list.append(volume_backup['id'])
            volume_id_list.append(volume_backup['source_volume_id'])
        targets = self._make_targets(resource_id,
                                     backup_id_list,
                                     volume_id_list)
        logger.info("The information of vm that needs to be restored: "
                    "{}.".format(targets))
        logger.info("Perform restoring")

        url = "https://{console_host}/cbs/rest/karbor/v1/{project_id}" \
              "/restores".format(console_host=self.console_host,
                                 project_id=self.project_id)
        body_dict = {
            "restore": {
                "provider_id": provider_id,
                "checkpoint_id": checkpoint_id,
                "parameters": {
                    "checkpoint_item_id": checkpoint_item_id,
                    "power_on": True,
                    "targets": targets
                }
            }
        }
        _, ret = self.http_client.post(url, body=body_dict)

        logger.info("Succeed to issue performing restore, "
                    "the response: {}.".format(ret))
        waiting_checkpoint_item_available(self.http_client,
                                          self.console_host,
                                          self.project_id,
                                          checkpoint_item_id)
        logger.info("Restore finished!")
        return checkpoint_id, checkpoint_item_id

    @staticmethod
    def _make_targets(restore_server_id, backup_id_list, volume_id_list):
        targets = {
            "server_id": restore_server_id,
            "volumes": []
        }
        for i, backup_id in enumerate(backup_id_list):
            target = dict()
            target['backup_id'] = backup_id
            target['volume_id'] = volume_id_list[i]
            targets.get('volumes').append(target)
        logger.info('Make targets result is: \n {}.'.format(targets))
        return targets
