import time

import utils.common.log as logger


def get_checkpoint_item_list(http_client, console_host, project_id,
                             product_type="ecs"):
    url = f"https://{console_host}/cbs/rest/karbor/v1" \
          f"/{project_id}/checkpoint_items"
    if product_type == "evs":
        url += "?resource_type=OS::Cinder::Volume"
    return http_client.get(url)


def get_checkpoint_item_detail(http_client, console_host,
                               project_id, checkpoint_item_id):
    url = f"https://{console_host}/cbs/rest/karbor/v1/{project_id}" \
          f"/checkpoint_items/{checkpoint_item_id}"
    return http_client.get(url)


def waiting_checkpoint_item_available(http_client,
                                      console_host,
                                      project_id,
                                      checkpoint_item_id):
    cur_checkpoint_item_status = ''
    count = 0
    while cur_checkpoint_item_status != 'available':
        _, checkpoint_item_info = get_checkpoint_item_detail(
            http_client,
            console_host,
            project_id,
            checkpoint_item_id)
        cur_checkpoint_item_status = checkpoint_item_info.get('checkpoint_item', {}).get('status')
        if cur_checkpoint_item_status == "available":
            break

        if cur_checkpoint_item_status in ["protecting", "restoring",
                                          "copying"]:
            progress_status = checkpoint_item_info.get("checkpoint_item").get(
                "extend_info").get("progress")
            logger.info(f'Current task progress value: {progress_status}.')
        logger.info(f"Current copy's status:{cur_checkpoint_item_status}.")

        if cur_checkpoint_item_status == "error":
            raise Exception(
                "Copy's status is error, task failed, please check.")

        count = count + 1
        if count > 200:
            raise Exception(
                "There may be some problem, 100 minutes passed.")
        time.sleep(30)

    logger.info("The checkpoint_item is available now.")

    return checkpoint_item_id
