/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.service.command;

import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.ConnectPolicy;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface INodeAgentCommand {
    public NodeAgentLocalService.Iface getNodeAgentLocalService();

    public String getCommandName();

    default public boolean isCrossMode() {
        return false;
    }

    public long getErrorCode();

    default public CommandReaction<Map<Node, Response>> execute(List<Node> nodes, String[] args) {
        ConnectPolicy connectPolicy = new ConnectPolicy().setCrossMode(this.isCrossMode());
        Command command = new Command(this.getCommandName());
        command.params = args != null ? Arrays.asList(args) : Collections.emptyList();
        return CommandReaction.get(() -> this.getNodeAgentLocalService().execute(command, nodes, connectPolicy), false, this.getErrorCode());
    }

    default public CommandReaction<Map<Node, Response>> execute(List<Node> nodes, Parameter ... parameters) {
        Parameter parameter = Parameter.combine(parameters);
        ArrayList<String> args = new ArrayList<String>();
        Map<String, String> opts = parameter.getOpts();
        this.getArguments().forEach(arg -> INodeAgentCommand.initArgs(args, opts, arg));
        args.addAll(parameter.getArgs());
        return this.execute(nodes, args.toArray(new String[0]));
    }

    public static void initArgs(List<String> args, Map<String, String> opts, String item) {
        if (!item.startsWith("#")) {
            args.add(opts.getOrDefault(item, ""));
        } else {
            args.add(item.substring(1));
        }
    }

    default public List<String> getArguments() {
        return Collections.emptyList();
    }
}

