/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

public final class Base64 {
    private static final char[] INT_TO_BASE_64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] INT_TO_ALT_BASE_64 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', ',', '-', '.', ':', ';', '<', '>', '@', '[', ']', '^', '`', '_', '{', '|', '}', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '?'};
    private static final byte[] BASE_64_TO_INT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] ALT_BASE_64_TO_INT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 62, 9, 10, 11, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 12, 13, 14, -1, 15, 63, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, 18, 19, 21, 20, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 22, 23, 24, 25};
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOURE = 4;
    private static final int SIX = 6;
    private static final int MASK_255 = 255;
    private static final int MASK_63 = 63;

    private Base64() {
    }

    public static String byteArrayToBase64(byte[] paramArrayOfByte) {
        return Base64.byteArrayToBase64(paramArrayOfByte, false);
    }

    public static byte[] base64ToByteArray(String paramString) {
        return Base64.base64ToByteArray(paramString, false);
    }

    private static String byteArrayToBase64(byte[] paramArrayOfByte, boolean paramBoolean) {
        int i2;
        int i1;
        int paramArrayOfByteLength = paramArrayOfByte.length;
        int jTemp = paramArrayOfByteLength / 3;
        int kTemp = paramArrayOfByteLength - 3 * jTemp;
        int mTemp = 4 * ((paramArrayOfByteLength + 2) / 3);
        StringBuffer localStringBuffer = new StringBuffer(mTemp);
        char[] arrayOfChar = paramBoolean ? INT_TO_ALT_BASE_64 : INT_TO_BASE_64;
        int nTemp = 0;
        for (i1 = 0; i1 < jTemp; ++i1) {
            i2 = paramArrayOfByte[nTemp++] & 0xFF;
            int i3 = paramArrayOfByte[nTemp++] & 0xFF;
            int i4 = paramArrayOfByte[nTemp++] & 0xFF;
            localStringBuffer.append(arrayOfChar[i2 >> 2]);
            localStringBuffer.append(arrayOfChar[i2 << 4 & 0x3F | i3 >> 4]);
            localStringBuffer.append(arrayOfChar[i3 << 2 & 0x3F | i4 >> 6]);
            localStringBuffer.append(arrayOfChar[i4 & 0x3F]);
        }
        if (kTemp != 0) {
            i1 = paramArrayOfByte[nTemp++] & 0xFF;
            localStringBuffer.append(arrayOfChar[i1 >> 2]);
            if (kTemp == 1) {
                localStringBuffer.append(arrayOfChar[i1 << 4 & 0x3F]);
                localStringBuffer.append("==");
            } else {
                i2 = paramArrayOfByte[nTemp++] & 0xFF;
                localStringBuffer.append(arrayOfChar[i1 << 4 & 0x3F | i2 >> 4]);
                localStringBuffer.append(arrayOfChar[i2 << 2 & 0x3F]);
                localStringBuffer.append('=');
            }
        }
        return localStringBuffer.toString();
    }

    private static byte[] base64ToByteArray(String paramString, boolean paramBoolean) {
        int i4;
        int i3;
        byte[] arrayOfByte1 = paramBoolean ? ALT_BASE_64_TO_INT : BASE_64_TO_INT;
        int paramStringLength = paramString.length();
        int paramStringLengthDivide4 = paramStringLength / 4;
        if (4 * paramStringLengthDivide4 != paramStringLength) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int temp = 0;
        int divide4 = paramStringLengthDivide4;
        if (paramStringLength != 0) {
            if (paramString.charAt(paramStringLength - 1) == '=') {
                ++temp;
                --divide4;
            }
            if (paramString.charAt(paramStringLength - 2) == '=') {
                ++temp;
            }
        }
        byte[] arrayOfByte2 = new byte[3 * paramStringLengthDivide4 - temp];
        int n = 0;
        int i1 = 0;
        int i2 = 0;
        for (i2 = 0; i2 < divide4; ++i2) {
            i3 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            i4 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            int i5 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            int i6 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            arrayOfByte2[i1++] = (byte)(i3 << 2 | i4 >> 4);
            arrayOfByte2[i1++] = (byte)(i4 << 4 | i5 >> 2);
            arrayOfByte2[i1++] = (byte)(i5 << 6 | i6);
        }
        if (temp != 0) {
            i2 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            i3 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
            arrayOfByte2[i1++] = (byte)(i2 << 2 | i3 >> 4);
            if (temp == 1) {
                i4 = Base64.base64toInt(paramString.charAt(n++), arrayOfByte1);
                arrayOfByte2[i1++] = (byte)(i3 << 4 | i4 >> 2);
            }
        }
        return arrayOfByte2;
    }

    private static int base64toInt(char paramChar, byte[] paramArrayOfByte) {
        byte temp = paramArrayOfByte[paramChar];
        if (temp < 0) {
            throw new IllegalArgumentException("Illegal character " + paramChar);
        }
        return temp;
    }
}

