/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.checker;

import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.openstack.cert.checker.ConnectionStatus;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.wcc.rest.client.HttpsConnectTestRestClient;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractConnectionCheck {
    private static final Log LOG = LogFactory.getInstance(AbstractConnectionCheck.class);
    private static final String DEFUALT_BUNDLE_NAME = "DRM_Base";
    private static final String HTTPS_PREFIX = "https://";
    private boolean isForceCheckCert = Boolean.FALSE;

    abstract void doConnect() throws Exception;

    abstract String getServiceName();

    public boolean getForceCheckCert() {
        return this.isForceCheckCert;
    }

    public ConnectionStatus getConnectStatus(boolean isForceCheckCert) {
        this.isForceCheckCert = isForceCheckCert;
        try {
            this.doConnect();
        }
        catch (Exception e) {
            LOG.error((Object)"ConnectionCheck of serviceName:%s fail,msg:%s", new Object[]{this.getServiceName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            if ("SSLHandshakeException".equals(e.getMessage())) {
                return ConnectionStatus.CONNECTION_SSL_FAIL;
            }
            return ConnectionStatus.CONNECTION_FAIL;
        }
        return ConnectionStatus.CONNECTION_SUCCESS;
    }

    protected void sendTestConnection(String domain, String port) throws Exception {
        if (VerifyUtil.isEmpty((String)domain) || VerifyUtil.isEmpty((String)port)) {
            LOG.warn((Object)"End to execute sendTestConnection of %s, cause domain or port is empty.", new Object[]{this.getServiceName()});
            return;
        }
        String normalizeDomain = this.normalizeDomain(domain);
        LOG.info((Object)"Start to sendTestConnection serviceName:%s, domain:%s, port:%s", new Object[]{this.getServiceName(), domain, port});
        HttpsConnectTestRestClient client = new HttpsConnectTestRestClient(normalizeDomain, port, this.isForceCheckCert);
        client.doGet("", new HashMap());
    }

    protected void sendTestConnection(String url) throws Exception {
        String port;
        if (VerifyUtil.isEmpty((String)url)) {
            LOG.warn((Object)"End to execute sendTestConnection of %s, cause url is empty.", new Object[]{this.getServiceName()});
            return;
        }
        int indexOfDomain = url.lastIndexOf(":");
        if (indexOfDomain == -1) {
            LOG.error((Object)"Failed to sendTestConnect, cause url:%s format error.", new Object[]{url});
            throw new LegoCheckedException(-1L);
        }
        String domain = url.substring(0, indexOfDomain);
        String portAndPath = url.substring(indexOfDomain + 1);
        String path = "";
        int indexOfPort = portAndPath.indexOf("/");
        if (indexOfPort == -1) {
            port = portAndPath;
        } else {
            port = portAndPath.substring(0, indexOfPort);
            path = portAndPath.substring(indexOfPort);
        }
        String normalizeDomain = this.normalizeDomain(domain);
        LOG.info((Object)"Start to sendTestConnection domain:%s, port:%s", new Object[]{normalizeDomain, port});
        HttpsConnectTestRestClient client = new HttpsConnectTestRestClient(normalizeDomain, port, this.isForceCheckCert);
        client.doGet(path, new HashMap());
    }

    protected <T> T getBundleService(Class<T> serviceClass) {
        return (T)ServiceLocator.getBundleService((String)DEFUALT_BUNDLE_NAME, (String)serviceClass.getName(), serviceClass);
    }

    protected Set<String> getRegionUuids() {
        HashSet<String> regionUuids = new HashSet<String>();
        List drResources = CloudServiceUtil.findDrResources(DrResource.class, null, null, null, (boolean)Boolean.FALSE);
        if (VerifyUtil.isEmpty((Collection)drResources)) {
            LOG.warn((Object)"DrResources of connectionCheck is empty.");
            return regionUuids;
        }
        DrResource drResource = (DrResource)drResources.get(0);
        String openstackUuid = drResource.getDeviceSn();
        IOpenstackResourceService openstackResourceService = (IOpenstackResourceService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IOpenstackResourceService.class.getName(), IOpenstackResourceService.class);
        List endPoints = openstackResourceService.getEndPointFromDB(openstackUuid);
        endPoints.forEach(endPoint -> regionUuids.add(OpenStackCommonUtil.getIdFromUuid(endPoint.getRegionUuid())));
        return regionUuids;
    }

    protected Optional<String> getBaseUrl(String regionUuid, String serviceType) {
        try {
            return Optional.of(ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, serviceType));
        }
        catch (LegoCheckedException e) {
            LOG.warn((Object)"End to execute SfsConnectionCheck. cause base url not find.");
            return Optional.empty();
        }
    }

    private String normalizeDomain(String domain) {
        if (domain.startsWith(HTTPS_PREFIX)) {
            return domain.substring(HTTPS_PREFIX.length());
        }
        return domain;
    }
}

