/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.service.ISysCertRmiService;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.OpenStackCertificateConstants;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.List;

public class OpenStackQueryCrlTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(OpenStackQueryCrlTask.class);
    private static final String QUERY_CRL_FAILED_ID = "QUERY_CRL_FAILED_ID";
    private List<CertificateSummary> summaries;

    public OpenStackQueryCrlTask(List<CertificateSummary> summaries) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)"ism.drm.cert.querycrl", (String)"System", (String)"", null), false);
        this.summaries = summaries;
    }

    public List<CertificateSummary> getCertificateSummaries() {
        return this.summaries;
    }

    protected void doWork() {
        LOG.info((Object)"Start OpenStackQueryCrlTask..");
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.error((Object)"Register certificate, but server url or region is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
            String tokenId = TokenUtil.getInstance().getTokenId(open, null);
            String fullUrl = "https://" + urlStr + OpenStackCertificateConstants.RequestUrl.QUERY_CRL.getUri();
            String response = ClientUtil.sendGetRequest(fullUrl, tokenId);
            if (VerifyUtil.isEmpty((String)response)) {
                LOG.error((Object)"Response is empty.");
                return;
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)response);
            JSONObject dataObj = jsonObject.getJSONObject("data");
            if (null != dataObj) {
                String crl = dataObj.getString("crl");
                ISysCertRmiService srSvc = (ISysCertRmiService)ServiceLocator.getInstance().getService(ISysCertRmiService.class);
                srSvc.analysisCrl(crl);
            } else {
                LOG.error((Object)"Data is empty.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Load crl error.", (Throwable)e);
            this.sendAlarm();
            ExceptionUtil.rethrowException((Throwable)e, (String)"query crl error.", (long)-1L, (String[])new String[0], (Log)LOG);
        }
        AlarmReporter.restoreAlarm((long)52625511L, (String[])new String[]{QUERY_CRL_FAILED_ID});
    }

    private void sendAlarm() {
        String serverIp = new LegoMoGenerator().getInstallServerIp();
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        String[] ipPort = urlStr.split(":");
        String certIp = ipPort[0];
        String certPort = ipPort[1];
        String[] params = new String[]{serverIp, QUERY_CRL_FAILED_ID, certIp, certPort};
        AlarmReporter.sendAlarmForNoRepeat((long)52625511L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])params);
    }
}

