/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.subscriber;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class OpenstackMsgSubscriber
extends MessageTaskManager {
    private static final Log LOG = LogFactory.getInstance(OpenstackMsgSubscriber.class);

    public OpenstackMsgSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (105L != msgType) {
            LOG.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof FusionSphereOpenStack)) continue;
            NetworkEntity ne = (NetworkEntity)obj;
            DrFusionSphereOpenStack drResource = (DrFusionSphereOpenStack)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySnInLocalSite(ne.getSn(), "ism.drm.deviceType.fusionsphere.mainType");
            if (null == drResource) continue;
            Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            try {
                LOG.warn((Object)("Resource(" + ne.getName() + ") is used."), 90160758786989L);
                Criteria criteria = session.createCriteria(OpenStackAvailabilityZoneMapping.class);
                criteria.add((Criterion)Restrictions.like((String)"uuid", (Object)(ne.getSn() + "%")));
                List azMappings = criteria.list();
                for (OpenStackAvailabilityZoneMapping mapping : azMappings) {
                    session.delete((Object)mapping);
                }
                session.flush();
                criteria = session.createCriteria(OpenStackVolTypeMapping.class);
                criteria.add((Criterion)Restrictions.like((String)"uuid", (Object)(ne.getSn() + "%")));
                List volTypeMappings = criteria.list();
                for (OpenStackVolTypeMapping mapping : volTypeMappings) {
                    session.delete((Object)mapping);
                }
                session.flush();
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)drResource);
            }
            finally {
                DBOperationUtil.closeSession((Session)session);
            }
        }
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }
}

