/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.observer;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.ConfigVMMetaTask;
import com.huawei.ism.drm.openstack.protection.service.DelPlaceHoldVMTask;
import com.huawei.ism.drm.openstack.protection.service.LockVMTask;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.sdk.bo.ConsistentGroupReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceServiceImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class ProtectGroupOperateObserver
implements IObjectObserver {
    private static final Log LOG = LogFactory.getInstance(ProtectGroupOperateObserver.class);
    private static final ConcurrentHashMap<String, AtomicLong> PROTECT_GROUP_CREATING_COUNTER = new ConcurrentHashMap();
    private Map<String, List<ProtectObject>> removedPos = new HashMap<String, List<ProtectObject>>();
    private Map<String, List<ProtectObject>> addPos = new HashMap<String, List<ProtectObject>>();
    private IVolumeService volumeService;
    private String traceInfo = " trace ";

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public void before(MessageEvent event) {
        LOG.info((Object)"Enter before");
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup;
            if (!(object instanceof ProtectGroup) || !this.checkParam(protectGroup = (ProtectGroup)object)) continue;
            if (messageType == 2) {
                this.operateDeleteProtectGroup(protectGroup);
            } else if (messageType == 4) {
                this.openrateRemoveProtectObject(protectGroup, event);
            } else if (messageType == 1) {
                this.operateRefreshProtectGroup(protectGroup);
            } else if (messageType == 0) {
                this.handleCache(protectGroup);
            } else if (messageType == 3) {
                this.getAddPos(protectGroup);
            }
            if (messageType == 9) {
                this.checkMaintainServiceInstance(protectGroup, false);
                continue;
            }
            if (messageType != 8) continue;
            this.checkMaintainServiceInstance(protectGroup, true);
        }
    }

    private void handleCache(ProtectGroup protectGroup) {
        this.clearCache(protectGroup, this.addPos);
        this.addPos.get(protectGroup.getUuid()).addAll(protectGroup.getPolist());
        AtomicLong counter = PROTECT_GROUP_CREATING_COUNTER.putIfAbsent(protectGroup.getName(), new AtomicLong(1L));
        if (counter != null) {
            counter.incrementAndGet();
            LOG.error((Object)"Instance name repeated!, instanceName=%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947717L);
        }
    }

    private void getAddPos(ProtectGroup protectGroup) {
        this.clearCache(protectGroup, this.addPos);
        ProtectGroup dbPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid(), false);
        for (ProtectObject po : protectGroup.getPolist()) {
            if (dbPg.getPolist().contains(po)) continue;
            this.addPos.get(protectGroup.getUuid()).add(po);
        }
    }

    private void operateRefreshProtectGroup(ProtectGroup protectGroup) {
        if ("true".equals(protectGroup.getProps().get("OBJ_DELETE_ERROR"))) {
            LOG.info((Object)"The protectgroup is invalid,cant refresh it,pgName=%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948195L);
        }
        LOG.debug((Object)"Refresh openstack sucessfully:%s", new Object[]{protectGroup.getName()});
    }

    private void operateDeleteProtectGroup(ProtectGroup protectGroup) {
        try {
            this.deleteProtectGroupResource(protectGroup);
        }
        catch (Exception e) {
            protectGroup.getProps().put("OBJ_DELETE_ERROR", "true");
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus.INVALID, new String[]{protectGroup.getUuid()});
            LOG.error((Object)("Delete openstack resource failed. pgName:" + protectGroup.getName() + ". pgUuid:" + protectGroup.getUuid()));
            throw LegoCheckedException.cast((Throwable)e, (long)1073948412L, (String[])new String[0]);
        }
    }

    private void openrateRemoveProtectObject(ProtectGroup protectGroup, MessageEvent event) {
        if (protectGroup.isInvalid() || "true".equals(protectGroup.getProps().get("OBJ_DELETE_ERROR"))) {
            LOG.info((Object)"The protectgroup is invalid,cant refresh it,pgname=%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948195L);
        }
        Map itemMap = ProtectionToolsUtil.getInstance().getResultItemMap(event);
        if (VerifyUtil.isEmpty((Map)itemMap)) {
            LOG.error((Object)"Result item map is empty");
            throw new LegoCheckedException(1073947393L);
        }
        Set<ProtectObject> optSuccPos = this.deleteReplicationPairAndVolumeInVm(protectGroup, itemMap);
        this.debugResult(itemMap);
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        boolean needDelete = ProtectGroupOperateObserver.isNeedDeletePhVm(protectGroup);
        List<Callable<PhVmInfo>> rmVmTaskList = ProtectGroupOperateObserver.getDelPhVmTaskList(optSuccPos, protectGroup, needDelete);
        if (VerifyUtil.isEmpty(rmVmTaskList)) {
            return;
        }
        List retPhVmList = ExecutionService.batchSubmit(rmVmTaskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)timeout, (int)batchNum);
        LOG.info((Object)"Delete phvm complete:ret size=%s, taskSize=%s", new Object[]{String.valueOf(retPhVmList.size()), String.valueOf(rmVmTaskList.size())});
        if (protectGroup.getTemplate().getType() == 37) {
            OpenStackCommonUtil.executeTask(this.getRemoveUnlockTask(protectGroup), ExecutionService.ExecuteType.FAILED_ABORT, true);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,unlock CSHA phVm success.", new Object[]{protectGroup.getName()});
        }
        this.dealDelPhVmTasks(itemMap, optSuccPos, retPhVmList);
        this.debugResult(itemMap);
    }

    private List<Callable<Boolean>> getRemoveUnlockTask(ProtectGroup protectGroup) {
        ArrayList<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        for (ProtectObject po : this.removedPos.get(protectGroup.getUuid())) {
            String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
            if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", phvmUuid is empty:replicaInfoStr=" + replicationInfo));
                continue;
            }
            taskList.add(new LockVMTask(protectGroup, phVm.getVmUuid(), projId, regionId));
        }
        return taskList;
    }

    private static boolean isNeedDeletePhVm(ProtectGroup protectGroup) {
        boolean needDelete = true;
        ServiceInstanceServiceImpl service = new ServiceInstanceServiceImpl();
        String instanceType = (String)protectGroup.getProps().get("serviceInstanceType");
        if (service.isNeedCheckOccupiedVm(instanceType)) {
            needDelete = false;
        }
        return needDelete;
    }

    private void debugResult(Map<String, TaskResultItem> itemMap) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<String, TaskResultItem> entry : itemMap.entrySet()) {
                LOG.debug((Object)"Po(%s) del result is %s", new Object[]{entry.getKey(), entry.getValue().getResult()});
            }
        }
    }

    private Set<ProtectObject> deleteReplicationPairAndVolumeInVm(ProtectGroup protectGroup, Map<String, TaskResultItem> itemMap) {
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        List<ProtectObject> willRemovePos = this.getWillRemovePos(protectGroup);
        this.filterStillUsedVolumeInfo(protectGroup, willRemovePos, "replicationInfo");
        this.filterStillUsedVolumeInfo(protectGroup, willRemovePos, "hypermetor_replicationInfo");
        this.filterStillUsedVolumeInfo(protectGroup, willRemovePos, "remote_replicationInfo");
        List<Callable<PoReplicaInfo>> reattachTasks = this.getReattachVolumeTasks(willRemovePos);
        List reattachInfos = ExecutionService.batchSubmit(reattachTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)timeout, (int)batchNum);
        LOG.info((Object)"Reattach volume complete:ret size=%s, taskSize=%s", new Object[]{String.valueOf(reattachInfos.size()), String.valueOf(reattachTasks.size())});
        HashMap<String, List<String>> sideMap = new HashMap<String, List<String>>();
        Set<ProtectObject> succRemoveReplicaPoSet = this.removeReplicaFromCg(protectGroup, willRemovePos, itemMap, sideMap);
        if (VerifyUtil.isEmpty(succRemoveReplicaPoSet)) {
            LOG.error((Object)"Has no success of replication removings");
            return new HashSet<ProtectObject>();
        }
        ArrayList<FutureResult<PoReplicaPairInfo>> failures = new ArrayList<FutureResult<PoReplicaPairInfo>>();
        boolean success = this.deleteReplicaPairs(protectGroup, succRemoveReplicaPoSet, sideMap, OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue(), failures, batchNum, timeout);
        success = success && this.deleteReplicaPairs(protectGroup, succRemoveReplicaPoSet, sideMap, "standbyside", failures, batchNum, timeout);
        success = success && this.deleteReplicaPairs(protectGroup, succRemoveReplicaPoSet, sideMap, "activeside", failures, batchNum, timeout);
        boolean bl = success = success && this.deleteReplicaPairs(protectGroup, succRemoveReplicaPoSet, sideMap, "hypermetorside", failures, batchNum, timeout);
        if (!success) {
            LOG.error((Object)"Delete replica pair failed.");
        }
        reattachTasks.forEach(obj -> {
            if (obj instanceof ReattachVolumeTask) {
                ((ReattachVolumeTask)obj).setAfterHyperMetroDel(true);
            }
        });
        ExecutionService.batchSubmit(reattachTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)timeout, (int)batchNum);
        return this.dealRemoveTaskResults(succRemoveReplicaPoSet, failures, itemMap);
    }

    private boolean deleteReplicaPairs(ProtectGroup protectGroup, Collection<ProtectObject> poList, Map<String, List<String>> sideMap, String side, List<FutureResult<PoReplicaPairInfo>> failures, int ... opts) {
        int batchNum = opts[0];
        int timeout = opts[1];
        return sideMap.getOrDefault(side, Collections.emptyList()).stream().allMatch(name -> this.deleteReplicaPairs(protectGroup, poList, (String)name, side, failures, batchNum, timeout));
    }

    private boolean deleteReplicaPairs(ProtectGroup protectGroup, Collection<ProtectObject> poList, String key, String side, List<FutureResult<PoReplicaPairInfo>> failures, int ... opts) {
        List<Callable<PoReplicaPairInfo>> taskList;
        int batchNum = opts[0];
        int timeout = opts[1];
        LOG.info((Object)"Begin to delete replicaion at side %s, real side:%s,protectGroup name=%s,serviceInstanceType=%s", new Object[]{key, side, protectGroup.getName(), protectGroup.getProps().get("serviceInstanceType")});
        String serviceInstanceType = (String)protectGroup.getProps().get("serviceInstanceType");
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceInstanceType) && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceInstanceType)) {
            key = null;
            side = null;
        }
        if (VerifyUtil.isEmpty(taskList = OpenStackCommonUtil.getTaskList(this.volumeService, poList, protectGroup, key, side, new DelTagParam()))) {
            LOG.info((Object)"Delete replication task list is empty");
            return true;
        }
        List retPairInfoList = ExecutionService.execute(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)timeout, (int)batchNum);
        LOG.info((Object)"Delete replication at side %s, complete:ret size =%s, taskSize =%s", new Object[]{side, retPairInfoList.size(), taskList.size()});
        Collection failedResults = FutureResult.getFailedResults((Collection)retPairInfoList);
        failures.addAll(failedResults);
        return failedResults.isEmpty();
    }

    private void dealDelPhVmTasks(Map<String, TaskResultItem> itemMap, Set<ProtectObject> optSuccPos, List<PhVmInfo> retPhVmList) {
        for (ProtectObject po : optSuccPos) {
            boolean hasFailed = true;
            for (PhVmInfo vm : retPhVmList) {
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
                if (null == poReplicaInfo) {
                    LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
                if (!phVm.getVmUuid().equals(vm.getVmUuid())) continue;
                LOG.info((Object)"Phmv(%s) has deleted.", new Object[]{vm.getVmUuid()});
                hasFailed = false;
                break;
            }
            if (!hasFailed) continue;
            this.updateResultItem(itemMap, po.getUuid(), new LegoCheckedException(-1L, new String[0]));
        }
    }

    private void filterStillUsedVolumeInfo(ProtectGroup protectGroup, List<ProtectObject> willRemovePos, String replicaKey) {
        PoReplicaInfo poReplicaInfo;
        HashSet<String> stillUsedUuidSet = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            String replicationInfo = po.getProperty(replicaKey);
            if (null == replicationInfo) {
                LOG.warn((Object)"Can not find replicaKey:%s for po:%s", new Object[]{replicaKey, po.getName()});
                continue;
            }
            poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            for (Object pairInfo : poReplicaInfo.getPairInfos()) {
                if (VerifyUtil.isEmpty((String)pairInfo.getVolumeUuid())) continue;
                stillUsedUuidSet.add(pairInfo.getVolumeUuid());
            }
        }
        for (ProtectObject po : willRemovePos) {
            String replicaStr = (String)po.getProps().get(replicaKey);
            if (null == replicaStr) {
                LOG.warn((Object)"Can not find replicaKey:%s for po:%s", new Object[]{replicaKey, po.getName()});
                continue;
            }
            poReplicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("Json to bean error:replicaInfoStr=" + replicaStr));
                continue;
            }
            ArrayList pairList = new ArrayList(poReplicaInfo.getPairInfos());
            for (PoReplicaPairInfo pairInfo : pairList) {
                if (!stillUsedUuidSet.contains(pairInfo.getVolumeUuid())) continue;
                LOG.info((Object)"The volume still be used by other po,please check it.volumeName:%s", new Object[]{pairInfo.getVolumeName()});
                poReplicaInfo.getPairInfos().remove(pairInfo);
            }
            String newReplicaInfoStr = JsonUtil.beanToJson(poReplicaInfo);
            po.getProps().put(replicaKey, newReplicaInfoStr);
        }
    }

    private Collection<String> castPoReplicaPairInfoToVolumeUuid(Collection<PoReplicaPairInfo> ... replicas) {
        return Stream.of(replicas).flatMap(Collection::stream).map(PoReplicaPairInfo::getVolumeUuid).collect(Collectors.toSet());
    }

    private Set<ProtectObject> dealRemoveTaskResults(Set<ProtectObject> poList, List<FutureResult<PoReplicaPairInfo>> failures, Map<String, TaskResultItem> itemMap) {
        HashSet<ProtectObject> successSet = new HashSet<ProtectObject>();
        for (ProtectObject po : poList) {
            LegoCheckedException[] errors = (LegoCheckedException[])failures.stream().map(failure -> LegoCheckedException.cast((Throwable)failure.getCause(), (long)1073948412L, (String[])new String[0])).toArray(LegoCheckedException[]::new);
            if (errors.length == 0) {
                this.updateResultItem(itemMap, po.getUuid(), new LegoCheckedException[0]);
                successSet.add(po);
                continue;
            }
            LOG.error((Object)("There may be some volume(s) deletion failure or timeout. po: " + po.getName()));
            this.updateResultItem(itemMap, po.getUuid(), errors);
        }
        return successSet;
    }

    private boolean hasRemoveFailedVolumes(ProtectObject po, Collection<String> replicaKeys, Collection<String> deletedVolumes) {
        return replicaKeys.stream().map(key -> (PoReplicaInfo)po.getProperty(key, PoReplicaInfo.class)).filter(Objects::nonNull).map(PoReplicaInfo::getPairInfos).flatMap(Collection::stream).map(PoReplicaPairInfo::getVolumeUuid).anyMatch(uuid -> !deletedVolumes.contains(uuid));
    }

    private List<ProtectObject> getWillRemovePos(ProtectGroup protectGroup) {
        this.clearCache(protectGroup, this.removedPos);
        ProtectGroup dbPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid(), false);
        for (ProtectObject po : dbPg.getPolist()) {
            if (protectGroup.getPolist().contains(po)) continue;
            this.removedPos.get(protectGroup.getUuid()).add(po);
        }
        return this.removedPos.get(protectGroup.getUuid());
    }

    private void clearCache(ProtectGroup protectGroup, Map<String, List<ProtectObject>> cache) {
        if (cache.containsKey(protectGroup.getUuid())) {
            cache.get(protectGroup.getUuid()).clear();
        } else {
            cache.put(protectGroup.getUuid(), new ArrayList());
        }
    }

    private Set<ProtectObject> removeReplicaFromCg(ProtectGroup protectGroup, List<ProtectObject> willRemovePos, Map<String, TaskResultItem> itemMap, Map<String, List<String>> sideMap) {
        List<ConsistentGroupReplicaInfo> replicas = OpenStackCommonUtil.getReplicas(protectGroup);
        boolean ring = replicas.stream().allMatch(ConsistentGroupReplicaInfo::isValidated);
        if (ring) {
            OpenStackCommonUtil.closeRing(this.volumeService, replicas);
        }
        Map<String, List<String>> actualStatusMapping = OpenStackCommonUtil.getRealStatusSideMapping(protectGroup, false);
        if (ring) {
            actualStatusMapping.put("hypermetorside", Collections.singletonList("hypermetorside"));
        } else {
            actualStatusMapping.remove("standbyside");
        }
        sideMap.putAll(actualStatusMapping);
        Map<String, List<ConsistentGroupReplicaInfo>> replicaSideMapping = OpenStackCommonUtil.castSideMappingToReplicaMapping(protectGroup, actualStatusMapping, replicas);
        HashSet<ProtectObject> succRemoveReplicaPoSet = new HashSet<ProtectObject>();
        boolean done = this.removeAllReplicas(itemMap, replicaSideMapping, willRemovePos, OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue());
        done = done && this.removeAllReplicas(itemMap, replicaSideMapping, willRemovePos, "standbyside");
        done = done && this.removeAllReplicas(itemMap, replicaSideMapping, willRemovePos, "activeside");
        done = done && this.removeAllReplicas(itemMap, replicaSideMapping, willRemovePos, "hypermetorside");
        for (ProtectObject po : willRemovePos) {
            if (done) {
                succRemoveReplicaPoSet.add(po);
                continue;
            }
            LOG.error((Object)"RemoveReplicas error, po: %s, mo uuid: %s", new Object[]{po.getName(), po.getMoUuid()});
        }
        if (ring) {
            try {
                OpenStackCommonUtil.openRing(this.volumeService, replicas);
            }
            catch (LegoCheckedException e) {
                for (ProtectObject po : willRemovePos) {
                    po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
                    po.getProps().put("TOBEDELETED", "true");
                    protectGroup.getPolist().add(po);
                    LOG.error((Object)"Delete protect object error, po: %s, mo uuid: %s", new Object[]{po.getName(), po.getMoUuid()});
                }
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
                throw e;
            }
        }
        return succRemoveReplicaPoSet;
    }

    private boolean removeAllReplicas(Map<String, TaskResultItem> itemMap, Map<String, List<ConsistentGroupReplicaInfo>> replicaSideMapping, List<ProtectObject> willRemovePos, String side) {
        String state;
        boolean done;
        List replicas = replicaSideMapping.getOrDefault(side, Collections.emptyList());
        LegoCheckedException errors = null;
        if (replicas.size() >= 1) {
            errors = this.removeAllReplicas((ConsistentGroupReplicaInfo)replicas.get(0), willRemovePos);
        }
        boolean bl = done = errors == null;
        if (done) {
            state = "success";
        } else {
            state = "failed";
            for (ProtectObject po : willRemovePos) {
                this.updateResultItem(itemMap, po.getUuid(), errors);
            }
        }
        LOG.info((Object)"Remove %s  side replicas %s", new Object[]{side, state});
        return done;
    }

    private LegoCheckedException removeAllReplicas(ConsistentGroupReplicaInfo replica, List<ProtectObject> willRemovePos) {
        String projId = replica.getProjUuid();
        String regionId = replica.getRegionUuid();
        String drProjId = replica.getDrProjUuid();
        String drRegionId = replica.getDrRegionUuid();
        String cgId = replica.getCgUuid();
        String drCgId = replica.getDrCgUuid();
        HashSet<String> removeSrcRepIds = new HashSet<String>();
        HashSet<String> removeDrRepIds = new HashSet<String>();
        String side = replica.getSide();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("standbyside", "remote_replicationInfo");
        map.put("activeside", "replicationInfo");
        map.put("hypermetorside", "hypermetor_replicationInfo");
        String key = (String)map.get(side);
        for (ProtectObject po : willRemovePos) {
            String poReplicaStr = (String)po.getProps().get(key);
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaStr, PoReplicaInfo.class);
            if (null == poReplicaInfo || VerifyUtil.isEmpty((Collection)poReplicaInfo.getPairInfos())) {
                LOG.info((Object)"This po has no replication to be operated:poName=%s", new Object[]{po.getName()});
                return null;
            }
            for (PoReplicaPairInfo replicaPair : poReplicaInfo.getPairInfos()) {
                removeSrcRepIds.add(replicaPair.getReplicaUuid());
                removeDrRepIds.add(replicaPair.getDrReplicaUuid());
            }
        }
        try {
            if (!VerifyUtil.isEmpty(removeSrcRepIds)) {
                this.volumeService.updateVolumeReplicationCG(regionId, projId, cgId, null, removeSrcRepIds);
            }
            if (!VerifyUtil.isEmpty(removeDrRepIds)) {
                this.volumeService.updateVolumeReplicationCG(drRegionId, drProjId, drCgId, null, removeDrRepIds);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Delete po resource error: replication side=%s, exception=%s", new Object[]{side, ExceptionUtil.getErrorMessage((Throwable)e)});
            return LegoCheckedException.cast((Throwable)e, (long)0x300001L, (String[])new String[0]);
        }
        return null;
    }

    private void updateResultItem(Map<String, TaskResultItem> resultItemMap, String poUuid, LegoCheckedException ... errors) {
        TaskResultItem item = resultItemMap.get(poUuid);
        if (null == item) {
            return;
        }
        if (errors == null || errors.length == 0) {
            item.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
            item.setDetail("ism.drm.site.success");
            return;
        }
        item.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
        item.setDetail(LegoCheckedException.combine((LegoCheckedException[])errors).i18n());
    }

    private boolean checkParam(ProtectGroup protectGroup) {
        if (!protectGroup.isPrimary()) {
            return false;
        }
        List<Integer> openstackArray = Arrays.asList(22, 21, 25, 29, 34, 37);
        return openstackArray.contains(protectGroup.getTemplate().getType());
    }

    private void deleteProtectGroupResource(ProtectGroup protectGroup) {
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String cgId = (String)protectGroup.getProps().get("replicaCgUuid");
        String drCgId = (String)protectGroup.getProps().get("drReplicaCgUuid");
        String splitFlag = (String)protectGroup.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        List<Callable<Callable>> reattachTasks = this.getReattachVolumeTasks(protectGroup.getPolist());
        OpenStackCommonUtil.executeTask(reattachTasks, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionId, projId);
        DrExtendManager mgr = new DrExtendManager();
        String serviceInstanceType = (String)protectGroup.getProps().get("serviceInstanceType");
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(serviceInstanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(serviceInstanceType)) {
            this.deleteRing(protectGroup);
        } else {
            VolumeReplicationCgInfo cg = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, cgId);
            if (null == cg || cg.isMasterFlag()) {
                this.deleteCg(projId, regionId, cgId, splitFlag);
                this.deleteCg(drProjId, drRegionId, drCgId, splitFlag);
            } else {
                this.deleteCg(drProjId, drRegionId, drCgId, splitFlag);
                this.deleteCg(projId, regionId, cgId, splitFlag);
            }
            List taskList = OpenStackCommonUtil.getTaskList(this.volumeService, (Collection<ProtectObject>)protectGroup.getPolist(), protectGroup, null, null, new DelTagParam());
            OpenStackCommonUtil.executeTask(taskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
            List delPhVmTask = ProtectGroupOperateObserver.getDelPhVmTaskList(protectGroup.getPolist(), protectGroup, ProtectGroupOperateObserver.isNeedDeletePhVm(protectGroup));
            OpenStackCommonUtil.executeTask(delPhVmTask, ExecutionService.ExecuteType.FAILED_ABORT, true);
            List configVMMetaTask = this.getConfigVMMetaTaskList(protectGroup.getPolist(), protectGroup);
            OpenStackCommonUtil.executeTask(configVMMetaTask, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
        }
        reattachTasks.forEach(obj -> {
            if (obj instanceof ReattachVolumeTask) {
                ((ReattachVolumeTask)obj).setAfterHyperMetroDel(true);
            }
        });
        OpenStackCommonUtil.executeTask(reattachTasks, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
    }

    private void deleteRing(ProtectGroup protectGroup) {
        String activeDRCG;
        String activeCG;
        String standbyDRCG;
        String standbyCG;
        LOG.info((Object)"Start delete protectGroup, protectGroup name=%s", new Object[]{protectGroup.getName()});
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String cgId = (String)protectGroup.getProps().get("replicaCgUuid");
        String drCgId = (String)protectGroup.getProps().get("drReplicaCgUuid");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionId, projId);
        DrExtendManager mgr = new DrExtendManager();
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, query volumeReplication CG ID=%s,and check if cg is standby side", new Object[]{protectGroup.getName(), cgId});
        VolumeReplicationCgInfo cg = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, cgId);
        String hyperMetorCG = (String)protectGroup.getProps().get("hyperProCgUuid");
        String hyperMetorDRCG = (String)protectGroup.getProps().get("hyperProdrCgUuid");
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, query volumeReplication CG ID=%s, cg info=%s", new Object[]{protectGroup.getName(), cgId, cg});
        if (null != cg && OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cg.getReplicationStatus())) {
            standbyCG = cgId;
            standbyDRCG = drCgId;
            activeCG = (String)protectGroup.getProps().get("hyperProRemoteCgUuid");
            activeDRCG = (String)protectGroup.getProps().get("hyperProRemotedrCgUuid");
        } else {
            activeCG = cgId;
            activeDRCG = drCgId;
            standbyCG = (String)protectGroup.getProps().get("hyperProRemoteCgUuid");
            standbyDRCG = (String)protectGroup.getProps().get("hyperProRemotedrCgUuid");
        }
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, activeCG ID=%s, activeDRCG ID=%s, standbyCG ID=%s,standbyDRCG ID=%s", new Object[]{protectGroup.getName(), activeCG, activeDRCG, standbyCG, standbyDRCG});
        OpenStackCommonUtil.closeAndDeleteRing(protectGroup, this.volumeService);
        VolumeReplicationCgInfo standbyVolumeCG = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, standbyCG);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, query standby replicationCG ID=%s, standby cg info=%s", new Object[]{protectGroup.getName(), standbyCG, standbyVolumeCG});
        this.deleteConsistencyGroup(protectGroup, standbyCG, standbyDRCG, standbyVolumeCG);
        VolumeReplicationCgInfo activeVolumeCG = mgr.queryVolumeReplicationCG(regionId, tokenId, projId, activeCG);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, query active replicationCG ID=%s, active cg info=%s", new Object[]{protectGroup.getName(), activeCG, activeVolumeCG});
        this.deleteConsistencyGroup(protectGroup, activeCG, activeDRCG, activeVolumeCG);
        this.deleteHyperMetorCG(protectGroup, mgr, hyperMetorCG, hyperMetorDRCG);
        this.deleteVolumeAndPhVm(protectGroup, projId, regionId, tokenId);
    }

    private void deleteHyperMetorCG(ProtectGroup protectGroup, DrExtendManager mgr, String hyperMetorCG, String hyperMetorDRCG) {
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String splitFlag = (String)protectGroup.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String hyperMetorRegionId = OpenStackBasicUtil.isCsdrVhaMode(protectGroup) ? drRegionId : regionId;
        String hyperMetorProjId = OpenStackBasicUtil.isCsdrVhaMode(protectGroup) ? drProjId : projId;
        VolumeReplicationCgInfo activeVolumeHyperMetorCG = mgr.queryVolumeReplicationCG(hyperMetorRegionId, TokenUtil.getInstance().getRegionTokenId(hyperMetorRegionId, hyperMetorProjId), hyperMetorProjId, hyperMetorCG);
        LOG.info((Object)"Delete protectGroup,protectGroup name=%s,query hyperMetro replicationCG ID=%s,hyperMetro cg info=%s", new Object[]{protectGroup.getName(), hyperMetorCG, activeVolumeHyperMetorCG});
        if (null == activeVolumeHyperMetorCG || activeVolumeHyperMetorCG.isMasterFlag()) {
            this.deleteCg(hyperMetorProjId, hyperMetorRegionId, hyperMetorCG, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete hyperMetorCG success.projId:%s,regionId:%s, hyperMetorCG:%s", new Object[]{protectGroup.getName(), hyperMetorProjId, hyperMetorRegionId, hyperMetorCG});
            this.deleteCg(hyperMetorProjId, hyperMetorRegionId, hyperMetorDRCG, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete hyperMetorDRCG success.drProjId:%s,regionId:%s, hyperMetorDRCG:%s", new Object[]{protectGroup.getName(), hyperMetorProjId, hyperMetorRegionId, hyperMetorDRCG});
        } else {
            this.deleteCg(hyperMetorProjId, hyperMetorRegionId, hyperMetorDRCG, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete hyperMetorDRCG success.drProjId:%s,regionId:%s, hyperMetorDRCG:%s", new Object[]{protectGroup.getName(), hyperMetorProjId, hyperMetorRegionId, hyperMetorDRCG});
            this.deleteCg(hyperMetorProjId, hyperMetorRegionId, hyperMetorCG, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete hyperMetorCG success.projId:%s,regionId:%s, hyperMetorCG:%s", new Object[]{protectGroup.getName(), hyperMetorProjId, hyperMetorRegionId, hyperMetorCG});
        }
    }

    private void deleteConsistencyGroup(ProtectGroup protectGroup, String cg, String drcg, VolumeReplicationCgInfo volumeCG) {
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        String drProjId = (String)protectGroup.getProps().get("drProjectId");
        String drRegionId = (String)protectGroup.getProps().get("drRegionId");
        String splitFlag = (String)protectGroup.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        if (null == volumeCG || volumeCG.isMasterFlag()) {
            this.deleteCg(projId, regionId, cg, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s, delete standCg success.projId:%s,regionId:%s, standbyCG:", new Object[]{protectGroup.getName(), projId, regionId, cg});
            this.deleteCg(drProjId, drRegionId, drcg, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete standDRCg success.drProjId:%s,drRegionId:%s, standbyDRCG:%s", new Object[]{protectGroup.getName(), drProjId, drRegionId, drcg});
        } else {
            this.deleteCg(drProjId, drRegionId, drcg, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete standDRCg success.drProjId:%s,drRegionId:%s, standbyDRCG:%s", new Object[]{protectGroup.getName(), drProjId, drRegionId, drcg});
            this.deleteCg(projId, regionId, cg, splitFlag);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete standCg success.projId:%s,regionId:%s, standbyCG:%s", new Object[]{protectGroup.getName(), projId, regionId, cg});
        }
    }

    private List<Callable<PoReplicaInfo>> getReattachVolumeTasks(Collection<ProtectObject> pos) {
        ArrayList<Callable<PoReplicaInfo>> reattachTasks = new ArrayList<Callable<PoReplicaInfo>>();
        for (ProtectObject po : pos) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            ReattachVolumeTask task = new ReattachVolumeTask(poReplicaInfo);
            reattachTasks.add(task);
        }
        return reattachTasks;
    }

    private void deleteCg(String projId, String regionId, String cgId, String splitFlag) {
        OpenStackCommonUtil.deleteCg(this.volumeService, projId, regionId, cgId, splitFlag);
    }

    public static List<Callable<PhVmInfo>> getDelPhVmTaskList(Collection<ProtectObject> poList, ProtectGroup protectGroup) {
        return ProtectGroupOperateObserver.getDelPhVmTaskList(poList, protectGroup, ProtectGroupOperateObserver.isNeedDeletePhVm(protectGroup));
    }

    private static List<Callable<PhVmInfo>> getDelPhVmTaskList(Collection<ProtectObject> poList, ProtectGroup protectGroup, boolean needDelete) {
        ArrayList<Callable<PhVmInfo>> taskList = new ArrayList<Callable<PhVmInfo>>();
        for (ProtectObject po : poList) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
            if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", phvmUuid is empty:replicaInfoStr=" + replicationInfo));
                continue;
            }
            taskList.add(new DelPlaceHoldVMTask(phVm, protectGroup, po, needDelete));
        }
        return taskList;
    }

    private List<Callable<Boolean>> getConfigVMMetaTaskList(Collection<ProtectObject> poList, ProtectGroup protectGroup) {
        ArrayList<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();
        if (protectGroup.getTemplate().getType() != 25 && protectGroup.getTemplate().getType() != 37) {
            return taskList;
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("_ha_policy_type", "remote_rebuild");
        String regionUuid = (String)protectGroup.getProps().get("regionId");
        String projectUuid = (String)protectGroup.getProps().get("projectId");
        String openstackUuid = protectGroup.getPoProviderSN();
        List<OpenStackVM> vmList = null;
        if (OpenStackBasicUtil.forceDelete()) {
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        }
        HashSet<String> vmuuilSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty(vmList)) {
            for (OpenStackVM openStackVM : vmList) {
                vmuuilSet.add(openStackVM.getUuid());
            }
        }
        for (ProtectObject po : poList) {
            String vmUuid = po.getMoUuid();
            if (OpenStackBasicUtil.forceDelete() && !vmuuilSet.contains(vmUuid)) {
                LOG.info((Object)"Config VM metadata,vmid=%s is not existed and do not send config data task.", new Object[]{vmUuid});
                continue;
            }
            taskList.add(new ConfigVMMetaTask(openstackUuid, vmUuid, projectUuid, regionUuid, metadata, protectGroup.getName()));
        }
        return taskList;
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        int messageType = event.getMessageType();
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup pg = (ProtectGroup)object;
            String pgUuid = pg.getUuid();
            if (messageType == 2) {
                for (ProtectObject po : pg.getPolist()) {
                    this.restoreProtectObjectAlarm(pgUuid, po.getMoUuid());
                    this.restoreAlarmOnDeletePgAndPo(pgUuid, po);
                }
                this.restoreAlarmOnDeleteProctectGroup(pgUuid);
                this.restoreAlarmOnDeleteInstance(pgUuid);
                continue;
            }
            if (messageType == 4) {
                this.dealRemovePoMsg(event, pgUuid);
                continue;
            }
            if (messageType == 9) {
                this.maintainServiceInstance(pg, false);
                continue;
            }
            if (messageType != 8) continue;
            this.maintainServiceInstance(pg, true);
        }
    }

    private void dealRemovePoMsg(MessageEvent event, String pgUuid) {
        Map resultItemMap = ProtectionToolsUtil.getInstance().getResultItemMap(event);
        if (VerifyUtil.isEmpty((Map)resultItemMap)) {
            LOG.info((Object)"Result item Map is empty");
            return;
        }
        List<ProtectObject> pos = this.removedPos.get(pgUuid);
        if (null == pos) {
            pos = new ArrayList<ProtectObject>();
        }
        HashSet<ProtectObject> removeFailedPos = new HashSet<ProtectObject>();
        for (ProtectObject po : pos) {
            TaskResultItem item = (TaskResultItem)resultItemMap.get(po.getUuid());
            if (VerifyUtil.isEmpty((Object)item)) continue;
            if (CommonConstant.BACKTASK_RESULT_SUCCESS == item.getResult()) {
                this.restoreProtectObjectAlarm(pgUuid, po.getMoUuid());
                continue;
            }
            LOG.info((Object)"Po remove failed:poName=%s", new Object[]{po.getName()});
            po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            po.getProps().put("OBJ_DELETE_ERROR", "true");
            removeFailedPos.add(po);
        }
        if (!VerifyUtil.isEmpty(removeFailedPos)) {
            CommonDAOLocator.getBaseDao().saveOrUpdateAll(removeFailedPos);
        }
    }

    private void restoreAlarmOnDeletePgAndPo(String pgUuid, ProtectObject po) {
        AlarmReporter.restoreAlarm((long)52625452L, (String[])new String[]{pgUuid + po.getUuid()});
        AlarmReporter.restoreAlarm((long)52625453L, (String[])new String[]{pgUuid + po.getUuid()});
        AlarmReporter.restoreAlarm((long)52625454L, (String[])new String[]{pgUuid + po.getUuid()});
        AlarmReporter.restoreAlarm((long)52625469L, (String[])new String[]{po.getMoUuid()});
    }

    private void restoreAlarmOnDeleteProctectGroup(String pgUuid) {
        AlarmReporter.restoreAlarm((long)52625455L, (String[])new String[]{pgUuid});
        AlarmReporter.restoreAlarm((long)52625478L, (String[])new String[]{pgUuid});
    }

    private void restoreAlarmOnDeleteInstance(String pgUuid) {
        ServiceInstance inst = this.getServiceInstByPgId(pgUuid);
        if (null == inst) {
            LOG.debug((Object)"This protectGroup has not instance");
            return;
        }
        AlarmReporter.restoreAlarm((long)52625465L, (String[])new String[]{inst.getUuid()});
        AlarmReporter.restoreAlarm((long)52625470L, (String[])new String[]{inst.getUuid()});
        AlarmReporter.restoreAlarm((long)52625463L, (String[])new String[]{inst.getUuid()});
        AlarmReporter.restoreAlarm((long)52625464L, (String[])new String[]{inst.getUuid()});
    }

    private void restoreProtectObjectAlarm(String pgUuid, String vmUuid) {
        AlarmReporter.restoreAlarm((long)52625449L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625468L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625466L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625491L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625447L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625467L, (String[])new String[]{pgUuid + vmUuid});
        AlarmReporter.restoreAlarm((long)52625448L, (String[])new String[]{vmUuid});
    }

    private ServiceInstance getServiceInstByPgId(String pgId) {
        List instList;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ServiceInstance.class);
            crit.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)pgId));
            instList = crit.list();
        }
        catch (DataAccessException e) {
            try {
                LOG.error((Object)"Failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        if (!VerifyUtil.isEmpty((Collection)instList)) {
            return (ServiceInstance)instList.get(0);
        }
        return null;
    }

    private void checkMaintainServiceInstance(ProtectGroup protectGroup, boolean maintain) {
        String instanceId = (String)protectGroup.getProps().get("SERVICEINSTANCE_UUID");
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return;
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            LOG.error((Object)("Get instance( " + instanceId + " ) return null."));
            return;
        }
        if (maintain && !ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue().equals(instance.getStatus())) {
            throw new LegoCheckedException(1073948693L, "add servers to instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        if (!maintain && !ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN.getValue().equals(instance.getStatus())) {
            throw new LegoCheckedException(1073948693L, "add servers to instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainServiceInstance(ProtectGroup protectGroup, boolean maintain) {
        String instanceId = (String)protectGroup.getProps().get("SERVICEINSTANCE_UUID");
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return;
        }
        ServiceInstaceEnumDefine.ServiceInstanceStatusE changeStatus = maintain ? ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN : ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        try {
            LOG.info((Object)"Change instance status before excute:%s", new Object[]{changeStatus});
            if (!instanceHelper.getLock(instanceId)) {
                LOG.error((Object)("Get instance( " + instanceId + " ) lock faild."));
                throw new LegoCheckedException(1073948693L);
            }
            instanceHelper.changeStatus(instanceId, changeStatus);
        }
        finally {
            instanceHelper.releaseLock(instanceId);
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void deleteVolumeAndPhVm(ProtectGroup protectGroup, String projId, String regionId, String tokenId) {
        String deleteSide = OpenStackBasicUtil.getStandbyReplication(protectGroup, projId, regionId, tokenId);
        String standbySide = null;
        String activeSide = null;
        if ("activeside".equals(deleteSide)) {
            standbySide = "standbyside";
            activeSide = "activeside";
        } else {
            standbySide = "activeside";
            activeSide = "standbyside";
        }
        List standbyTaskList = OpenStackCommonUtil.getTaskList(this.volumeService, (Collection<ProtectObject>)protectGroup.getPolist(), protectGroup, standbySide, "standbyside", new DelTagParam());
        OpenStackCommonUtil.executeTask(standbyTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, delete standby side  replication success.", new Object[]{protectGroup.getName()});
        List activeTaskList = OpenStackCommonUtil.getTaskList(this.volumeService, (Collection<ProtectObject>)protectGroup.getPolist(), protectGroup, activeSide, "activeside", new DelTagParam());
        OpenStackCommonUtil.executeTask(activeTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete active side replication success.", new Object[]{protectGroup.getName()});
        List hyperMetorTaskList = OpenStackCommonUtil.getTaskList(this.volumeService, (Collection<ProtectObject>)protectGroup.getPolist(), protectGroup, "hypermetorside", "hypermetorside", new DelTagParam());
        OpenStackCommonUtil.executeTask(hyperMetorTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s,delete hypermetor side replication success.", new Object[]{protectGroup.getName()});
        List delPhVmTask = ProtectGroupOperateObserver.getDelPhVmTaskList(protectGroup.getPolist(), protectGroup, ProtectGroupOperateObserver.isNeedDeletePhVm(protectGroup));
        OpenStackCommonUtil.executeTask(delPhVmTask, ExecutionService.ExecuteType.FAILED_ABORT, true);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s, delete Placeholder vm success.", new Object[]{protectGroup.getName()});
        if (protectGroup.getTemplate().getType() == 37) {
            OpenStackCommonUtil.executeTask(this.getunLockVmTaskList(protectGroup), ExecutionService.ExecuteType.FAILED_ABORT, true);
            LOG.info((Object)"Delete protectGroup, protectGroup name=%s,unlock CSHA phVm success.", new Object[]{protectGroup.getName()});
        }
        List configVMMetaTask = this.getConfigVMMetaTaskList(protectGroup.getPolist(), protectGroup);
        OpenStackCommonUtil.executeTask(configVMMetaTask, ExecutionService.ExecuteType.FAILED_CONTINUE, false);
        LOG.info((Object)"Delete protectGroup, protectGroup name=%s,config vm metadata success.", new Object[]{protectGroup.getName()});
    }

    public void onFinal(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        List protectGroups = objectList.stream().filter(ProtectGroup.class::isInstance).map(ProtectGroup.class::cast).filter(this::checkParam).collect(Collectors.toList());
        for (ProtectGroup protectGroup : protectGroups) {
            AtomicLong counter = PROTECT_GROUP_CREATING_COUNTER.get(protectGroup.getName());
            if (null == counter || counter.decrementAndGet() > 0L) continue;
            PROTECT_GROUP_CREATING_COUNTER.remove(protectGroup.getName());
            LOG.debug((Object)"Already remove protectGroup name %s from sets", new Object[]{protectGroup.getName()});
        }
    }

    private List<Callable<Boolean>> getunLockVmTaskList(ProtectGroup protectGroup) {
        ArrayList<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();
        String projId = (String)protectGroup.getProps().get("projectId");
        String regionId = (String)protectGroup.getProps().get("regionId");
        for (ProtectObject po : protectGroup.getPolist()) {
            String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
            if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                LOG.error((Object)("ProtectGroup name=" + protectGroup.getName() + ", phvmUuid is empty:replicaInfoStr=" + replicationInfo));
                continue;
            }
            taskList.add(new LockVMTask(protectGroup, phVm.getVmUuid(), projId, regionId));
        }
        return taskList;
    }
}

