/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.List;
import java.util.Map;

public class OpenStackFileSystemProvider
implements IGalaxProtectObjectCloudProvider {
    private IProtectGroupRefreshService pgRefreshService;

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    public String getCloudType() {
        return DrFusionSphereOpenStack.class.getSimpleName();
    }

    public String getProviderType() {
        return FusionSphereOpenStack.class.getSimpleName();
    }

    public String getObjectType() {
        return ServiceInstaceEnumDefine.ObjectType.SFS.getValue();
    }

    public void buildProtectObjects(ProtectGroup paramProtectGroup) {
        String projUuid = (String)paramProtectGroup.getProps().get("projectId");
        String regionUuid = (String)paramProtectGroup.getProps().get("regionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
        ISfsManilaManager sfsManilaManager = ManagerFactory.getInstance().getSfsManilaManager();
        for (ProtectObject po : paramProtectGroup.getPolist()) {
            Share pdShare = sfsManilaManager.queryShareById(pdUrlBaseParams, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                po.setUuid(UUIDGenerator.getUUID());
            }
            po.setName(pdShare.getName());
            po.setPoType(17);
            po.setProviderSN(OpenStackCommonUtil.getOpenstack().getTopMoUuid());
        }
    }

    public List<ProtectObject> getAvailableProtectObject(String paramString, Map<String, Object> paramMap) {
        return null;
    }

    public void refreshProtectObjectProperties(ProtectGroup protectGroup) {
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList, Object vmlist) {
    }

    public void refreshProtectGroup(ProtectGroup pg) {
    }

    public void refreshCloud(String cloudSn, String username, boolean cascade) {
    }

    public Map<String, Object> checkRecoveryContext(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String reySite) {
        return null;
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
    }
}

