/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.provider;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.AbstractVmProvider;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.RecoveryTestNetWorkConfigInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenStackVMProvider
extends AbstractVmProvider {
    private static final Log LOG = LogFactory.getInstance(OpenStackVMProvider.class);
    private static final Set<DrmEnumDefine.RecoveryPlanExecuteTypeE> RECOVERY_EXECUTE_TYPE_SET = ImmutableSet.of((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
    private INeMgrProtocolExtendService neMgr;
    private IProtectGroupRefreshService pgRefreshService;

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public String getCloudType() {
        return DrFusionSphereOpenStack.class.getSimpleName();
    }

    public void buildProtectObjects(ProtectGroup paramProtectGroup) {
        ProtectionToolsUtil.getInstance().checkBuildProtectObjectsParam(paramProtectGroup);
        ProtectionToolsUtil.getInstance().checkProtectObjectNumber(paramProtectGroup, 512);
        List<OpenStackVM> vms = this.getVmInfos(paramProtectGroup);
        LOG.debug((Object)"Build protect objects and end to get vminfo,protectGroup name=%s", new Object[]{paramProtectGroup.getName()});
        for (ProtectObject po : paramProtectGroup.getPolist()) {
            boolean vmNotExisted = true;
            for (OpenStackVM vm : vms) {
                if (!vm.getUuid().equals(po.getMoUuid())) continue;
                vmNotExisted = false;
                this.updateProtectObjectBaseInfo(po, vm, paramProtectGroup);
            }
            if (!vmNotExisted) continue;
            LOG.error((Object)("Vm(" + po.getMoUuid() + ") is not existed."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        this.loadProtectObjectStorageInfo(new ArrayList<ProtectObject>(paramProtectGroup.getPolist()), vms);
        OpenStackCommonUtil.setProtectObjectAddressMap(paramProtectGroup);
    }

    private void updateProtectObjectBaseInfo(ProtectObject po, OpenStackVM vm, ProtectGroup paramProtectGroup) {
        if (VerifyUtil.isEmpty((String)po.getUuid())) {
            po.setUuid(UUIDGenerator.getUUID());
        }
        po.setMoUuid(vm.getUuid());
        po.setName(vm.getName());
        po.setPoType(12);
        po.setProviderSN(vm.getTopMoUuid());
        po.getProps().put("VM_VOLUME_UUIDS", vm.getVolumeAttached());
        if (paramProtectGroup.getTemplate().getType() == 25) {
            po.getProps().put("flavorId", vm.getFlavorId());
        }
        if (!VerifyUtil.isEmpty((String)vm.getBootDevName())) {
            po.getProps().put("VM_ROOT_DEVNAME_KEY", vm.getBootDevName());
        }
        if (!VerifyUtil.isEmpty((Collection)vm.getTags()) && vm.getTags().contains("__type_baremetal")) {
            po.getProps().put("vm_type", "BMS");
        } else {
            po.getProps().put("vm_type", "ECS");
        }
    }

    public List<ProtectObject> getAvailableProtectObject(String providerSn, Map<String, Object> paramMap) {
        String regionUuid = (String)paramMap.get("regionId");
        String projUuid = (String)paramMap.get("projectId");
        String azName = (String)paramMap.get("zoneName");
        if (!(ParamChecker.checkGeneralId((String)regionUuid) && ParamChecker.checkGeneralId((String)projUuid) && ParamChecker.checkGeneralId((String)azName))) {
            LOG.error((Object)("Param is error:regionUuid=" + regionUuid + " projUuid=" + projUuid + " azName=" + azName));
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projUuid);
        String queryMouuidSql = "select moUuid from ProtectObject";
        String queryTaskIdSql = "select taskId from RollBackTaskInfo";
        List moUuidList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryMouuidSql, new Object[0]);
        List taskIdList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryTaskIdSql, new Object[0]);
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        for (OpenStackVM vm : vmList) {
            if (vm.getLocked().booleanValue() || VerifyUtil.isEmpty((String)vm.getVolumeAttached()) || !azName.equals(vm.getAzName()) || moUuidList.contains(vm.getUuid()) || taskIdList.contains(vm.getUuid())) continue;
            ProtectObject po = new ProtectObject();
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoType(12);
            po.setProviderSN(providerSn);
            poList.add(po);
        }
        return poList;
    }

    public void refreshProtectObjectProperties(ProtectGroup protectGroup) {
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList, Object vms) {
        ProtectGroup pg = ((ProtectObject)CommonUtil.getFirstElement(protectObjectList)).getProtectGroup();
        if (null != pg) {
            String regionUuid = (String)pg.getProps().get("regionId");
            String projectUuid = (String)pg.getProps().get("projectId");
            List vmsOfProtectGroup = (List)vms;
            HashSet<String> uuidSet = new HashSet<String>();
            for (OpenStackVM vm : vmsOfProtectGroup) {
                uuidSet.addAll(OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ","));
            }
            List volumes = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumesByUuid(regionUuid, projectUuid, new ArrayList(uuidSet), false);
            LOG.info((Object)"Pg:%s, uuidSet size:%s,volumes size:%s", new Object[]{pg.getName(), String.valueOf(uuidSet.size()), String.valueOf(volumes.size())});
            for (ProtectObject po : protectObjectList) {
                po.getUsedStorageResourceSet().clear();
                this.updateProtectObjectStorageInfo(volumes, po);
                LOG.info((Object)"Pg:%s, po:%s, uuidSet size:%s,volumes size:%s,storage size:%s", new Object[]{pg.getName(), po.getName(), String.valueOf(uuidSet.size()), String.valueOf(volumes.size()), String.valueOf(po.getUsedStorageResourceSet().size())});
            }
        }
    }

    private void updateProtectObjectStorageInfo(List<OpenStackVolume> volumes, ProtectObject po) {
        String bootDevName = (String)po.getProps().get("VM_ROOT_DEVNAME_KEY");
        for (OpenStackVolume volume : volumes) {
            volume.generateAttachmentInfo();
            if (!volume.getAttachVmUuids().contains(po.getMoUuid())) continue;
            ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
            storage.setId(UUIDGenerator.getUUID());
            storage.setResourceName(volume.getName());
            storage.setLunWWN(volume.getUuid());
            storage.setResourceId(volume.getUuid());
            storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
            for (OpenStackVolAttachment attachment : volume.getAttachments()) {
                if (!po.getMoUuid().equals(attachment.getVmUuid())) continue;
                storage.setDeviceName(attachment.getDevice());
                if (VerifyUtil.isEmpty((String)attachment.getDevice()) || !attachment.getDevice().equals(bootDevName)) continue;
                po.getProps().put("VM_BOOTABLE_VOLUME", volume.getUuid());
            }
            po.addHostStorageResourceInfo(storage);
        }
    }

    private List<OpenStackVM> getVmInfos(ProtectGroup pg) {
        String projUuid;
        String regionUuid;
        Object[] uuids = this.getVmUuids(pg.getPolist());
        IVirtualMachineService service = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        List vms = service.queryVmByUuids(regionUuid = (String)pg.getProps().get("regionId"), projUuid = (String)pg.getProps().get("projectId"), (String[])uuids);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            LOG.error((Object)("OpenstackVM is empty: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        if (uuids.length != vms.size()) {
            LOG.error((Object)("Some OpenstackVM is not existed: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        return vms;
    }

    private String[] getVmUuids(Collection<ProtectObject> pos) {
        String[] uuids = new String[pos.size()];
        int index = 0;
        for (ProtectObject po : pos) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                LOG.error((Object)"Uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        return uuids;
    }

    public void refreshProtectGroup(ProtectGroup pg) {
        if (null != this.pgRefreshService) {
            pg.getProps().put("isManualRefresh", Integer.toString(1));
            try {
                this.pgRefreshService.refreshProtectGroup(pg);
            }
            finally {
                pg.getProps().remove("isManualRefresh");
            }
        }
    }

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    public String getProviderType() {
        return "FusionSphereOpenstack";
    }

    public void refreshCloud(String cloudSn, String userName, boolean cascade) {
        LOG.debug((Object)"Refresh Openstack enter", 90160758786816L);
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            LOG.error((Object)"Openstack sn is empty, refresh failed", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        final ManagedObject mo = CommonDAOLocator.getMoDao().getMo(FusionSphereOpenStack.class, "sn", (Object)cloudSn);
        if (null == mo || null == mo.getMoId()) {
            LOG.error((Object)("Openstack(" + cloudSn + ") dosen't exist.Failed to refresh."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)mo.getName(), (String)"ism.drm.openstack.log.refresh", (String)userName, (String)"", null);
        int timeOut = 21600;
        AbstractBackTask task = new AbstractBackTask(mo.getUuid(), bt, timeOut, true){

            protected void doWork() {
                long moId = mo.getMoId();
                NeMgrProtocolExtend extend = OpenStackVMProvider.this.neMgr.findByMoId(Long.valueOf(moId));
                if (null == extend) {
                    LOG.error((Object)("Openstack(" + mo.getName() + ") dosen't exist.Failed to refresh."), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                RefreshContext context = new RefreshContext(mo);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("DiscoveryType", (Object)"refresh");
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Openstack");
                if (null == refreshTemplate) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public Map<String, Object> checkRecoveryContext(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String reySite) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String siteId = RecoveryProcessUtil.getDisterSiteId((String)reySite, (ProtectGroup)((ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups())));
        settings.put("DISASTER_SITE_ID", siteId);
        ProtectGroup pg = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
        if (PolicyTemplateType.PolicyTemplateE.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING.getValue() == pg.getTemplate().getType() && procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION && recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue()) {
            String drRegionUuid = pg.getProperty("current_disaster_region");
            String drZoneName = pg.getProperty("recovery_az_id");
            recoveryContext.put("recovery_region_id", drRegionUuid);
            recoveryContext.put("recovery_az_id", drZoneName);
        }
        if (PolicyTemplateType.PolicyTemplateE.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING.getValue() == pg.getTemplate().getType() && RECOVERY_EXECUTE_TYPE_SET.contains(procType)) {
            if (recoveryContext.get("recovery_region_id") == null || recoveryContext.get("recovery_az_id") == null) {
                LOG.error((Object)"CSHA+CSDR instance:%s, execute type:%s , no necessary recovery parameters.", new Object[]{pg.getName(), procType});
                throw new LegoCheckedException(1073947393L);
            }
            settings.put("recovery_region_id", recoveryContext.get("recovery_region_id"));
            settings.put("recovery_az_id", recoveryContext.get("recovery_az_id"));
        }
        this.checkPlaceHoldVm(recoveryPlan, procType);
        this.checkProtectObjectInfo(recoveryPlan, procType);
        return settings;
    }

    private void checkPlaceHoldVm(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            LOG.error((Object)"Pg is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION)) {
            for (ProtectObject po : pg.getPolist()) {
                boolean hasPlaceHoldVm = false;
                for (RecoverySetting setting : recoverySettings) {
                    if (!setting.getOwnerId().equals(po.getUuid()) || !setting.getName().equals("PLACEHOLDVM") || VerifyUtil.isEmpty((String)setting.getValue())) continue;
                    hasPlaceHoldVm = true;
                    break;
                }
                if (hasPlaceHoldVm) continue;
                LOG.error((Object)("Po has not set phvm:" + po.getName()));
                throw new LegoCheckedException(1073948908L);
            }
        }
    }

    private void checkProtectObjectInfo(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            LOG.error((Object)"Pg is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION)) {
            for (ProtectObject po : pg.getPolist()) {
                if (ProtectObjectStatusEnum.VALID.getValue() != po.getPoStatus()) {
                    LOG.error((Object)("Po(" + po.getName() + ") is not valid."));
                    throw new LegoCheckedException(1073948909L);
                }
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                if (VerifyUtil.isEmpty((String)replicationInfo)) {
                    LOG.warn((Object)"ReplicaInfo is empty. vm is %s", new Object[]{po.getName()});
                    continue;
                }
                LOG.debug((Object)"ReplicaInfo:%s", new Object[]{replicationInfo});
                JSONObject replicaInfo = JSONObject.fromObject((Object)replicationInfo);
                JSONArray volInfo = replicaInfo.getJSONArray("pairInfos");
                if (null == volInfo) {
                    LOG.warn((Object)"PairInfos is empty. vm is %s", new Object[]{po.getName()});
                    continue;
                }
                this.checkVolumeStatus(procType, po, volInfo);
            }
        }
    }

    private void checkVolumeStatus(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, ProtectObject po, JSONArray volInfo) {
        for (int i = 0; i < volInfo.size(); ++i) {
            JSONObject pairInfo = volInfo.getJSONObject(i);
            String volumeStatus = pairInfo.getString("volumeStatus");
            if (OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(volumeStatus)) continue;
            if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(volumeStatus) && OpenStackCommonUtil.isBareMetalServer(po)) {
                LOG.info((Object)"Bms (%s) has unprotected volume, allow to execute %s", new Object[]{po.getName(), procType.getValue()});
                continue;
            }
            LOG.error((Object)("Po(" + po.getName() + ") has at least one volume not protected."));
            throw new LegoCheckedException(1073948909L);
        }
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        super.checkRecoverySettings(recoverySettingList);
        this.checkStartDelayTime(recoverySettingList);
        this.checkPlaceHoldVm(recoverySettingList);
        this.checkPlaceHoldVmName(recoverySettingList);
        this.checkTestNetConfig(recoverySettingList);
    }

    private void checkStartDelayTime(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!"start_delay_time".equals(setting.getName()) || NumberUtil.between((String)setting.getValue(), (int)0, (int)1800)) continue;
            LOG.error((Object)"%s is not in range (0-3600)s: %s", new Object[]{"start_delay_time", setting.getValue()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkPlaceHoldVm(List<RecoverySetting> recoverySettingList) {
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (RecoverySetting setting : recoverySettingList) {
            if (!setting.getName().equals("PLACEHOLDVM")) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                LOG.error((Object)"Not set PLACEHOLDVM");
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)setting.getValue())) {
                LOG.error((Object)"Invalid PLACEHOLDVM");
                throw new LegoCheckedException(1073947393L);
            }
            String vmUuid = setting.getValue();
            if (vmUuidSet.contains(vmUuid)) {
                LOG.error((Object)"Placeholdvm(%s) is setted to different po.", new Object[]{vmUuid});
                throw new LegoCheckedException(1073947393L);
            }
            vmUuidSet.add(vmUuid);
        }
    }

    private void checkPlaceHoldVmName(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!"PLACEHOLDVMNAME".equals(setting.getName())) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                LOG.error((Object)"Not set PLACEHOLDVMNAME");
                throw new LegoCheckedException(1073947393L);
            }
            if (ParamChecker.checkGeneralText((String)setting.getValue())) continue;
            LOG.error((Object)"Invalid PLACEHOLDVMNAME");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkTestNetConfig(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!setting.getName().equals("TESTNETWORKCONFIG")) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                LOG.error((Object)"Not set TESTNETWORKCONFIG for po:%s", new Object[]{setting.getOwnerId()});
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkLongText((String)setting.getValue())) {
                LOG.error((Object)"TESTNETWORKCONFIG incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            JSONArray netWorkArray = JSONArray.fromObject((Object)setting.getValue());
            for (int i = 0; i < netWorkArray.size(); ++i) {
                JSONObject obj = netWorkArray.getJSONObject(i);
                RecoveryTestNetWorkConfigInfo configInfo = (RecoveryTestNetWorkConfigInfo)JSONObject.toBean((JSONObject)obj, RecoveryTestNetWorkConfigInfo.class);
                this.checkCreatePortParam(configInfo.getNetworkId(), configInfo.getIsDhcp(), configInfo.getIpAddress(), configInfo.getPortName());
            }
        }
    }

    private void checkCreatePortParam(String networkId, Boolean isDhcp, String ipAddress, String portName) {
        if (VerifyUtil.isEmpty((String)networkId) || null == isDhcp || VerifyUtil.isEmpty((String)portName)) {
            LOG.error((Object)"Params: networkId, isDhcp, portName is empty or null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParamWithOutChinese((String)portName)) {
            LOG.error((Object)"PortName is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(isDhcp.booleanValue() || CommUtil.checkDrmIpParam((String)ipAddress) || CommUtil.checkDrmIpV6Param((String)ipAddress))) {
            LOG.error((Object)"Ip error:%s", new Object[]{ipAddress});
            throw new LegoCheckedException(1073947393L);
        }
    }
}

