/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.replica.builder.FileSystemArrayReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.sdk.bo.FileSystem;
import com.huawei.ism.drm.openstack.sdk.bo.OsAllowAccess;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.msg.AdderssPrivateInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplicationAlarmInfo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class SyncFileSystemArrayReplicationReplicaBuilder
extends FileSystemArrayReplicationReplicaBuilder {
    private static final Log LOGGER = LogFactory.getInstance(SyncFileSystemArrayReplicationReplicaBuilder.class);
    private static final ISfsFilemeterManager FILEMETER_MANAGER = ManagerFactory.getInstance().getSfsFilemeterManager();
    private static final ISfsManilaManager SFS_MANILA_MANAGER = ManagerFactory.getInstance().getSfsManilaManager();

    @Override
    public void buildReplica(ProtectGroup pg) {
        LOGGER.info((Object)"Start to create protectGroup replica:pgName=%s", new Object[]{pg.getName()});
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            LOGGER.error((Object)"pg or polist is empty");
            throw new LegoCheckedException(1073947393L);
        }
        this.protectShare(pg);
    }

    private void protectShare(ProtectGroup pg) {
        String projUuid = (String)pg.getProps().get("projectId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String zoneName = (String)pg.getProps().get("zoneName");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
        UrlBaseParams drUrlBaseParams = new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
        for (ProtectObject po : pg.getPolist()) {
            String pdShareString = po.getProperty("pd_share");
            Share pdShare = this.checkAndGetPdShare(pdUrlBaseParams, pdShareString);
            FileSystem pdFileSystem = FILEMETER_MANAGER.getPdFileSystemByShareId(pdUrlBaseParams, pdShare.getId());
            po.setProperty("local_file_system", (Object)JSONObject.fromObject((Object)pdFileSystem).toString());
            String drShareTypeName = this.getShareTypeName(pg, pdShare);
            FileSystem drFileSystem = this.createFileSystem(drUrlBaseParams, pdFileSystem, drShareTypeName);
            drFileSystem.setShareTypeName(drShareTypeName);
            po.setProperty("remote_file_system", (Object)JSONObject.fromObject((Object)drFileSystem).toString());
            SharePair pdSharePair = FILEMETER_MANAGER.createSharePair(pdUrlBaseParams, new SharePair("", pdShare.getShareType(), pdShare.getId(), pdFileSystem.getId(), drFileSystem.getId(), true), pdFileSystem.getFsName());
            po.setProperty("share_pair", (Object)JSONObject.fromObject((Object)pdSharePair).toString());
            Share drShare = this.createDrShare(drUrlBaseParams, pdShare, drShareTypeName, drFileSystem);
            po.setProperty("dr_share", (Object)JSONObject.fromObject((Object)SFS_MANILA_MANAGER.queryShareById(drUrlBaseParams, drShare.getId())).toString());
            FILEMETER_MANAGER.createSharePair(drUrlBaseParams, new SharePair(pdSharePair.getSharePairId(), drShareTypeName, drShare.getId(), drFileSystem.getId(), pdFileSystem.getId(), false), pdFileSystem.getFsName());
            this.addTagToShare(drProjUuid, drRegionUuid, pdUrlBaseParams, pdShare, "__type_pd");
            this.addTagToShare(projUuid, regionUuid, drUrlBaseParams, drShare, "__type_dr");
            po.getProps().put("regionId", CommUtil.getIdFromUuid((String)regionUuid));
            po.getProps().put("projectName", this.getProjectName(projUuid));
            po.getProps().put("zoneName", zoneName);
            List<OsAllowAccess> osAllowAccessList = this.getOsAllowAccesses(po);
            if (VerifyUtil.isEmpty(osAllowAccessList)) {
                return;
            }
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drUrlBaseParams.getProjectUuid());
            INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            List<OpenStackVM> vmList = novaManager.getVms(drRegionUuid, drTokenId, drProjUuid, "1.33");
            this.initOsAllowAccess(drUrlBaseParams, drShare, osAllowAccessList, vmList);
        }
    }

    private Share checkAndGetPdShare(UrlBaseParams pdUrlBaseParams, String pdShareString) {
        Share pdShare = (Share)JSONObject.toBean((String)pdShareString, Share.class);
        if (VerifyUtil.isEmpty((Object)pdShare)) {
            LOGGER.error((Object)"The pdSahre is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        pdShare = SFS_MANILA_MANAGER.queryShareById(pdUrlBaseParams, pdShare.getId());
        if (!OpenstackEnumDefine.ShareStatus.AVAILABLE.getValue().equals(pdShare.getStatus())) {
            LOGGER.error((Object)"The share(%s,share name=%s) status error,status:%s.", new Object[]{pdShare.getId(), pdShare.getName(), pdShare.getStatus()});
            throw new LegoCheckedException(1073947393L);
        }
        return pdShare;
    }

    private String getProjectName(String projectUuid) {
        OpenStackProject openStackProject = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getProjectByProjectUUid(projectUuid);
        if (!VerifyUtil.isEmpty((Object)openStackProject)) {
            return openStackProject.getName();
        }
        LOGGER.error((Object)("OpenStackProject null,projectUuid:" + projectUuid));
        throw new LegoCheckedException(1073947393L);
    }

    private void addTagToShare(String projUuid, String regionUuid, UrlBaseParams drUrlBaseParams, Share drShare, String scVmTypeDr) {
        ArrayList<String> shareTags = new ArrayList<String>();
        shareTags.add(scVmTypeDr);
        shareTags.add("remote_project_id::" + OpenStackCommonUtil.getIdFromUuid(projUuid));
        shareTags.add("remote_region_id::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
        FILEMETER_MANAGER.addTagToShare(drUrlBaseParams, drShare, shareTags);
    }

    private List<OsAllowAccess> getOsAllowAccesses(ProtectObject po) {
        String osAllowAccessJson = po.getProperty("os_allow_access");
        JSONArray jsonArray = JSONArray.fromObject((Object)osAllowAccessJson);
        List osAllowAccessList = JSONArray.toCollection((JSONArray)jsonArray, OsAllowAccess.class);
        if (VerifyUtil.isEmpty((Collection)osAllowAccessList)) {
            LOGGER.debug((Object)"The default permissions on the DR site are not set for the current instance.");
            return Collections.emptyList();
        }
        return osAllowAccessList;
    }

    private void initOsAllowAccess(UrlBaseParams drUrlBaseParams, Share drShare, List<OsAllowAccess> osAllowAccessList, List<OpenStackVM> vmList) {
        HashMap<String, OpenStackVM> vmIdMap = new HashMap<String, OpenStackVM>();
        for (OpenStackVM vm : vmList) {
            vmIdMap.put(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()), vm);
        }
        for (OsAllowAccess osAllowAccess : osAllowAccessList) {
            if (!OpenstackEnumDefine.OsAllowType.IP.getValue().equals(osAllowAccess.getAccessType())) continue;
            Set<String> ipSet = this.getIpFromVm(osAllowAccess.getAccessTo(), vmIdMap);
            if (VerifyUtil.isEmpty(ipSet)) {
                LOGGER.error((Object)"Failed to obtain the IP address based on the VM(%s).", new Object[]{osAllowAccess.getAccessTo()});
                throw new LegoCheckedException(1073949734L);
            }
            for (String ip : ipSet) {
                osAllowAccess.setAccessTo(ip);
                FILEMETER_MANAGER.addOsAllowAccess(drUrlBaseParams, drShare.getId(), osAllowAccess, drShare.getName());
            }
        }
    }

    private Set<String> getIpFromVm(String vmId, Map<String, OpenStackVM> vmIdMap) {
        OpenStackVM vm = vmIdMap.getOrDefault(OpenStackCommonUtil.getIdFromUuid(vmId), null);
        if (vm == null) {
            LOGGER.error((Object)"Failed to obtain the VM(%s).", new Object[]{vmId});
            throw new LegoCheckedException(1073949734L);
        }
        HashSet<String> ipList = new HashSet<String>();
        for (Map.Entry entry : vm.getAddresses().entrySet()) {
            String ip = null;
            Optional<AdderssPrivateInfo> externalNetworkOp = ((List)entry.getValue()).stream().filter(address -> OpenstackEnumDefine.AddressType.FLOATING.getValue().equals(address.getType()) && address.getNetworkTags().contains("name=external_relay_network")).findFirst();
            if (externalNetworkOp.isPresent()) {
                AdderssPrivateInfo adderssPrivateInfo = externalNetworkOp.get();
                ipList.add(adderssPrivateInfo.getAddr());
                continue;
            }
            for (AdderssPrivateInfo adderssPrivateInfo : (List)entry.getValue()) {
                if (OpenstackEnumDefine.AddressType.FIXED.getValue().equals(adderssPrivateInfo.getType())) {
                    ip = adderssPrivateInfo.getAddr();
                }
                if (OpenstackEnumDefine.AddressType.FLOATING.getValue().equals(adderssPrivateInfo.getType()) && adderssPrivateInfo.getNetworkTags().contains("name=external_relay_network")) {
                    ip = adderssPrivateInfo.getAddr();
                }
                ipList.add(ip);
            }
        }
        return ipList;
    }

    public int getType() {
        return 38;
    }

    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return null;
    }

    public Collection<ProtectGroupReplicationAlarmInfo> refreshProtectGroupReplicas(ProtectGroup protectGroup) {
        return super.refreshProtectGroupReplicas(protectGroup);
    }

    private String getShareTypeName(ProtectGroup pg, Share share) {
        String zoneName = (String)pg.getProps().get("zoneName");
        String drZoneName = (String)pg.getProps().get("drZoneName");
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String pdAz = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(regionUuid), (String)zoneName);
        String drAzName = OpenStackVolTypeMapping.getMappingAzId((String)OpenStackCommonUtil.getIdFromUuid(drRegionUuid), (String)drZoneName);
        Optional<String> optional = this.getShareTypeName(share.getShareType(), pdAz, drAzName);
        if (optional.isPresent()) {
            return optional.get();
        }
        LOGGER.error((Object)"The service level mapping is missing.");
        throw new LegoCheckedException(1073947393L);
    }

    private Optional<String> getShareTypeName(String pdShareTypeName, String pdAzName, String drAzName) {
        String openStackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
        List shareTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getResourceMapping(openStackUuid, ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        for (OpenStackVolTypeMapping shareType : shareTypeList) {
            if (shareType.getPrimaryAzId().equals(pdAzName) && shareType.getPrimaryVolType().equals(pdShareTypeName) && shareType.getSecondAzId().equals(drAzName)) {
                return Optional.of(shareType.getSecondVolType());
            }
            if (!shareType.getSecondAzId().equals(pdAzName) || !shareType.getSecondVolType().equals(pdShareTypeName) || !shareType.getPrimaryAzId().equals(drAzName)) continue;
            return Optional.of(shareType.getPrimaryVolType());
        }
        return Optional.empty();
    }

    private FileSystem createFileSystem(UrlBaseParams urlBaseParams, FileSystem pdFileSystem, String drShareType) {
        FileSystem fileSystem = new FileSystem();
        BeanUtils.copyProperties((Object)pdFileSystem, (Object)fileSystem);
        fileSystem.setShareTypeName(drShareType);
        return FILEMETER_MANAGER.createFileSystem(urlBaseParams, fileSystem);
    }

    private Share createDrShare(UrlBaseParams urlBaseParams, Share pdShare, String drShareTypeName, FileSystem drFs) {
        Share share = new Share();
        share.setShareTypeName(drShareTypeName);
        share.setShareProto(pdShare.getShareProto());
        share.setFsId(drFs.getId());
        share.setName(pdShare.getName());
        return FILEMETER_MANAGER.createShare(urlBaseParams, share);
    }
}

