/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTaskResult;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicaSchedulerHintInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceCreateImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class CreateReplicationTask
implements Callable<CreateReplicationTaskResult> {
    private static final Log LOG = LogFactory.getInstance(CreateReplicationTask.class);
    private IVolumeService volumeService;
    private OpenStackVolume srcVolume;
    private ProtectGroup pg;
    private String drVolType;
    private String replicaModel;
    private Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo;

    public CreateReplicationTask(IVolumeService volumeService, OpenStackVolume srcVolume, ProtectGroup pg, String drVolType, String replicaModel) {
        this.volumeService = volumeService;
        this.srcVolume = srcVolume;
        this.pg = pg;
        this.drVolType = drVolType;
        this.replicaModel = replicaModel;
    }

    public CreateReplicationTask(IVolumeService volumeService, OpenStackVolume srcVolume, ProtectGroup pg, String drVolType, String replicaModel, Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo) {
        this.volumeService = volumeService;
        this.srcVolume = srcVolume;
        this.pg = pg;
        this.drVolType = drVolType;
        this.replicaModel = replicaModel;
        this.drHyperUUIDTDrVolumeInfo = drHyperUUIDTDrVolumeInfo;
    }

    @Override
    public CreateReplicationTaskResult call() {
        boolean isStandby = this.drHyperUUIDTDrVolumeInfo != null && this.drHyperUUIDTDrVolumeInfo.get(this.srcVolume.getUuid()) != null;
        this.printLogByStandByFlag(isStandby);
        PoReplicaPairInfo pairInfo = new PoReplicaPairInfo(this.srcVolume.getUuid(), this.srcVolume.getName(), this.srcVolume.getVolType(), this.drVolType);
        pairInfo.setSize(this.srcVolume.getSize().intValue());
        CreateReplicationTaskResult result = new CreateReplicationTaskResult();
        try {
            if (Integer.valueOf(OpenstackEnumDefine.VolumeStatusE.MAINTENANCE.getValue()).equals(this.srcVolume.getStatus())) {
                LOG.error((Object)("Volume status not normal,name:" + this.srcVolume.getName() + " status:" + this.srcVolume.getStatus()));
                throw new LegoCheckedException(1073948416L);
            }
            VolumeInfo drVolumeInfo = this.getVolumeInfo(isStandby, pairInfo);
            String regionId = (String)this.pg.getProps().get("regionId");
            String projUuid = (String)this.pg.getProps().get("projectId");
            this.updateImageDate(drVolumeInfo, regionId, projUuid);
            this.createSrcReplication(pairInfo, drVolumeInfo);
            if (!isStandby) {
                HashMap<String, String> metadataMap = new HashMap<String, String>();
                metadataMap.put("occupied_volume", "false");
                this.volumeService.updateVolumeMetadata(OpenStackCommonUtil.getIdFromUuid(this.srcVolume.getUuid()), metadataMap, regionId, projUuid);
            }
            if ("hypermetro".equals(this.replicaModel)) {
                this.updateDrVolumeMetadata(drVolumeInfo);
            }
            this.createDrReplication(pairInfo, drVolumeInfo);
            pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
            result.setPairInfo(pairInfo);
            result.setResultFlag(true);
            LOG.info((Object)"Create dr volume and production and disaster replication sucessfully,protectGroup name=%s,volumeuuid=%s", new Object[]{this.pg.getName(), this.srcVolume.getUuid()});
        }
        catch (Exception e) {
            LOG.error((Object)"Create dr volume and production and disaster replication failed,protectGroup name=%s,volumeuuid=%s,%s", new Object[]{this.pg.getName(), this.srcVolume.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
            result.setPairInfo(pairInfo);
            result.setResultFlag(false);
        }
        return result;
    }

    private void updateImageDate(VolumeInfo drVolumeInfo, String regionId, String projUuid) {
        if (this.pg.getTemplate().getType() == 25 || this.pg.getTemplate().getType() == 29 || "hypermetro".equals(this.replicaModel) && this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37) {
            this.updateImageMetadata(drVolumeInfo, regionId, projUuid);
        } else {
            this.updatePhVmVolumeImageMetaData(drVolumeInfo);
        }
    }

    private VolumeInfo getVolumeInfo(boolean isStandby, PoReplicaPairInfo pairInfo) {
        VolumeInfo drVolumeInfo;
        if (isStandby) {
            drVolumeInfo = this.drHyperUUIDTDrVolumeInfo.get(this.srcVolume.getUuid());
            LOG.info((Object)" Create standby replication, dr volume is exist, srcvolumeuuid=%s, drVolumeInfo=%s", new Object[]{this.srcVolume.getUuid(), drVolumeInfo});
            pairInfo.setDrVolumeUuid(this.pg.getPoProviderSN() + ":" + drVolumeInfo.getId());
        } else {
            drVolumeInfo = this.createDrVolume(pairInfo);
        }
        return drVolumeInfo;
    }

    private void printLogByStandByFlag(boolean isStandby) {
        if (isStandby) {
            LOG.info((Object)"Start to create dr volume and standby replication,ProtectGroup name=%s, volumeuuid=%s,srvVolume Type=%s,drVolume volType=%s, replication model=%s", new Object[]{this.pg.getName(), this.srcVolume.getUuid(), this.srcVolume.getVolType(), this.drVolType, this.replicaModel});
        } else {
            LOG.info((Object)"Start to create dr volume and replication,ProtectGroup name=%s, volumeuuid=%s,srvVolume Type=%s,drVolume volType=%s, replication model=%s", new Object[]{this.pg.getName(), this.srcVolume.getUuid(), this.srcVolume.getVolType(), this.drVolType, this.replicaModel});
        }
    }

    private void updateImageMetadata(VolumeInfo drVolumeInfo, String regionId, String projUuid) {
        String drProjectId;
        String drRegionId;
        if ("hypermetro".equals(this.replicaModel) && (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37)) {
            drRegionId = regionId;
            drProjectId = projUuid;
        } else {
            drRegionId = (String)this.pg.getProps().get("drRegionId");
            drProjectId = (String)this.pg.getProps().get("drProjectId");
        }
        if (this.srcVolume.getBootable().booleanValue() && "async".equals(this.replicaModel)) {
            this.updatePhVmVolumeImageMetaData(drVolumeInfo);
            return;
        }
        if (this.srcVolume.getBootable().booleanValue()) {
            Map imageMetadataMap = this.volumeService.queryImageMetadataMap(this.srcVolume.getUuid(), regionId, projUuid);
            this.volumeService.updateImageMetadata(drVolumeInfo.getId(), drRegionId, drProjectId, imageMetadataMap);
        } else {
            ImageMetadataInfo queryImageMedata = this.volumeService.queryImageMetadata(this.srcVolume.getUuid(), regionId, projUuid);
            this.volumeService.updateImageMetadata(drVolumeInfo.getId(), drRegionId, drProjectId, queryImageMedata);
        }
    }

    private void updatePhVmVolumeImageMetaData(VolumeInfo drVolumeInfo) {
        String tokenId;
        if (!this.srcVolume.getBootable().booleanValue()) {
            return;
        }
        ProtectObject srcPo = null;
        block0: for (ProtectObject po : this.pg.getPolist()) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            if (VerifyUtil.isEmpty((String)volConfigStr)) continue;
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                if (!json.containsKey((Object)"volumeId") || !this.srcVolume.getUuid().equals(json.getString("volumeId"))) continue;
                srcPo = po;
                break block0;
            }
        }
        if (null == srcPo) {
            LOG.warn((Object)"Can not find srcPo for volume:%s", new Object[]{this.srcVolume.getUuid()});
            return;
        }
        String phvmId = (String)srcPo.getProps().get("occupied_vm");
        if (null == phvmId) {
            LOG.warn((Object)"Can not find phvmId for po:%s", new Object[]{srcPo.getName()});
            return;
        }
        String drRegionUuid = (String)this.pg.getProps().get("drRegionId");
        String drProjectUuid = (String)this.pg.getProps().get("drProjectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        OpenStackVM vmInfo = novaMgr.getVm(drRegionUuid, tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjectUuid), drProjectUuid, phvmId, new int[0]);
        if (null == vmInfo) {
            LOG.warn((Object)"Can not find phVm for po:%s", new Object[]{srcPo.getName()});
            return;
        }
        List remoteVolumeList = this.volumeService.getVolumesFromOpenstack(drRegionUuid, drProjectUuid);
        OpenStackVolume bootVolume = AbstractServiceInstanceCreateImpl.filterBootVolume(vmInfo, remoteVolumeList);
        if (null != bootVolume) {
            Map imageMetadataMap = this.volumeService.queryImageMetadataMap(bootVolume.getUuid(), drRegionUuid, drProjectUuid);
            this.volumeService.updateImageMetadata(drVolumeInfo.getId(), drRegionUuid, drProjectUuid, imageMetadataMap);
        } else {
            LOG.warn((Object)"Can not find boot vol for po:%s", new Object[]{srcPo.getName()});
        }
    }

    private void updateDrVolumeMetadata(VolumeInfo drVolumeInfo) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("__system__hypermetro", "true");
        Map pgProps = this.pg.getProps();
        String drRegionUuid = (String)pgProps.get("drRegionId");
        String drProjUuid = (String)pgProps.get("drProjectId");
        if ("hypermetro".equals(this.replicaModel) && (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37)) {
            drRegionUuid = (String)this.pg.getProps().get("regionId");
            drProjUuid = (String)this.pg.getProps().get("projectId");
        }
        try {
            this.volumeService.updateVolumeMetadata(drVolumeInfo.getId(), metadata, drRegionUuid, drProjUuid);
        }
        catch (Exception e) {
            LOG.error((Object)("Update volume metadata failed.drVolume info=" + drVolumeInfo));
            throw e;
        }
    }

    private VolumeInfo createDrVolume(PoReplicaPairInfo pairInfo) {
        try {
            LOG.info((Object)"Create dr volume,ProtectGroup name=%s, srcVolumeName=%s, srcVolumeUUID=%s,drvolumeType=%s,replicaModel=%s", new Object[]{this.pg.getName(), this.srcVolume.getName(), this.srcVolume.getUuid(), this.drVolType, this.replicaModel});
            Map pgProps = this.pg.getProps();
            String drRegionUuid = null;
            String drProjUuid = null;
            String drAzName = null;
            if ("hypermetro".equals(this.replicaModel) && this.pg.getTemplate().getType() == 34) {
                drRegionUuid = (String)pgProps.get("regionId");
                drProjUuid = (String)pgProps.get("projectId");
                drAzName = (String)pgProps.get("zoneName");
            } else if ("hypermetro".equals(this.replicaModel) && this.pg.getTemplate().getType() == 37) {
                drRegionUuid = (String)pgProps.get("regionId");
                drProjUuid = (String)pgProps.get("projectId");
                drAzName = (String)pgProps.get("prod_region_drZoneName");
            } else {
                drRegionUuid = (String)pgProps.get("drRegionId");
                drProjUuid = (String)pgProps.get("drProjectId");
                drAzName = (String)pgProps.get("drZoneName");
            }
            VolumeCreateInfo volCreateInfo = new VolumeCreateInfo();
            volCreateInfo = OpenStackCommonUtil.setDrVolumeMode(this.srcVolume, volCreateInfo);
            volCreateInfo.setAzName(drAzName);
            String drVolName = OpenStackCommonUtil.getNameBySuff(this.srcVolume.getName(), "-DR");
            if (this.pg.getTemplate().getType() == 37 && !this.srcVolume.getAz().equals(this.pg.getProperty("originalAvailableZone"))) {
                drVolName = this.srcVolume.getName();
            }
            this.setVolCreateInfo(drProjUuid, volCreateInfo, drVolName);
            VolumeInfo drVolInfo = this.volumeService.createVolume(this.srcVolume.getVolumeDriverMetadata(), volCreateInfo, drRegionUuid, drProjUuid, this.srcVolume.getBootable().booleanValue());
            this.volumeService.reserveVolume(drVolInfo.getId(), drRegionUuid, drProjUuid);
            LOG.info((Object)"Create dr volume sucessfully,ProtectGroup name=%s,srcVolumeName=%s,drvolumeName=%s,drVolumeId=%s,replicaModel=%s", new Object[]{this.pg.getName(), this.srcVolume.getName(), drVolInfo.getName(), drVolInfo.getId(), this.replicaModel});
            pairInfo.setDrVolumeUuid(this.pg.getPoProviderSN() + ":" + drVolInfo.getId());
            return drVolInfo;
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Create dr volume failed,ProtectGroup name=%s,srcVolumeName=%s,srcVolumeUUID=%s,drvolumeType=%s,replicaModel=%s", new Object[]{this.pg.getName(), this.srcVolume.getName(), this.srcVolume.getUuid(), this.drVolType, this.replicaModel});
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                pairInfo.setDrVolumeUuid(this.pg.getPoProviderSN() + ":" + e.getParameters()[0]);
            }
            throw e;
        }
    }

    private void setVolCreateInfo(String drProjUuid, VolumeCreateInfo volCreateInfo, String drVolName) {
        volCreateInfo.setName(drVolName);
        volCreateInfo.setProjectId(drProjUuid);
        volCreateInfo.setSize(this.srcVolume.getSize().intValue());
        volCreateInfo.setVolTypeName(this.drVolType);
        volCreateInfo.setShareable(this.srcVolume.getShareable());
    }

    private void createSrcReplication(PoReplicaPairInfo pairInfo, VolumeInfo drVolumeInfo) {
        try {
            VolumeReplicationInfo replica = this.createReplica(drVolumeInfo, true);
            pairInfo.setReplicaUuid(this.pg.getPoProviderSN() + ":" + replica.getId());
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                pairInfo.setReplicaUuid(this.pg.getPoProviderSN() + ":" + e.getParameters()[0]);
            }
            LOG.error((Object)"Create production replication failed, protectGroup name=%s,replicaModel=%s,PoReplicaPairInfo=%s,drVolumeInfo=%s", new Object[]{this.pg.getName(), this.replicaModel, pairInfo, drVolumeInfo});
            throw e;
        }
    }

    private void createDrReplication(PoReplicaPairInfo pairInfo, VolumeInfo drVolumeInfo) {
        try {
            VolumeReplicationInfo drReplica = this.createReplica(drVolumeInfo, false);
            pairInfo.setDrReplicaUuid(this.pg.getPoProviderSN() + ":" + drReplica.getId());
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                pairInfo.setDrReplicaUuid(this.pg.getPoProviderSN() + ":" + e.getParameters()[0]);
            }
            LOG.error((Object)"Create disaster replication failed, protectGroup name=%s,replicaModel=%s,PoReplicaPairInfo=%s,drVolumeInfo=%s", new Object[]{this.pg.getName(), this.replicaModel, pairInfo, drVolumeInfo});
            throw e;
        }
    }

    private VolumeReplicationInfo createReplica(VolumeInfo drVolInfo, boolean isMaster) {
        String azName;
        String remoteDriverData;
        String driverData;
        String volumeId;
        String projUuid;
        String regionUuid;
        Map pgProps = this.pg.getProps();
        if (isMaster) {
            regionUuid = (String)pgProps.get("regionId");
            projUuid = (String)pgProps.get("projectId");
            volumeId = OpenStackCommonUtil.getIdFromUuid(this.srcVolume.getUuid());
            driverData = this.srcVolume.getReplicaDriverData();
            remoteDriverData = drVolInfo.getReplicaDriverData();
            azName = this.getMasterAzName(pgProps);
        } else {
            boolean flag = "hypermetro".equals(this.replicaModel) && (this.pg.getTemplate().getType() == 34 || this.pg.getTemplate().getType() == 37);
            regionUuid = flag ? (String)pgProps.get("regionId") : (String)pgProps.get("drRegionId");
            projUuid = flag ? (String)pgProps.get("projectId") : (String)pgProps.get("drProjectId");
            azName = this.getNotMasterAzName(pgProps, flag);
            volumeId = drVolInfo.getId();
            driverData = drVolInfo.getReplicaDriverData();
            remoteDriverData = this.srcVolume.getReplicaDriverData();
        }
        VolumeReplicaSchedulerHintInfo scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(isMaster ? this.srcVolume.getVolType() : drVolInfo.getVolumeType(), regionUuid, projUuid);
        boolean isStandby = false;
        this.checkScheduleInfo(drVolInfo, isMaster, scheduleInfo);
        this.printLog(isMaster, volumeId, driverData, remoteDriverData);
        VolumeReplicationInfo replicaCreateInfo = new VolumeReplicationInfo();
        replicaCreateInfo.setAzName(azName);
        replicaCreateInfo.setName(this.srcVolume.getName());
        replicaCreateInfo.setReplicaModel(this.replicaModel);
        replicaCreateInfo.setVolumeId(volumeId);
        replicaCreateInfo.setLocalReplicationDriverData(driverData);
        replicaCreateInfo.setRemoteReplicationDriverData(remoteDriverData);
        replicaCreateInfo.setMasterFlag(isMaster);
        replicaCreateInfo.setSchedulerHint(scheduleInfo);
        isStandby = this.isStandby(isMaster, volumeId, isStandby, replicaCreateInfo);
        VolumeReplicationInfo newReplicaInfo = this.volumeService.createVolReplica(replicaCreateInfo, regionUuid, projUuid);
        LOG.info((Object)"Create %s replication sucessfully.replicaId=%s,,volumeId=%s, protectGroup name=%s,replicaModel=%s,replication type:%s", new Object[]{isMaster ? " production" : "disaster", newReplicaInfo.getId(), volumeId, this.pg.getName(), this.replicaModel, isStandby ? "active" : "standby"});
        return newReplicaInfo;
    }

    private void printLog(boolean isMaster, String volumeId, String driverData, String remoteDriverData) {
        LOG.info((Object)"Start create %s, protectGroup name=%s,replication:volumeId=%s,srcVolume driverdata=%s,reomteVolume driverdata=%s,replicaModel=%s", new Object[]{isMaster ? " production" : "disaster", this.pg.getName(), volumeId, driverData, remoteDriverData, this.replicaModel});
    }

    private void checkScheduleInfo(VolumeInfo drVolInfo, boolean isMaster, VolumeReplicaSchedulerHintInfo scheduleInfo) {
        if (VerifyUtil.isEmpty((Object)scheduleInfo)) {
            LOG.error((Object)"Create %s replication failed. get volumeBackendName failed.scheduleInfo is null.protectGroup name=%s,target volumeType=%s", new Object[]{isMaster ? " production" : "disaster", this.pg.getName(), isMaster ? this.srcVolume.getVolType() : drVolInfo.getVolumeType()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean isStandby(boolean isMaster, String volumeId, boolean isStandby, VolumeReplicationInfo replicaCreateInfo) {
        if (!VerifyUtil.isEmpty((Collection)this.pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)this.pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            if (!VerifyUtil.isEmpty(this.drHyperUUIDTDrVolumeInfo)) {
                replicaCreateInfo.setIsStandby(Boolean.TRUE.toString());
            }
        } else if (!(VerifyUtil.isEmpty(this.drHyperUUIDTDrVolumeInfo) || this.pg.getTemplate().getType() != 34 && this.pg.getTemplate().getType() != 37)) {
            replicaCreateInfo.setIsStandby(Boolean.TRUE.toString());
            LOG.info((Object)"Create %s replication.replication type is standby, protectGroup name=%s, replicaModel=%s, volumeId=%s", new Object[]{isMaster ? " production" : "disaster", this.pg.getName(), this.replicaModel, volumeId});
            return true;
        }
        return isStandby;
    }

    private String getNotMasterAzName(Map<String, String> pgProps, boolean flag) {
        String azName = "hypermetro".equals(this.replicaModel) && this.pg.getTemplate().getType() == 37 ? pgProps.get("prod_region_drZoneName") : (flag ? pgProps.get("zoneName") : pgProps.get("drZoneName"));
        return azName;
    }

    private String getMasterAzName(Map<String, String> pgProps) {
        String azName = !VerifyUtil.isEmpty(this.drHyperUUIDTDrVolumeInfo) && this.pg.getTemplate().getType() == 37 ? pgProps.get("prod_region_drZoneName") : pgProps.get("zoneName");
        return azName;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public OpenStackVolume getSrcVolume() {
        return this.srcVolume;
    }

    public void setSrcVolume(OpenStackVolume srcVolume) {
        this.srcVolume = srcVolume;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public String getDrVolType() {
        return this.drVolType;
    }

    public void setDrVolType(String drVolType) {
        this.drVolType = drVolType;
    }

    public String getReplicaModel() {
        return this.replicaModel;
    }

    public void setReplicaModel(String replicaModel) {
        this.replicaModel = replicaModel;
    }
}

