/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicaSchedulerHintInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateProtectedVolumeBackTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(UpdateProtectedVolumeBackTask.class);
    private ProtectGroup protectGroup;
    private Set<ProtectedVolumeInfo> removedVolumes;
    private Set<ProtectedVolumeInfo> addedVolumes;
    private IVolumeService volumeService;
    private IProtectGroupRefreshService pgRefreshService;
    private String projUuid;
    private String drProjUuid;
    private String regionUuid;
    private String drRegionUuid;
    private String cgUuid;
    private String drCgUuid;
    private String drAzName;
    private String replicaModel;
    private Map<String, OpenStackVolume> addVolumes;
    private Map<String, String> drVolumeTypeMapping;
    private Set<String> addFailedVm = new HashSet<String>();
    private Set<String> removeFailedVm = new HashSet<String>();
    private Map<String, Boolean> alreadyOperateVol = new HashMap<String, Boolean>();
    private Map<String, PoReplicaPairInfo> addedPairInfo = new HashMap<String, PoReplicaPairInfo>();

    public UpdateProtectedVolumeBackTask(ProtectGroup protectGroup, Set<ProtectedVolumeInfo> removedVolumes, Set<ProtectedVolumeInfo> addedVolumes) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.openstack.updatevolume", (String)"System", (String)"", (String[])new String[]{protectGroup.getName()}), true);
        this.protectGroup = protectGroup;
        this.removedVolumes = removedVolumes;
        this.addedVolumes = addedVolumes;
        this.volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
    }

    protected void doWork() {
        boolean lockFlag;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RemovedVolumes:%s,addedVolumes:%s", new Object[]{JsonUtil.listToJsonArray(this.removedVolumes), JsonUtil.listToJsonArray(this.addedVolumes)});
        }
        if (!(lockFlag = ProtectionJobUtil.getInstance().getLockPg(this.protectGroup.getUuid()))) {
            LOG.error((Object)("The pg is locked: " + this.protectGroup.getUuid()), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            this.protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.protectGroup.getUuid(), false);
            this.initParam();
            if (!VerifyUtil.isEmpty(this.addVolumes)) {
                this.checkVolumeTypes();
            }
            for (ProtectObject po : this.protectGroup.getPolist()) {
                if ("true".equals(po.getProps().get("TOBEDELETED")) || "true".equals(po.getProps().get("OBJ_DELETE_ERROR"))) {
                    LOG.info((Object)"This po is to be deleted,can't be updated :poName=%s", new Object[]{po.getName()});
                    continue;
                }
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
                if (null == poReplicaInfo) {
                    LOG.error((Object)"Json to bean failed:replicationInfo=%s", new Object[]{replicationInfo});
                    continue;
                }
                this.deleteProtectObjectVolumePairResource(po, poReplicaInfo);
                this.createProtectObjectVolumePairResource(this.protectGroup, po, poReplicaInfo);
                po.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.protectGroup);
            if (!VerifyUtil.isEmpty(this.addFailedVm) || !VerifyUtil.isEmpty(this.removeFailedVm)) {
                throw new LegoCheckedException(0x300001L, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Update volume error: " + this.protectGroup.getUuid()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Save pg error: " + this.protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(this.protectGroup.getUuid());
            this.refreshPg();
        }
    }

    private void checkVolumeTypes() {
        HashSet<String> volTypeNameSet = new HashSet<String>();
        HashSet<String> drVolTypeNameSet = new HashSet<String>();
        for (OpenStackVolume volume : this.addVolumes.values()) {
            volTypeNameSet.add(volume.getVolType());
        }
        List volTypeList = this.volumeService.getVolumeTypesByName(volTypeNameSet, this.regionUuid, this.projUuid);
        LOG.info((Object)"Update volume back task :will add and po volume types:%s", new Object[]{volTypeNameSet});
        String localDevSn = (String)this.protectGroup.getProps().get("localStorageDevSn");
        boolean isFromSameDev = this.isAllFromTheDev(localDevSn, volTypeList);
        if (!isFromSameDev) {
            LOG.error((Object)"The volumetypes are not from the same device:%s", new Object[]{volTypeNameSet});
            throw new LegoCheckedException(1073948415L);
        }
        for (ProtectedVolumeInfo volumeInfo : this.addedVolumes) {
            drVolTypeNameSet.add(volumeInfo.getDrVolumeType());
        }
        volTypeList = this.volumeService.getVolumeTypesByName(drVolTypeNameSet, this.drRegionUuid, this.drProjUuid);
        String remoteDevSn = (String)this.protectGroup.getProps().get("remoteStorageDevSn");
        isFromSameDev = this.isAllFromTheDev(remoteDevSn, volTypeList);
        LOG.info((Object)"Update volume back task :will add and po drvolume types:%s", new Object[]{drVolTypeNameSet});
        if (!isFromSameDev) {
            LOG.error((Object)"The drvolumetypes are not from the same device:%s", new Object[]{drVolTypeNameSet});
            throw new LegoCheckedException(1073948413L);
        }
    }

    private boolean isAllFromTheDev(String devSn, List<OpenStackVolumeType> volTypeList) {
        for (OpenStackVolumeType type : volTypeList) {
            if (!VerifyUtil.isEmpty((String)type.getDevSn()) && type.getDevSn().equals(devSn)) continue;
            return false;
        }
        return true;
    }

    private void refreshPg() {
        try {
            if (!VerifyUtil.isEmpty((Object)this.pgRefreshService)) {
                this.pgRefreshService.refreshProtectGroup(this.protectGroup);
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.protectGroup.getName() + "refresh failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void deleteProtectObjectVolumePairResource(ProtectObject po, PoReplicaInfo poReplicaInfo) {
        ArrayList pairInfoList = new ArrayList(poReplicaInfo.getPairInfos());
        for (ProtectedVolumeInfo volumeInfo : this.removedVolumes) {
            String volumeUuid = volumeInfo.getVolumeId();
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (!volumeUuid.equals(pairInfo.getVolumeUuid())) continue;
                boolean isSuccess = this.removeVolumePairResource(pairInfo);
                if (isSuccess) {
                    pairInfoList.remove(pairInfo);
                    this.removeUsedStorageResource(po, pairInfo.getVolumeUuid());
                    continue;
                }
                pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.RELEASING.getStatus());
                this.removeFailedVm.add(po.getUuid());
            }
        }
        poReplicaInfo.setPairInfos(pairInfoList);
    }

    private void createProtectObjectVolumePairResource(ProtectGroup pg, ProtectObject po, PoReplicaInfo poReplicaInfo) {
        ArrayList pairInfoList = new ArrayList(poReplicaInfo.getPairInfos());
        for (ProtectedVolumeInfo volumeInfo : this.addedVolumes) {
            String volumeUuid = volumeInfo.getVolumeId();
            for (PoReplicaPairInfo pairInfo : pairInfoList) {
                if (!volumeUuid.equals(pairInfo.getVolumeUuid())) continue;
                boolean isSuccess = this.configReplication(pg, po, pairInfo);
                this.addedPairInfo.put(pairInfo.getVolumeUuid(), pairInfo);
                this.alreadyOperateVol.put(pairInfo.getVolumeUuid(), isSuccess);
                if (isSuccess) {
                    pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus());
                    this.addUsedStorageInfo(po, this.addVolumes.get(volumeUuid));
                    continue;
                }
                pairInfo.setVolumeStatus(OpenstackEnumDefine.VolProtectStatusE.CONFIGING.getStatus());
                this.addFailedVm.add(po.getUuid());
            }
        }
        poReplicaInfo.setPairInfos(pairInfoList);
    }

    private boolean configReplication(ProtectGroup pg, ProtectObject po, PoReplicaPairInfo pairInfo) {
        boolean isSuccess = true;
        String volumeUuid = pairInfo.getVolumeUuid();
        if (this.addedPairInfo.containsKey(volumeUuid)) {
            pairInfo.setDrVolumeUuid(this.addedPairInfo.get(volumeUuid).getDrVolumeUuid());
            pairInfo.setDrVolumeType(this.addedPairInfo.get(volumeUuid).getDrVolumeType());
            pairInfo.setReplicaUuid(this.addedPairInfo.get(volumeUuid).getReplicaUuid());
            pairInfo.setDrReplicaUuid(this.addedPairInfo.get(volumeUuid).getDrReplicaUuid());
            pairInfo.setVolumeStatus(this.addedPairInfo.get(volumeUuid).getVolumeStatus());
            return null == this.alreadyOperateVol.get(volumeUuid) ? false : this.alreadyOperateVol.get(volumeUuid);
        }
        OpenStackVolume volume = this.addVolumes.get(volumeUuid);
        if (null == volume) {
            LOG.error((Object)"Can not find src volume:%s", new Object[]{volumeUuid});
            return false;
        }
        try {
            HashSet<String> addSrcRepUuids = new HashSet<String>();
            HashSet<String> addDrRepUuids = new HashSet<String>();
            VolumeInfo drVolume = this.createDrVolume(po, pairInfo, volume);
            if (null == drVolume) {
                LOG.error((Object)("Can not find create volume:" + pairInfo.getDrVolumeUuid()));
                return false;
            }
            PolicyTemplate policyTemplate = pg.getTemplate();
            List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)policyTemplate);
            int rateLevel = OpenstackEnumDefine.ReplicaBandwidthE.valueOf((int)ProtectGroupUtil.getRateLevel((List)pgsrps)).getBandWidth();
            String replicaId = this.createReplicationInSrc(po, pairInfo, volume, drVolume, rateLevel);
            addSrcRepUuids.add(replicaId);
            String drReplicaId = this.createReplicationInDr(po, pairInfo, volume, drVolume, rateLevel);
            addDrRepUuids.add(drReplicaId);
            this.volumeService.reserveVolume(drVolume.getId(), this.drRegionUuid, this.drProjUuid);
            this.volumeService.updateVolumeReplicationCG(this.regionUuid, this.projUuid, this.cgUuid, addSrcRepUuids, null);
            this.volumeService.updateVolumeReplicationCG(this.drRegionUuid, this.drProjUuid, this.drCgUuid, addDrRepUuids, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Create volume resource error:" + po.getName() + "_" + volume.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
            isSuccess = false;
        }
        return isSuccess;
    }

    private String createReplicationInDr(ProtectObject po, PoReplicaPairInfo pairInfo, OpenStackVolume volume, VolumeInfo drVolume, int rateLevel) {
        if (VerifyUtil.isEmpty((String)pairInfo.getDrReplicaUuid())) {
            VolumeReplicationInfo newDrReplicaInfo = this.createReplicationAsSlaveRole(volume, drVolume, rateLevel);
            pairInfo.setDrReplicaUuid(po.getProviderSN() + ":" + newDrReplicaInfo.getId());
            return newDrReplicaInfo.getId();
        }
        return OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrReplicaUuid());
    }

    private String createReplicationInSrc(ProtectObject po, PoReplicaPairInfo pairInfo, OpenStackVolume volume, VolumeInfo drVolume, int rateLevel) {
        if (VerifyUtil.isEmpty((String)pairInfo.getReplicaUuid())) {
            VolumeReplicationInfo newReplicaInfo = this.createReplicationAsMasterRole(volume, drVolume, rateLevel);
            pairInfo.setReplicaUuid(po.getProviderSN() + ":" + newReplicaInfo.getId());
            return newReplicaInfo.getId();
        }
        return OpenStackCommonUtil.getIdFromUuid(pairInfo.getReplicaUuid());
    }

    private VolumeInfo createDrVolume(ProtectObject po, PoReplicaPairInfo pairInfo, OpenStackVolume volume) {
        VolumeInfo drVolume;
        String drVolumeUuid = pairInfo.getDrVolumeUuid();
        if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
            VolumeCreateInfo createVolume = new VolumeCreateInfo();
            createVolume = OpenStackCommonUtil.setDrVolumeMode(volume, createVolume);
            createVolume.setProjectId(this.projUuid);
            createVolume.setSize(volume.getSize().intValue());
            String drVolumeName = OpenStackCommonUtil.getNameBySuff(volume.getName(), "-DR");
            createVolume.setName(drVolumeName);
            createVolume.setAzName(this.drAzName);
            createVolume.setVolTypeName(this.drVolumeTypeMapping.get(volume.getUuid()));
            createVolume.setShareable(volume.getShareable());
            drVolume = this.volumeService.createVolume(volume.getVolumeDriverMetadata(), createVolume, this.drRegionUuid, this.drProjUuid, volume.getBootable().booleanValue());
            pairInfo.setDrVolumeUuid(OpenStackCommonUtil.getObjectUuid(po.getProviderSN(), drVolume.getId()));
            pairInfo.setDrVolumeType(this.drVolumeTypeMapping.get(volume.getUuid()));
        } else {
            drVolume = this.volumeService.queryVolumeInfoByUuid(this.drRegionUuid, this.drProjUuid, drVolumeUuid);
        }
        return drVolume;
    }

    private VolumeReplicationInfo createReplicationAsSlaveRole(OpenStackVolume volume, VolumeInfo drVolume, int rateLevel) {
        VolumeReplicaSchedulerHintInfo scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(drVolume.getVolumeType(), this.drRegionUuid, this.drProjUuid);
        if (VerifyUtil.isEmpty((Object)scheduleInfo)) {
            LOG.error((Object)"Get SrcVolumeBackendName failed.");
            throw new LegoCheckedException(1073947393L);
        }
        VolumeReplicationInfo drReplicaCreateInfo = new VolumeReplicationInfo();
        drReplicaCreateInfo.setAzName(this.drAzName);
        drReplicaCreateInfo.setReplicaModel(this.replicaModel);
        drReplicaCreateInfo.setVolumeId(drVolume.getId());
        drReplicaCreateInfo.setLocalReplicationDriverData(drVolume.getReplicaDriverData());
        drReplicaCreateInfo.setRemoteReplicationDriverData(volume.getReplicaDriverData());
        drReplicaCreateInfo.setName("replica_" + drVolume.getName());
        drReplicaCreateInfo.setMasterFlag(false);
        drReplicaCreateInfo.setSchedulerHint(scheduleInfo);
        drReplicaCreateInfo.setReplicaBandwidth(rateLevel);
        return this.volumeService.createVolReplica(drReplicaCreateInfo, this.drRegionUuid, this.drProjUuid);
    }

    private VolumeReplicationInfo createReplicationAsMasterRole(OpenStackVolume volume, VolumeInfo drVolume, int rateLevel) {
        VolumeReplicaSchedulerHintInfo scheduleInfo = this.volumeService.getSchedulerHintInfoFromVolumeType(volume.getVolType(), this.regionUuid, this.projUuid);
        if (VerifyUtil.isEmpty((Object)scheduleInfo)) {
            LOG.error((Object)"Get SrcVolumeBackendName failed.");
            throw new LegoCheckedException(1073947393L);
        }
        VolumeReplicationInfo replicaCreateInfo = new VolumeReplicationInfo();
        replicaCreateInfo.setAzName(volume.getAz());
        replicaCreateInfo.setReplicaModel(this.replicaModel);
        replicaCreateInfo.setVolumeId(OpenStackCommonUtil.getIdFromUuid(volume.getUuid()));
        replicaCreateInfo.setLocalReplicationDriverData(volume.getReplicaDriverData());
        replicaCreateInfo.setRemoteReplicationDriverData(drVolume.getReplicaDriverData());
        replicaCreateInfo.setName("replica_" + volume.getName());
        replicaCreateInfo.setMasterFlag(true);
        replicaCreateInfo.setSchedulerHint(scheduleInfo);
        replicaCreateInfo.setReplicaBandwidth(rateLevel);
        return this.volumeService.createVolReplica(replicaCreateInfo, this.regionUuid, this.projUuid);
    }

    private void addUsedStorageInfo(ProtectObject po, OpenStackVolume volume) {
        LOG.debug((Object)"Enter addUsedStorageInfo, poname=%s", new Object[]{po.getName()});
        String bootDevName = (String)po.getProps().get("VM_ROOT_DEVNAME_KEY");
        ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
        storage.setId(UUIDGenerator.getUUID());
        storage.setResourceName(volume.getName());
        storage.setLunWWN(volume.getUuid());
        storage.setResourceId(volume.getUuid());
        storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
        volume.generateAttachmentInfo();
        String deviceName = "";
        for (OpenStackVolAttachment attachment : volume.getAttachments()) {
            if (!po.getMoUuid().equals(attachment.getVmUuid())) continue;
            deviceName = attachment.getDevice();
            storage.setDeviceName(deviceName);
            if (VerifyUtil.isEmpty((String)attachment.getDevice()) || !attachment.getDevice().equals(bootDevName)) continue;
            po.getProps().put("VM_BOOTABLE_VOLUME", volume.getUuid());
        }
        Set oldStorages = po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo info : oldStorages) {
            if (!volume.getUuid().equals(info.getResourceId())) continue;
            info.setDeviceName(deviceName);
            info.setResourceName(volume.getName());
            LOG.info((Object)"The device Name has add.");
            return;
        }
        po.addHostStorageResourceInfo(storage);
    }

    private Map<String, OpenStackVolume> getAddVolumeInfo() {
        if (VerifyUtil.isEmpty(this.addedVolumes)) {
            return new HashMap<String, OpenStackVolume>();
        }
        ArrayList<String> volumeUuids = new ArrayList<String>();
        for (ProtectedVolumeInfo volumeInfo : this.addedVolumes) {
            volumeUuids.add(volumeInfo.getVolumeId());
        }
        List addVolumesList = this.volumeService.queryVolumesByUuid(this.regionUuid, this.projUuid, volumeUuids, false);
        HashMap<String, OpenStackVolume> result = new HashMap<String, OpenStackVolume>();
        for (OpenStackVolume vol : addVolumesList) {
            result.put(vol.getUuid(), vol);
        }
        return result;
    }

    private Map<String, String> getDrVolumeTypeMapping() {
        if (VerifyUtil.isEmpty(this.addedVolumes)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ProtectedVolumeInfo volumeInfo : this.addedVolumes) {
            result.put(volumeInfo.getVolumeId(), volumeInfo.getDrVolumeType());
        }
        return result;
    }

    private boolean removeVolumePairResource(PoReplicaPairInfo pair) {
        if (this.alreadyOperateVol.containsKey(pair.getVolumeUuid())) {
            return this.alreadyOperateVol.get(pair.getVolumeUuid());
        }
        HashSet<String> removeSrcRepUuids = new HashSet<String>();
        HashSet<String> removeDrRepUuids = new HashSet<String>();
        removeSrcRepUuids.add(pair.getReplicaUuid());
        removeDrRepUuids.add(pair.getDrReplicaUuid());
        boolean isSuccess = true;
        try {
            this.volumeService.updateVolumeReplicationCG(this.regionUuid, this.projUuid, this.cgUuid, null, removeSrcRepUuids);
            this.volumeService.updateVolumeReplicationCG(this.drRegionUuid, this.drProjUuid, this.drCgUuid, null, removeDrRepUuids);
            this.volumeService.delVolReplica(this.regionUuid, this.projUuid, pair.getReplicaUuid(), false, false);
            this.volumeService.delVolReplica(this.drRegionUuid, this.drProjUuid, pair.getDrReplicaUuid(), false, false);
            this.volumeService.delVolume(pair.getDrVolumeUuid(), this.drRegionUuid, this.drProjUuid);
        }
        catch (Exception e) {
            isSuccess = false;
            LOG.error((Object)("Delete volume resource error. volName:" + pair.getVolumeName() + "volUuid:" + pair.getVolumeUuid() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        this.alreadyOperateVol.put(pair.getVolumeUuid(), isSuccess);
        return isSuccess;
    }

    private void removeUsedStorageResource(ProtectObject po, String volumeUuid) {
        LOG.debug((Object)"Enter removeUsedStorageResource,poname=%s", new Object[]{po.getName()});
        Iterator itr = po.getUsedStorageResourceSet().iterator();
        while (itr.hasNext()) {
            if (!volumeUuid.equals(((ProtectObjectStorageInfo)itr.next()).getResourceId())) continue;
            itr.remove();
            break;
        }
    }

    private void initParam() {
        this.projUuid = (String)this.protectGroup.getProps().get("projectId");
        this.drProjUuid = (String)this.protectGroup.getProps().get("drProjectId");
        this.regionUuid = (String)this.protectGroup.getProps().get("regionId");
        this.drRegionUuid = (String)this.protectGroup.getProps().get("drRegionId");
        this.cgUuid = (String)this.protectGroup.getProps().get("replicaCgUuid");
        this.drCgUuid = (String)this.protectGroup.getProps().get("drReplicaCgUuid");
        this.drAzName = (String)this.protectGroup.getProps().get("drZoneName");
        this.addVolumes = this.getAddVolumeInfo();
        this.drVolumeTypeMapping = this.getDrVolumeTypeMapping();
        this.replicaModel = UpdateProtectedVolumeBackTask.getReplicaModel(this.protectGroup.getTemplate().getType());
    }

    public static String getReplicaModel(int type) {
        String ret = "";
        switch (type) {
            case 22: {
                ret = "async";
                break;
            }
            case 21: {
                ret = "sync";
                break;
            }
            case 25: {
                ret = "hypermetro";
                break;
            }
            case 29: {
                ret = "hypermetro";
                break;
            }
            case 34: {
                ret = "async";
                break;
            }
            case 37: {
                ret = "async";
                break;
            }
            default: {
                LOG.error((Object)("Not support templateType,type=" + type));
            }
        }
        return ret;
    }

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    public ProtectGroup getProtectGroup() {
        return this.protectGroup;
    }

    public void setProtectGroup(ProtectGroup protectGroup) {
        this.protectGroup = protectGroup;
    }

    public Set<ProtectedVolumeInfo> getAddedVolumes() {
        return this.addedVolumes;
    }

    public void setAddedVolumes(Set<ProtectedVolumeInfo> addedVolumes) {
        this.addedVolumes = addedVolumes;
    }

    public String getProjUuid() {
        return this.projUuid;
    }

    public void setProjUuid(String projUuid) {
        this.projUuid = projUuid;
    }

    public String getRegionUuid() {
        return this.regionUuid;
    }

    public void setRegionUuid(String regionUuid) {
        this.regionUuid = regionUuid;
    }
}

