/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class DelLinkedCloneVolProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8321698132728644345L;
    private static final Log LOG = LogFactory.getInstance(DelLinkedCloneVolProcessor.class);

    public DelLinkedCloneVolProcessor() {
    }

    public DelLinkedCloneVolProcessor(String linkedCloneVolUuid, String drRegionUuid, String drProjUuid, String volName) {
        this.addString("linkedCloneVolId", linkedCloneVolUuid);
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("volName", volName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into DelLinkedCloneVolProcessor");
        String linkedCloneVolUuid = this.getString("linkedCloneVolId");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String volName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)linkedCloneVolUuid)) {
            LOG.info((Object)"LinkedCloneVolUuid is empty");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            VolumeInfo vol = cinderMgr.queryVolume(drRegionUuid, tokenId, drProjUuid, linkedCloneVolUuid);
            if (null == vol) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                LOG.info((Object)"Vol(%s) doesn't exit.", new Object[]{linkedCloneVolUuid});
                this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
                return true;
            }
            AsyncTaskResponse response = cinderMgr.deleteVolume(linkedCloneVolUuid, drRegionUuid, tokenId, drProjUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                LOG.error((Object)"Del linkedClone vol(%s)failed, errorcode is %s", new Object[]{linkedCloneVolUuid, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Del linkedClone vol(" + linkedCloneVolUuid + ")failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave DelLinkedCloneVolProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

