/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapshotActiveInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;

public class OpenStackActiveVolSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6770293680452501871L;
    private static final Log LOG = LogFactory.getInstance(OpenStackActiveVolSnapshotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackActiveVolSnapshotProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = OpenStackRecoveryTool.getRegionIdFromCshaCsdrProtectGroup(pg);
        String drProjUuid = OpenStackRecoveryTool.getProjectIdFromCshaCsdrProtectGroup(pg);
        try {
            ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManagerByVersion("6.1");
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
            cinderMgr.activeVolSnapShot(drRegionUuid, drProjUuid, tokenId, this.getActiveSnapShotInfo());
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Active volSnapShot failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackActiveVolSnapshotProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private VolumeSnapshotActiveInfo getActiveSnapShotInfo() {
        OpenStackCreateVolSnapshotProcessor createVolSnapshotProcessor = (OpenStackCreateVolSnapshotProcessor)this.getPreviousProcessor();
        ArrayList<VolumeSnapshotActiveInfo.VolumeSnapshot> volumeSnapshots = new ArrayList<VolumeSnapshotActiveInfo.VolumeSnapshot>();
        String voldUuId = "";
        for (RecoveryProcessor processor : createVolSnapshotProcessor.getChildProc()) {
            VolumeSnapshotActiveInfo.VolumeSnapshot volumeSnapshot = new VolumeSnapshotActiveInfo.VolumeSnapshot();
            String providerLocation = processor.getString("providerAuth");
            LOG.info((Object)"ProviderLocation:%s", new Object[]{providerLocation});
            volumeSnapshot.setProviderLocation(providerLocation);
            volumeSnapshots.add(volumeSnapshot);
            voldUuId = processor.getString("volUuid");
        }
        VolumeSnapshotActiveInfo.SnapshotsInfo snapshotsInfo = new VolumeSnapshotActiveInfo.SnapshotsInfo();
        snapshotsInfo.setVolumeId(OpenStackCommonUtil.getIdFromUuid(voldUuId));
        snapshotsInfo.setVolumeSnapshots(volumeSnapshots);
        VolumeSnapshotActiveInfo activeInfo = new VolumeSnapshotActiveInfo();
        activeInfo.setSnapshots(snapshotsInfo);
        return activeInfo;
    }
}

