/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;

public class OpenStackCheckDataConsistencyProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6033983210489674659L;
    private static final long[] STATUS_QUERY_SLEEP_QUEUE = new long[]{3000L, 5000L, 8000L, 12000L, 17000L, 17000L, 12000L, 8000L, 5000L, 3000L};
    private static final Log LOG = LogFactory.getInstance(OpenStackCheckDataConsistencyProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackCheckDataStatusProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getDrReplicaCgUuid(pg));
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        String replicationStatus = OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue();
        for (long sleepTime : STATUS_QUERY_SLEEP_QUEUE) {
            VolumeReplicationCgInfo cgInfo = this.getVolumeReplicationCgInfo(drRegionUuid, drProjUuid, drReplicaCgUuid, mgr, tokenId);
            if (this.checkReplicationCgInfo(recoveryPlan, cgInfo)) {
                return false;
            }
            replicationStatus = cgInfo.getReplicationStatus();
            String status = cgInfo.getStatus();
            if (this.checkStatusAvailable(recoveryPlan, status)) {
                return false;
            }
            if (this.checkWhenDisasterRecovery(recoveryPlan)) {
                return true;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != this.getProcType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != this.getProcType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() != this.getProcType()) continue;
            if (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicationStatus)) {
                LOG.info((Object)"Replica's replicaionstatus is %s", new Object[]{replicationStatus});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            LOG.warn((Object)"Replica's replicaionstatus is not active: %s,recoveryPlan name=%s", new Object[]{replicationStatus, OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            CommonUtil.sleep((long)sleepTime);
        }
        LOG.info((Object)"Time out, Leave OpenStackCheckDataStatusProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err." + OpenstackEnumDefine.ReplicationRepStatusE.getErrorCode((String)replicationStatus), null);
        return false;
    }

    private boolean checkReplicationCgInfo(RecoveryPlan recoveryPlan, VolumeReplicationCgInfo cgInfo) {
        if (null == cgInfo) {
            LOG.error((Object)"Replica is null,recoveryPlanName=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return true;
        }
        return false;
    }

    private boolean checkStatusAvailable(RecoveryPlan recoveryPlan, String status) {
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
            LOG.error((Object)"Replica's status is not avaiable.,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return true;
        }
        return false;
    }

    private boolean checkWhenDisasterRecovery(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            LOG.info((Object)"Leave OpenStackCheckDataStatusProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        return false;
    }

    private VolumeReplicationCgInfo getVolumeReplicationCgInfo(String drRegionUuid, String drProjUuid, String drReplicaCgUuid, DrExtendManager mgr, String tokenId) {
        VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? mgr.queryRealtimeVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid), new int[0]) : mgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid));
        return cgInfo;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.dr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.test.des");
        }
    }
}

