/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolSnapshotSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OpenStackCreateVolSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2014969167052923435L;
    private static final Log LOG = LogFactory.getInstance(OpenStackReserveVolumeProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackCreateVolSnapshotProcessor");
        this.generateProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"OpenStackCreateVolSnapshotProcessor:no child processor");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.info((Object)"Leave OpenStackCreateVolSnapshotProcessor");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generateProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        Map<String, String> productVoldToDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan(), PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(context.getRecoveryPlan().getProtectGroup()));
        String drRegionUuid = OpenStackRecoveryTool.getRegionIdFromCshaCsdrProtectGroup(pg);
        String drProjUuid = OpenStackRecoveryTool.getProjectIdFromCshaCsdrProtectGroup(pg);
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumeList = volService.getVolumesFromOpenstack(drRegionUuid, drProjUuid);
        HashSet<String> drVolUuids = new HashSet<String>();
        HashSet<OpenStackCreateVolSnapshotSubProcessor> subProcessors = new HashSet<OpenStackCreateVolSnapshotSubProcessor>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String drVolId = entry.getValue();
            if (drVolUuids.contains(drVolId)) continue;
            drVolUuids.add(drVolId);
            String drVolName = this.buildVolName(drVolId, volumeList);
            OpenStackCreateVolSnapshotSubProcessor subProcessor = new OpenStackCreateVolSnapshotSubProcessor(drRegionUuid, drProjUuid, drVolId, drVolName);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private String buildVolName(String volumeUuid, List<OpenStackVolume> reginVolumeList) {
        for (OpenStackVolume openStackVolume : reginVolumeList) {
            if (!openStackVolume.getUuid().equals(volumeUuid)) continue;
            return openStackVolume.getName();
        }
        LOG.error((Object)"Volume not found : %s", new Object[]{OpenStackCommonUtil.getIdFromUuid(volumeUuid)});
        return OpenStackCommonUtil.getIdFromUuid(volumeUuid);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

