/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class OpenStackDcCinderStatusCheckProcessor
extends OpenStackDcStatusCheck {
    private static final long serialVersionUID = -8239341885159426993L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDcCinderStatusCheckProcessor.class);
    private static final String VOLUME_ID = "3d781ba4-b55e-46bd-abee-9137ac50acd5";
    private transient CinderManager cinderManager;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean checkServerStatus = this.checkServerStatus(context);
        if (checkServerStatus) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOG.info((Object)"Leave OpenStackDcCinderStatusCheckProcessor:check successed.recoveryPlan name=%s", new Object[]{recoveryPlan != null ? recoveryPlan.getName() : ""});
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.dc.check.error", new String[0]);
        LOG.info((Object)"Leave OpenStackDcNovaStatusCheckProcessor:check failed.recoveryPlan name=%s", new Object[]{recoveryPlan != null ? recoveryPlan.getName() : ""});
        return false;
    }

    @Override
    protected boolean checkSingleStatus(String regionUuid, String projUuid, String tokenId) {
        try {
            if (this.cinderManager == null) {
                this.cinderManager = new CinderManager();
            }
            this.cinderManager.queryVolume(regionUuid, tokenId, projUuid, VOLUME_ID);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                LOG.error((Object)String.format(Locale.ROOT, "OpenStackDcCinderStatusCheckProcessor queryVolume ( %s, %s, %s ) failed.", regionUuid, projUuid, VOLUME_ID), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"OpenStackDcCinderStatusCheckProcessor queryVolume ( %s, %s, %s ) other exception.", new Object[]{regionUuid, projUuid, VOLUME_ID});
        }
        return true;
    }
}

