/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.CreateLinkedCloneVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.DelLinkedCloneVolProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackDelLinkedCloneVolSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6747059585502087564L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDelLinkedCloneVolSubProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackDelLinkedCloneVolSubProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        this.generateSubProcessors();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processor");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        LOG.info((Object)"Out OpenStackDelLinkedCloneVolSubProcessor");
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), CreateLinkedCloneVolumeProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<DelLinkedCloneVolProcessor> subProcessors = new HashSet<DelLinkedCloneVolProcessor>();
        for (RecoveryProcessor processor : createProcessors) {
            CreateLinkedCloneVolumeProcessor tempProcessor = (CreateLinkedCloneVolumeProcessor)processor;
            DelLinkedCloneVolProcessor subProcessor = new DelLinkedCloneVolProcessor(tempProcessor.getString("linkedCloneVolId"), tempProcessor.getString("regionUuid"), tempProcessor.getString("projUuid"), tempProcessor.getString("volName"));
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

