/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackHyperMetroCheckDataConsistencyProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7629564109837738252L;
    private static final Log LOG = LogFactory.getInstance(OpenStackHyperMetroCheckDataConsistencyProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        String tokenId;
        DrExtendManager mgr;
        VolumeReplicationCgInfo cgInfo;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackHyperMetroCheckDataStatusProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drReplicaCgUuid"));
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("drProjectId");
            drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("hyperProdrCgUuid"));
        }
        if (null == (cgInfo = this.getVolumeReplicationCgInfo(drRegionUuid, drProjUuid, drReplicaCgUuid, mgr = new DrExtendManager(), tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid)))) {
            LOG.error((Object)"Replica is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        String replicationStatus = cgInfo.getReplicationStatus();
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
            LOG.error((Object)"Replica's status is not avaiable,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicationStatus)) {
            LOG.info((Object)"Replica's replicaionstatus is %s,recoveryPlan name=%s", new Object[]{replicationStatus, OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        LOG.error((Object)"Replica's replicaionstatus is not expected:%s,recoveryPlan name=%s", new Object[]{replicationStatus, OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err." + OpenstackEnumDefine.ReplicationRepStatusE.getErrorCode((String)replicationStatus), null);
        return false;
    }

    private VolumeReplicationCgInfo getVolumeReplicationCgInfo(String drRegionUuid, String drProjUuid, String drReplicaCgUuid, DrExtendManager mgr, String tokenId) {
        VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? mgr.queryRealtimeVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid), new int[0]) : mgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid));
        return cgInfo;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.openstack.recovery.processor.OpenStackCheckDataConsistencyProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
    }
}

