/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmByPriorityProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OpenStackPowerOnVmsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 221750911585405894L;
    private static final Log LOG = LogFactory.getInstance(OpenStackPowerOnVmsProcessor.class);
    private static final int DEFAULT_START_PRI = 1;
    private static final String INTERFACE = "interface";

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackPowerOnVmsProcessor recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.generateSubProcessors(context);
        LOG.debug((Object)"OpenStackPowerOnVmsProcessor complete sub recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processors.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            LOG.error((Object)"recoveryTemplate is null.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        LOG.debug((Object)"Leave OpenStackPowerOnVmsProcessor complete sub recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        LOG.info((Object)"OpenStackPowerOnVmsProcessor get status recoveryPlan=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashMap priorityToPos = new HashMap();
        Set recSettings = context.getRecoveryPlan().getRecoverySettings();
        ProtectGroup pg = context.getProtectGroup();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                LOG.info((Object)"Po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            this.refreshVMAddressMap(context, po);
            if (!this.isPhVmNeedStart(po.getUuid(), context.getRecoveryPlan()).booleanValue()) continue;
            Integer priority = this.getPoStartPriority(recSettings, po.getUuid());
            if (priorityToPos.containsKey(priority)) {
                ((Set)priorityToPos.get(priority)).add(po);
                continue;
            }
            HashSet<ProtectObject> poSet = new HashSet<ProtectObject>();
            poSet.add(po);
            priorityToPos.put(priority, poSet);
        }
        ArrayList startVmPrioritys = new ArrayList(priorityToPos.keySet());
        Collections.sort(startVmPrioritys);
        OpenStackPowerOnVmByPriorityProcessor preProcessor = null;
        HashSet<OpenStackPowerOnVmByPriorityProcessor> subProcessors = new HashSet<OpenStackPowerOnVmByPriorityProcessor>();
        for (Integer priority : startVmPrioritys) {
            Set pos = (Set)priorityToPos.get(priority);
            OpenStackPowerOnVmByPriorityProcessor subProcessor = new OpenStackPowerOnVmByPriorityProcessor(pos, priority);
            if (null != preProcessor) {
                preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
                subProcessor.setPreviousProcessor((RecoveryProcessor)preProcessor);
            }
            preProcessor = subProcessor;
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void refreshVMAddressMap(RecoveryProcessorContext context, ProtectObject po) {
        Optional hypervisorInfo;
        ProtectGroup pg = context.getProtectGroup();
        if (!FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.5.1") || !"ECS".equals(po.getProperty("vm_type"))) {
            LOG.info((Object)"VM type is ECS and FC version is high than 6.5.1. Don't refresh Vm AddressMap. pg:%s, pg type: %s, po name :%s", new Object[]{pg.getName(), pg.getTemplate().getType(), po.getName()});
            return;
        }
        String regionUuid = pg.getProperty("drRegionId");
        String projectUuid = pg.getProperty("drProjectId");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            regionUuid = pg.getProperty("regionId");
            projectUuid = pg.getProperty("projectId");
        }
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String vmAddressMap = po.getProperty("vm_addressMap");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "PLACEHOLDVM");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, "CSHAPLACEHOLDVM");
        }
        if (!OpenStackCommonUtil.isSwitchNetWork(pg)) {
            List<VMInterface> vmInterfaces = JsonUtil.jsonArrayToList(po.getProperty("vm_interface"), VMInterface.class);
            List<VMInterface> drVmInterfaces = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, phVmUuid);
            vmAddressMap = this.updateVmAddressMap(vmAddressMap, vmInterfaces, drVmInterfaces);
        }
        if (!PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg) && (hypervisorInfo = novaMgr.getHypervisorInfoByAz(regionUuid, projectUuid, tokenId, pg.getProperty("drZoneName")).stream().findFirst()).isPresent() && "FusionCompute".equals(((HypervisorInfo)hypervisorInfo.get()).getHypervisorType())) {
            return;
        }
        LOG.info((Object)"Execute refreshVMAddressMap, pg: %s, phVmUuid: %s", new Object[]{pg.getName(), phVmUuid});
        novaMgr.refreshVMAddressMap(regionUuid, projectUuid, phVmUuid, vmAddressMap, tokenId);
    }

    private String updateVmAddressMap(String vmAddressMap, List<VMInterface> vmInterfaces, List<VMInterface> drVmInterfaces) {
        JSONObject vmAddressMapJson = JSONObject.fromObject((Object)vmAddressMap);
        JSONObject interfaceJson = vmAddressMapJson.getJSONObject(INTERFACE);
        Map<String, String> ipAddressPortIdMap = this.getIpAddressToPortId(vmInterfaces);
        Map<String, String> drIpAddressPortIdMap = this.getIpAddressToPortId(drVmInterfaces);
        ipAddressPortIdMap.forEach((addressIp, value) -> {
            if (drIpAddressPortIdMap.containsKey(addressIp)) {
                LOG.info((Object)"the same IP address is %s", new Object[]{addressIp});
                String portId = (String)ipAddressPortIdMap.get(addressIp);
                String drPortId = (String)drIpAddressPortIdMap.get(addressIp);
                interfaceJson.put((Object)drPortId, interfaceJson.get(portId));
                interfaceJson.remove((Object)portId);
            }
        });
        vmAddressMapJson.put((Object)INTERFACE, (Object)interfaceJson);
        return vmAddressMapJson.toString();
    }

    private Map<String, String> getIpAddressToPortId(List<VMInterface> vmInterfaces) {
        HashMap<String, String> ipAddressToPortId = new HashMap<String, String>();
        vmInterfaces.forEach(vMInterface -> {
            if (!VerifyUtil.isEmpty((Collection)vMInterface.getFixedIps())) {
                String portId = vMInterface.getPortId();
                vMInterface.getFixedIps().stream().filter(fixedIp -> !VerifyUtil.isEmpty((Object)fixedIp)).forEach(fixedIp -> ipAddressToPortId.put(fixedIp.getIpAddress(), portId));
            }
        });
        return ipAddressToPortId;
    }

    private int getPoStartPriority(Set<RecoverySetting> recSettings, String poUuid) {
        int startPriority = 1;
        for (RecoverySetting setting : recSettings) {
            if (!setting.getOwnerId().equals(poUuid) || !"startOrder".equals(setting.getName())) continue;
            try {
                startPriority = Integer.parseInt(setting.getValue());
            }
            catch (Exception e) {
                LOG.error((Object)("Parse startPriority error" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return startPriority;
    }

    public Boolean isPhVmNeedStart(String poId, RecoveryPlan plan) {
        RecoverySetting startSetting = RecoveryUtil.getRecoverySetting((String)plan.getPlanId(), (String)poId, (String)"isStart", (Set)plan.getRecoverySettings());
        if (!VerifyUtil.isEmpty((Object)startSetting)) {
            return Boolean.valueOf(startSetting.getValue());
        }
        return true;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

