/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenStackReattachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackReattachPortProcessor.class);
    private Map<String, PhVmInfo> vmUuid2PhVmInfoMap;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.debug((Object)"No ports need to reattach", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList recoveryProcessors = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(recoveryProcessors);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        List detachPortSubProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()), OpenStackDetachPortSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)detachPortSubProcessors)) {
            LOG.info((Object)"End execute generateSubProcessors, cause detachPortSubProcessors is empty.");
            return;
        }
        HashSet<BaseRecoveryProcessor> subProcessors = new HashSet<BaseRecoveryProcessor>();
        Map<String, List<RecoveryProcessor>> recoveryProcessorMap = detachPortSubProcessors.stream().collect(Collectors.groupingBy(processor -> this.isCshaPhvmDetachPortProcessor((RecoveryProcessor)processor).toString()));
        BaseRecoveryProcessor headProcessor = null;
        List recoveryProcessorsOfVm = recoveryProcessorMap.getOrDefault(Boolean.FALSE.toString(), Collections.emptyList());
        for (RecoveryProcessor recoveryProcessor : recoveryProcessorsOfVm) {
            BaseRecoveryProcessor clearPortSubProcessor = this.buildPortHandleSubProcessor(recoveryProcessor, true);
            headProcessor = this.setProcessorOrder(headProcessor, clearPortSubProcessor);
            this.initProc((RecoveryProcessor)clearPortSubProcessor);
            subProcessors.add(clearPortSubProcessor);
        }
        List recoveryProcessorsOfPhVm = recoveryProcessorMap.getOrDefault(Boolean.TRUE.toString(), Collections.emptyList());
        this.mappingVmUuid2PhVmInfo();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessorsOfPhVm) {
            BaseRecoveryProcessor attachPortSubProcessor = this.buildPortHandleSubProcessor(recoveryProcessor, false);
            headProcessor = this.setProcessorOrder(headProcessor, attachPortSubProcessor);
            this.initProc((RecoveryProcessor)attachPortSubProcessor);
            subProcessors.add(attachPortSubProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private BaseRecoveryProcessor buildPortHandleSubProcessor(RecoveryProcessor recoveryProcessor, boolean isClearPort) {
        if (!(recoveryProcessor instanceof OpenStackDetachPortSubProcessor)) {
            LOG.error((Object)"End execute buildPortHandleSubProcessor, cause processor %s not OpenStackDetachPortSubProcessor.", new Object[]{recoveryProcessor.getProcName()});
            throw new LegoCheckedException(1073947393L);
        }
        OpenStackDetachPortSubProcessor detachPortProc = (OpenStackDetachPortSubProcessor)recoveryProcessor;
        String regionUuid = detachPortProc.getString("regionUuid");
        String projectUuid = detachPortProc.getString("projUuid");
        String vmUuid = detachPortProc.getString("vmUuid");
        String portIdsOfVM = detachPortProc.getString("portIdsOfVM");
        String vmName = detachPortProc.getString("vmName");
        if (isClearPort) {
            return new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdsOfVM, vmName, vmUuid);
        }
        return this.buildAttachPortSubProcessor(regionUuid, projectUuid, portIdsOfVM, vmName, vmUuid);
    }

    private BaseRecoveryProcessor setProcessorOrder(BaseRecoveryProcessor headProcessor, BaseRecoveryProcessor currentProcessor) {
        if (headProcessor != null) {
            headProcessor.setNextProcessor((RecoveryProcessor)currentProcessor);
        }
        currentProcessor.setPreviousProcessor((RecoveryProcessor)headProcessor);
        currentProcessor.setNextProcessor(null);
        headProcessor = currentProcessor;
        return headProcessor;
    }

    private Boolean isCshaPhvmDetachPortProcessor(RecoveryProcessor recoveryProcessor) {
        if (!(recoveryProcessor instanceof OpenStackDetachPortSubProcessor)) {
            LOG.error((Object)"End execute buildBaseRecoveryProcessor, cause processor %s not OpenStackDetachPortSubProcessor.", new Object[]{recoveryProcessor.getProcName()});
            throw new LegoCheckedException(1073947393L);
        }
        OpenStackDetachPortSubProcessor detachPortProc = (OpenStackDetachPortSubProcessor)recoveryProcessor;
        Boolean isCshaPhvm = detachPortProc.getBoolean("isCshaPhvm");
        return isCshaPhvm != null && isCshaPhvm != false;
    }

    private OpenStackAttachPortSubProcessor buildAttachPortSubProcessor(String regionUuid, String projectUuid, String portIdsOfVM, String vmName, String vmUuid) {
        PhVmInfo phVmInfo = this.vmUuid2PhVmInfoMap.get(vmUuid);
        if (VerifyUtil.isEmpty((Object)phVmInfo)) {
            LOG.error((Object)"The vm %s has no placehold vm, can't attach port.", new Object[]{vmName});
            throw new LegoCheckedException(1073947393L);
        }
        return new OpenStackAttachPortSubProcessor(regionUuid, projectUuid, portIdsOfVM, phVmInfo.getName(), phVmInfo.getVmUuid());
    }

    private void mappingVmUuid2PhVmInfo() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        boolean isCshaCsdrWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        this.vmUuid2PhVmInfoMap = new HashMap<String, PhVmInfo>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            String replicaStr = (String)po.getProps().get("replicationInfo");
            if (isCshaCsdrWithinRegionRecovery) {
                replicaStr = po.getProperty("hypermetor_replicationInfo");
            }
            if ((replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class)) == null) {
                LOG.error((Object)"Convert PoReplicaInfo return null, replicaStr=%s", new Object[]{replicaStr});
                throw new LegoCheckedException(0x300001L);
            }
            this.vmUuid2PhVmInfoMap.put(po.getMoUuid(), replicaInfo.getPhVmInfo());
        }
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

