/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackRefreshHostProcessor
extends BaseRecoveryProcessor {
    private static final Log LOG = LogFactory.getInstance(OpenStackRefreshHostProcessor.class);
    private static final long serialVersionUID = -7612068516798013042L;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Step into refreshing protectgroup processor...,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        if (null == pg) {
            LOG.error((Object)"Refresh protectgroup failed, for pg is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", null);
            return false;
        }
        LOG.info((Object)"Step out refreshing protectgroup processor...,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackRefreshHostProcessor.des");
    }
}

