/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.concurrent.TimeUnit;

public class OpenStackReverseStorageRepDirectionProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1972358718194932791L;
    private static final Log LOG = LogFactory.getInstance(OpenStackReverseStorageRepDirectionProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        boolean useDrRes;
        LOG.info((Object)"Enter into OpenStackReverseStorageRepDirectionProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && !this.checkAndStopHyperMetroStatus(pg)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)"Stop hyperMetroStatus failed, pg is %s.", new Object[]{pg.getName()});
            return false;
        }
        if (pg.getTemplate().getType() != 29 && pg.getTemplate().getType() != 25 && !this.checkAndSplitReplicationStatus(pg)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)"Split ReplicationStatus failed, pg is %s.", new Object[]{pg.getName()});
            return false;
        }
        boolean bl = useDrRes = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && 25 == pg.getTemplate().getType();
        if (this.executeSteps(pg, useDrRes)) {
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackReverseStorageRepDirectionProcessor");
        return true;
    }

    private boolean executeSteps(ProtectGroup pg, boolean useDrRes) {
        String drReplicaCgUuid;
        String regionUuid = useDrRes ? (String)pg.getProps().get("drRegionId") : (String)pg.getProps().get("regionId");
        String projUuid = useDrRes ? (String)pg.getProps().get("drProjectId") : (String)pg.getProps().get("projectId");
        String replicaCgUuid = useDrRes ? (String)pg.getProps().get("drReplicaCgUuid") : (String)pg.getProps().get("replicaCgUuid");
        String drRegionUuid = useDrRes ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String drProjUuid = useDrRes ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String string = drReplicaCgUuid = useDrRes ? (String)pg.getProps().get("replicaCgUuid") : (String)pg.getProps().get("drReplicaCgUuid");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
            replicaCgUuid = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProdrCgUuid") : (String)pg.getProps().get("hyperProCgUuid");
            drReplicaCgUuid = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProCgUuid") : (String)pg.getProps().get("hyperProdrCgUuid");
        }
        try {
            DrExtendManager mgr = new DrExtendManager();
            if (this.stepTwo(pg, drRegionUuid, drProjUuid, drReplicaCgUuid)) {
                return true;
            }
            if (this.stepThree(pg, regionUuid, projUuid, replicaCgUuid, useDrRes)) {
                return true;
            }
            if (this.stepFour(pg, regionUuid, projUuid, mgr)) {
                return true;
            }
            if (!this.restartHyperMetro(pg)) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("OpenStackReverseStorageRepDirectionProcessor failed." + e.getErrorCode()));
            this.updateProcessDetail(e);
            return true;
        }
        return false;
    }

    private boolean stepThree(ProtectGroup pg, String regionUuid, String projUuid, String replicaCgUuid, boolean useDrRes) {
        String drReplicaCgUuid;
        String drRegionUuid = useDrRes ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String drProjUuid = useDrRes ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String string = drReplicaCgUuid = useDrRes ? (String)pg.getProps().get("replicaCgUuid") : (String)pg.getProps().get("drReplicaCgUuid");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
            replicaCgUuid = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProdrCgUuid") : (String)pg.getProps().get("hyperProCgUuid");
            drReplicaCgUuid = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? (String)pg.getProps().get("hyperProCgUuid") : (String)pg.getProps().get("hyperProdrCgUuid");
        }
        LOG.debug((Object)"%s: trying to switch master/slave. drReplicaCgUUID=%s", new Object[]{pg.getName(), drReplicaCgUuid});
        boolean switchSlaveResult = this.reverseVolumeReplication(drRegionUuid, drProjUuid, drReplicaCgUuid, true);
        if (!switchSlaveResult) {
            LOG.error((Object)(pg.getName() + ": Slave Switch failed. drReplicaCgUUID=" + drReplicaCgUuid));
            return true;
        }
        if (this.checkSwitchResult(pg, regionUuid, projUuid, replicaCgUuid)) {
            return true;
        }
        LOG.debug((Object)"%s: switch master/slave successfully. drReplicaCgUUID=%s,replicaCgUuid =%s", new Object[]{pg.getName(), drReplicaCgUuid, replicaCgUuid});
        if (34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            String standByDrReplicaCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
            LOG.debug((Object)"%s: trying to switch standby master/slave. standByDrReplicaCgUuid=%s", new Object[]{pg.getName(), standByDrReplicaCgUuid});
            switchSlaveResult = this.reverseVolumeReplication(drRegionUuid, drProjUuid, standByDrReplicaCgUuid, true);
            if (!switchSlaveResult) {
                LOG.error((Object)"%s: Slave Switch failed. standByDrReplicaCgUuid=%s", new Object[]{pg.getName(), standByDrReplicaCgUuid});
                return true;
            }
            String standByReplicaCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
            LOG.debug((Object)"%s: trying to switch standby master/slave. standByReplicaCgUuid=%s", new Object[]{pg.getName(), standByReplicaCgUuid});
            boolean switchMasterResult = this.reverseVolumeReplication(regionUuid, projUuid, standByReplicaCgUuid, false);
            if (this.checkResult(pg, switchMasterResult, standByDrReplicaCgUuid, standByReplicaCgUuid)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkResult(ProtectGroup pg, boolean switchMasterResult, String standByDrReplicaCgUuid, String standByReplicaCgUuid) {
        if (!switchMasterResult) {
            LOG.error((Object)(pg.getName() + ": Master Switch failed. standByReplicaCgUuid=%s"), new Object[]{standByReplicaCgUuid});
            return true;
        }
        LOG.debug((Object)"%s: standBy switch master/slave successfully.standByDrReplicaCgUuid=%s,standByReplicaCgUuid=%s", new Object[]{pg.getName(), standByDrReplicaCgUuid, standByReplicaCgUuid});
        return false;
    }

    private boolean checkSwitchResult(ProtectGroup pg, String regionUuid, String projUuid, String replicaCgUuid) {
        LOG.debug((Object)"%s: trying to switch master/slave. replicaCgUuid=%s", new Object[]{pg.getName(), replicaCgUuid});
        boolean switchMasterResult = this.reverseVolumeReplication(regionUuid, projUuid, replicaCgUuid, false);
        if (!switchMasterResult) {
            LOG.error((Object)(pg.getName() + ": Master Switch failed. replicaCgUuid=" + replicaCgUuid));
            return true;
        }
        return false;
    }

    private boolean stepTwo(ProtectGroup pg, String drRegionUuid, String drProjUuid, String drReplicaCgUuid) {
        if (!this.setHyperMasterSite(pg)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)(pg.getName() + ": set Hyper Master  failed."));
            return true;
        }
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            OpenStackRecoveryTool.updateReplicationCGRecoverStrategyForHyper(pg, drRegionUuid, drProjUuid, drReplicaCgUuid, OpenstackEnumDefine.RecoverStrategy.AUTO);
        }
        return false;
    }

    private boolean stepFour(ProtectGroup pg, String regionUuid, String projUuid, DrExtendManager mgr) {
        if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && !((String)pg.getProps().get("originalAvailableRegion")).equals(regionUuid)) {
            String standRing = (String)pg.getProps().get("prodRingID");
            String replicaCgNormalUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getReplicaCgUuid(pg));
            LOG.debug((Object)"%s: trying to set write-protect of slave. replicaCgUUID=%s", new Object[]{pg.getName(), replicaCgNormalUuid});
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
            AsyncTaskResponse writeProtectResponse = mgr.splitRingVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgNormalUuid, standRing, "ro");
            if (!writeProtectResponse.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)"%s: set write-protect of slave failed,errorCode:%s", new Object[]{pg.getName(), writeProtectResponse.getErrorCode()});
                this.updateProcessDetail("lego.err." + writeProtectResponse.getErrorCode(), null);
                return true;
            }
        }
        return false;
    }

    private boolean setHyperMasterSite(ProtectGroup pg) {
        if (!PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() != this.getProcType() || OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            LOG.info((Object)"%s do not need to set hyper master site", new Object[]{pg.getName()});
            return true;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String replicaCgUuid = (String)pg.getProps().get("replicaCgUuid");
        boolean isActive = OpenStackRecoveryTool.checkReplicationStatus(regionUuid, projectUuid, replicaCgUuid);
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        if (isActive && !isSecondDisasterRecovery) {
            LOG.info((Object)"%s do not need to set hyper master site", new Object[]{pg.getName()});
            return true;
        }
        String hyperReplicaCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        String hyperDrReplicaCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
        LOG.debug((Object)"%s: trying to switch master/slave. drReplicaCgUUID=%s,replicaCgUuid =%s", new Object[]{pg.getName(), hyperDrReplicaCgUuid, hyperReplicaCgUuid});
        boolean switchSlaveResult = this.reverseVolumeReplication(regionUuid, projectUuid, isSecondDisasterRecovery ? hyperReplicaCgUuid : hyperDrReplicaCgUuid, true);
        if (!switchSlaveResult) {
            LOG.error((Object)(pg.getName() + ": Slave Switch failed. drReplicaCgUUID=" + hyperDrReplicaCgUuid));
            this.updateProcessDetail("lego.err.1073948756", new String[]{hyperDrReplicaCgUuid});
            return false;
        }
        boolean switchMasterResult = this.reverseVolumeReplication(regionUuid, projectUuid, isSecondDisasterRecovery ? hyperDrReplicaCgUuid : hyperReplicaCgUuid, false);
        if (!switchMasterResult) {
            LOG.error((Object)(pg.getName() + ": Master Switch failed. replicaCgUuid=" + hyperReplicaCgUuid));
            this.updateProcessDetail("lego.err.1073948756", new String[]{hyperReplicaCgUuid});
            return false;
        }
        LOG.debug((Object)"%s: switch master/slave successfully. drReplicaCgUUID=%s,replicaCgUuid =%s", new Object[]{pg.getName(), hyperDrReplicaCgUuid, hyperReplicaCgUuid});
        pg.getProps().remove("IsSecondDisasterRecovery");
        return true;
    }

    private boolean checkAndStopHyperMetroStatus(ProtectGroup pg) {
        if (OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            return true;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String hyperMetroCgid = OpenStackRecoveryTool.getHyperProCgUuid(pg);
        this.resetStragegy(pg, regionUuid, projUuid, hyperMetroCgid);
        DrExtendManager drExtendMgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperMetroCgid, new int[0]);
        if (null == cgInfo) {
            LOG.error((Object)(pg.getName() + ": hyperMetroCg not found"));
            return false;
        }
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
            LOG.error((Object)(pg.getName() + ": replica's status is not avaiable."));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948223", null);
            return false;
        }
        if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(cgInfo.getReplicationStatus()) && !OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(cgInfo.getReplicationStatus())) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)"%s: OpenStackReverseStorageRepDirectionProcessor failed.HyperMetro replication status is %s", new Object[]{pg.getName(), cgInfo.getReplicationStatus()});
            this.updateProcessDetail("lego.err.1073948223", null);
            return false;
        }
        hyperMetroCgid = OpenStackCommonUtil.getIdFromUuid(hyperMetroCgid);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperMetroCgid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.info((Object)"%s: set volRepCg(%s) split failed: errorcode is %s", new Object[]{pg.getName(), hyperMetroCgid, response.getErrorCode()});
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)(pg.getName() + ": volRepCg(" + hyperMetroCgid + ") fault switch failed."), (Throwable)e);
            return false;
        }
        return true;
    }

    private void resetStragegy(ProtectGroup pg, String regionUuid, String projUuid, String hyperMetroCgid) {
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        if (isSecondDisasterRecovery) {
            OpenStackRecoveryTool.updateReplicationCGRecoverStrategy(regionUuid, projUuid, hyperMetroCgid, OpenstackEnumDefine.RecoverStrategy.AUTO);
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private boolean restartHyperMetro(ProtectGroup pg) {
        String drReplicaCgUuid;
        if (34 != pg.getTemplate().getType() && !PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            return true;
        }
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            return true;
        }
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        AsyncTaskResponse response = mgr.syncVolumeReplicationCG(regionUuid, tokenId, projUuid, drReplicaCgUuid = (String)pg.getProps().get("hyperProdrCgUuid"));
        if (!response.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948904", null);
            LOG.info((Object)"%s: Failed to startup the HyperMetro: errorcode is %s", new Object[]{pg.getName(), response.getErrorCode()});
            return false;
        }
        return true;
    }

    protected boolean reverseVolumeReplication(String regionUuid, String projUuid, String replicaCgUuid, boolean isMaster) {
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        DrExtendManager mgr = new DrExtendManager();
        LOG.debug((Object)"Trying to switch master/slave. drReplicaCgUUID=%s", new Object[]{replicaCgUuid});
        try {
            AsyncTaskResponse switchResponse = mgr.reverseVolumeReplicationCG(isMaster, replicaCgUuid, regionUuid, tokenId, projUuid);
            if (!switchResponse.isSuccess()) {
                LOG.error((Object)("Master/Slave Switch failed." + switchResponse.getErrorCode()));
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err." + switchResponse.getErrorCode(), null);
                return false;
            }
            LOG.info((Object)"3DC ring standby switch master/slave successfully. drReplicaCgUUID=%s", new Object[]{replicaCgUuid});
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return true;
    }

    private boolean checkAndSplitReplicationStatus(ProtectGroup pg) {
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            return true;
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getDrReplicaCgUuid(pg));
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        String originalRegionUuid = (String)pg.getProps().get("originalAvailableRegion");
        String regionUuid = (String)pg.getProps().get("regionId");
        DrExtendManager drExtendMgr = new DrExtendManager();
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid);
        if (null == cgInfo) {
            LOG.error((Object)(pg.getName() + " : hyperMetroCg not found"));
            return false;
        }
        String status = cgInfo.getStatus();
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
            LOG.error((Object)(pg.getName() + "replica's status is not avaiable."));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!OpenstackEnumDefine.ReplicationRepStatusE.INACTIVE.getValue().equals(cgInfo.getReplicationStatus()) && !OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(cgInfo.getReplicationStatus())) {
            AsyncTaskResponse response;
            if ((34 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) && regionUuid.equals(originalRegionUuid)) {
                String standRing = (String)pg.getProps().get("standbyDRRingUuid");
                response = drExtendMgr.splitRingVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid, standRing, "rw");
            } else {
                response = drExtendMgr.splitVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, drReplicaCgUuid);
            }
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948904", null);
                LOG.error((Object)"%s set volRepCg(%s) writable failed: error code is %s", new Object[]{pg.getName(), drReplicaCgUuid, response.getErrorCode()});
                return false;
            }
        }
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorStorageRelationProcessor.des");
    }
}

