/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class OpenStackShutDownVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2755817713196505946L;
    private static final Log LOG = LogFactory.getInstance(OpenStackShutDownVmSubProcessor.class);
    private static final Set<String> VM_TASK_STATUS = new HashSet<String>();
    private static final Set<Integer> VM_STATUS_CONTAIN_TASK_STATUS = new HashSet<Integer>();
    private static final Set<Integer> VM_STATUS_NOT_CONTAIN_TASK_STATUS = new HashSet<Integer>();

    public OpenStackShutDownVmSubProcessor() {
    }

    public OpenStackShutDownVmSubProcessor(String vmUuid, String vmName, String projUuid, String regionUuid) {
        this.addString("vmUuid", vmUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("vmName", vmName);
    }

    public void updateProcNameParams() {
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        AsyncTaskResponse response;
        LOG.info((Object)"Enter into OpenStackShutDownVmSubProcessor");
        String vmUuid = this.getString("vmUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        ProtectGroup pg = context.getProtectGroup();
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            if (PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("_ha_policy_type", "close");
                novaMgr.updateVMmetadata(vmUuid, projUuid, regionUuid, tokenId, metadata);
            }
            return this.shutdownVmWithoutCheck(vmUuid, regionUuid, projUuid);
        }
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        if (null == vm) {
            LOG.error((Object)("Can not get vm(" + vmName + ") info:" + vmUuid));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.2117645", null);
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && vm.getLocked().booleanValue() && !(response = novaMgr.unlockVm(regionUuid, tokenId, projUuid, vmUuid)).isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Unlock vm(" + vmUuid + ") failed" + response.getErrorCode()));
            this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg) && !this.dealVMPowerOff(regionUuid, projUuid, vmUuid, vm)) {
            LOG.error((Object)("Check VM status time out or reset vm fialed, (" + vmUuid + ")" + vmUuid));
            return false;
        }
        this.updateMetadata(vmUuid, regionUuid, projUuid, pg, novaMgr, tokenId);
        return this.shutdownVm(vmUuid, regionUuid, projUuid, pg);
    }

    private void updateMetadata(String vmUuid, String regionUuid, String projUuid, ProtectGroup pg, NovaManager novaMgr, String tokenId) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("_ha_policy_type", "close");
            novaMgr.updateVMmetadata(vmUuid, projUuid, regionUuid, tokenId, metadata);
        }
    }

    private boolean shutdownVmWithoutCheck(String vmUuid, String regionUuid, String projUuid) {
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            AsyncTaskResponse response = novaMgr.vmActionWithoutCheck(vmUuid, projUuid, regionUuid, tokenId, OpenStackVMActionEnum.HARD_STOP);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Shutdown vm(" + vmUuid + ") failed" + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Shutdown vm() failed, vm uuid is " + vmUuid), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackShutDownVmSubProcessor");
        return true;
    }

    private boolean shutdownVm(String vmUuid, String regionUuid, String projUuid, ProtectGroup pg) {
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        try {
            if (this.checkVmStatus(vm)) {
                return true;
            }
            boolean isXenHost = false;
            if (!PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) {
                HypervisorInfo hypervisorInfo = ServiceInstanceHelper.getInstance().getHypervisorInfoByVm(regionUuid, projUuid, vm);
                isXenHost = !VerifyUtil.isEmpty((Object)hypervisorInfo) && "FusionCompute".equals(hypervisorInfo.getHypervisorType());
            }
            AsyncTaskResponse response = null;
            if (FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.5.1") && DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && this.checkVMIsHardReboot(vm) && !isXenHost) {
                LOG.debug((Object)"Vm( %s ) status is hard_reboot and need to use shutdown command with nova v1 version. vm status is %s, vm taskStauts is %s ", new Object[]{vm.getName(), vm.getStatus(), vm.getVmTaskState()});
                response = novaMgr.vmAction(vmUuid, projUuid, regionUuid, tokenId, OpenStackVMActionEnum.HARD_STOP_IGNORE_CHECK);
            } else {
                OpenStackVMActionEnum action = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? OpenStackVMActionEnum.HARD_STOP : OpenStackVMActionEnum.STOP;
                response = novaMgr.vmAction(vmUuid, projUuid, regionUuid, tokenId, action);
            }
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Shutdown vm(" + vmUuid + ") failed" + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)("Shutdown vm() failed, vm uuid is " + vmUuid), (Throwable)e);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackShutDownVmSubProcessor");
        return true;
    }

    private boolean checkVmStatus(OpenStackVM vm) {
        if (null == vm) {
            LOG.error((Object)"Get Vm Error.");
            throw new LegoCheckedException(1073947393L);
        }
        if (OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() == vm.getStatus().intValue() || OpenstackEnumDefine.VmStatusE.STOPPED.getValue() == vm.getStatus().intValue()) {
            LOG.info((Object)"Vm(%s) is aready shutted down.", new Object[]{vm.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        return false;
    }

    private boolean dealVMPowerOff(String regionUuid, String projUuid, String vmUuid, OpenStackVM vm) {
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        if (OpenstackEnumDefine.VmStatusE.VmTaskStatusE.POWERING_OFF.getValue().equals(vm.getVmTaskState())) {
            if (OpenstackEnumDefine.VmStatusE.ERROR.getValue() == vm.getStatus().intValue() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
                LOG.info((Object)"Vm(%s) task is powering-off, status is error, vmUuid is :%s.", new Object[]{vm.getName(), vm.getUuid()});
                return true;
            }
            LOG.info((Object)"Vm(%s) task is powering-off , vmUuid is :%s.", new Object[]{vm.getName(), vm.getUuid()});
            if (!this.checkVmPoweringOff(regionUuid, tokenId, projUuid, vmUuid, novaMgr)) {
                LOG.error((Object)("Wait vm(" + vm.getName() + ") powering-off task time out"));
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073947433", new String[0]);
                return false;
            }
            LOG.debug((Object)"Wait vm(%s) powering-off task succes", new Object[]{vm.getName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (null == vm.getVmTaskState() && (OpenstackEnumDefine.VmStatusE.ACTIVE.getValue() == vm.getStatus().intValue() || OpenstackEnumDefine.VmStatusE.STOPPED.getValue() == vm.getStatus().intValue() || OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() == vm.getStatus().intValue() || OpenstackEnumDefine.VmStatusE.ERROR.getValue() == vm.getStatus().intValue())) {
            LOG.debug((Object)"Vm(%s) status is %s", new Object[]{vm.getName(), vm.getStatus()});
            return true;
        }
        if (FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.5.1") && this.checkVMIsHardReboot(vm)) {
            LOG.debug((Object)"Vm( %s ) status is hard_reboot and need to use shutdown command with nova v1 version. vm status is %s, vm taskStauts is %s.", new Object[]{vm.getName(), vm.getStatus(), vm.getVmTaskState()});
            return true;
        }
        LOG.info((Object)"Will reset vm status , vm(%s) status is %s , vm taskState is :%s.", new Object[]{vm.getUuid(), vm.getStatus(), vm.getVmTaskState()});
        AsyncTaskResponse response = novaMgr.resetVMState(vmUuid, projUuid, regionUuid, tokenId, OpenstackEnumDefine.VmStatusE.ACTIVE);
        if (response.isSuccess()) {
            return true;
        }
        LOG.error((Object)("Reset vm(" + vm.getName() + ") status failed"));
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
        return false;
    }

    private boolean checkVmPoweringOff(String regionUuid, String tokenId, String projUuid, String vmUuid, INovaManager novaMgr) {
        int waitTime = 600000;
        for (int startTime = 0; startTime <= waitTime; startTime += 10000) {
            CommUtil.pauseThread((long)10000L);
            OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (null == vm) {
                return false;
            }
            if (null != vm.getVmTaskState() || OpenstackEnumDefine.VmStatusE.SHUTOFF.getValue() != vm.getStatus().intValue() && OpenstackEnumDefine.VmStatusE.STOPPED.getValue() != vm.getStatus().intValue() && OpenstackEnumDefine.VmStatusE.ERROR.getValue() != vm.getStatus().intValue()) continue;
            return true;
        }
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean checkVMIsHardReboot(OpenStackVM vm) {
        boolean vmTaskStatusIsReboot = VM_TASK_STATUS.contains(vm.getVmTaskState());
        boolean vmStatusIsReboot = VM_STATUS_CONTAIN_TASK_STATUS.contains(vm.getStatus());
        return vmTaskStatusIsReboot && vmStatusIsReboot || null == vm.getVmTaskState() && VM_STATUS_NOT_CONTAIN_TASK_STATUS.contains(vm.getStatus());
    }

    static {
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.REBOOT_PENDING_HARD.getValue());
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.REBOOTING_HARD.getValue());
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.REBOOT_STARTED_HARD.getValue());
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.RE_BUILDING.getValue());
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.REBUILD_BLOCK_DEVICE_MAPPING.getValue());
        VM_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.VmTaskStatusE.REBUILD_SPAWNING.getValue());
        VM_STATUS_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.ACTIVE.getValue());
        VM_STATUS_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.HARD_REBOOT.getValue());
        VM_STATUS_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.ERROR.getValue());
        VM_STATUS_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.REBUILD.getValue());
        VM_STATUS_NOT_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.ERROR.getValue());
        VM_STATUS_NOT_CONTAIN_TASK_STATUS.add(OpenstackEnumDefine.VmStatusE.ACTIVE.getValue());
    }
}

