/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.cshacsdr.OpenStackSwitchHyperPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class OpenStackSwitchHyperPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSwitchHyperPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.debug((Object)"Enter into OpenStackSwitchHyperPortProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            LOG.error((Object)"Openstack region is not exist.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return false;
        }
        if (!((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork()) {
            LOG.info((Object)"Region config:isSwitchNetwork is false,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessorsForCsdrCshaRecovery(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            LOG.debug((Object)"No ports need to detach,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)true);
        if (null == recoveryTemplate) {
            LOG.info((Object)"RecoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessorsForCsdrCshaRecovery(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, regionUuid, tokenId, projectUuid);
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        HashSet<OpenStackSwitchHyperPortSubProcessor> subProcSet = new HashSet<OpenStackSwitchHyperPortSubProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            String vmUuid = po.getMoUuid();
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVM");
            List<VMInterface> vmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
            List<VMInterface> phVmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, phVmUuid);
            if (VerifyUtil.isEmpty(vmPortList) && VerifyUtil.isEmpty(phVmPortList)) {
                LOG.warn((Object)"The vm and phVm has no port, vmUuid=%s, phVmUuid:%s.", new Object[]{vmUuid, phVmUuid});
                continue;
            }
            String portIdStr = OpenStackRecoveryTool.getSortedPortIdStr(vmPortList, portList);
            String phVmPortIdStr = OpenStackRecoveryTool.getSortedPortIdStr(phVmPortList, portList);
            if (VerifyUtil.isEmpty((String)portIdStr) && VerifyUtil.isEmpty((String)phVmPortIdStr)) {
                LOG.warn((Object)"The vm and phVm has no valid portId, vmUuid=%s, phVmUuid:%s.", new Object[]{vmUuid, phVmUuid});
                continue;
            }
            if (isSecondDisasterRecovery) continue;
            OpenStackSwitchHyperPortSubProcessor openStackSwitchHyperPortSubProcessor = new OpenStackSwitchHyperPortSubProcessor(regionUuid, projectUuid, (Pair<String, String>)Pair.of((Object)portIdStr, (Object)phVmPortIdStr), po, context);
            this.initProc((RecoveryProcessor)openStackSwitchHyperPortSubProcessor);
            subProcSet.add(openStackSwitchHyperPortSubProcessor);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

