/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class OpenStackSwitchHyperPortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5660380256054152752L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSwitchHyperPortSubProcessor.class);

    public OpenStackSwitchHyperPortSubProcessor() {
    }

    public OpenStackSwitchHyperPortSubProcessor(String regionUuid, String projectUuid, Pair<String, String> portIdPair, ProtectObject po, RecoveryProcessorContext context) {
        String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVM");
        String phVmName = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVMNAME");
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("portIdsOfVM", (String)portIdPair.getLeft());
        this.addString("portIdsOfPhVm", (String)portIdPair.getRight());
        this.addString("vmName", po.getName());
        this.addString("vmUuid", po.getMoUuid());
        this.addString("CSHAPLACEHOLDVMNAME", phVmName);
        this.addString("CSHAPLACEHOLDVM", phVmUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        LOG.info((Object)"Enter into OpenStackSwitchHyperPortSubProcessor");
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            LOG.info((Object)"RecoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        HashSet<RecoveryProcessor> subProcSet = new HashSet<RecoveryProcessor>();
        String portIdStr = this.getString("portIdsOfVM");
        String vmUuid = this.getString("vmUuid");
        String vmName = this.getString("vmName");
        OpenStackDetachPortSubProcessor vmDetachSubProc = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
        this.initAndAddProc(vmDetachSubProc, subProcSet);
        OpenStackClearPortSubProcessor vmClearPortsubProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
        this.initAndAddProc(vmClearPortsubProcessor, subProcSet);
        String portIdStrOfPhVm = this.getString("portIdsOfPhVm");
        String phVmUuid = this.getString("CSHAPLACEHOLDVM");
        String phVmName = this.getString("CSHAPLACEHOLDVMNAME");
        OpenStackDetachPortSubProcessor phVmDetachSubProc = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStrOfPhVm, phVmName, phVmUuid);
        this.initAndAddProc(phVmDetachSubProc, subProcSet);
        OpenStackClearPortSubProcessor phVmClearPortSubProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdStrOfPhVm, phVmName, phVmUuid);
        this.initAndAddProc(phVmClearPortSubProcessor, subProcSet);
        OpenStackAttachPortSubProcessor phVmAttachSubProc = new OpenStackAttachPortSubProcessor(regionUuid, projectUuid, portIdStr, phVmName, phVmUuid);
        this.initAndAddProc(phVmAttachSubProc, subProcSet);
        OpenStackAttachPortSubProcessor vmAttachSubProc = new OpenStackAttachPortSubProcessor(regionUuid, projectUuid, portIdStrOfPhVm, vmName, vmUuid);
        this.initAndAddProc(vmAttachSubProc, subProcSet);
        vmDetachSubProc.setPreviousProcessor(null);
        this.setProcessorOrder(vmDetachSubProc, vmClearPortsubProcessor);
        this.setProcessorOrder(vmClearPortsubProcessor, phVmDetachSubProc);
        this.setProcessorOrder(phVmDetachSubProc, phVmClearPortSubProcessor);
        this.setProcessorOrder(phVmClearPortSubProcessor, phVmAttachSubProc);
        this.setProcessorOrder(phVmAttachSubProc, vmAttachSubProc);
        vmAttachSubProc.setNextProcessor(null);
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initAndAddProc(BaseRecoveryProcessor recoveryProcessor, Set<RecoveryProcessor> subProcSet) {
        this.initProc((RecoveryProcessor)recoveryProcessor);
        subProcSet.add((RecoveryProcessor)recoveryProcessor);
    }

    private void setProcessorOrder(BaseRecoveryProcessor first, BaseRecoveryProcessor second) {
        first.setNextProcessor((RecoveryProcessor)second);
        second.setPreviousProcessor((RecoveryProcessor)first);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }
}

