/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OpenStackSfsBeginProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4670800803315248604L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsBeginProcessor.class);
    private static final Map<Integer, String> PROC_NAME_MAP = OpenStackSfsBeginProcessor.createProcNameMap();

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (VerifyUtil.isEmpty((Object)recoveryPlan) || VerifyUtil.isEmpty((Object)context.getProtectGroup()) || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            LOG.error((Object)"Failed to execute openStack beginProcessor, because recoveryPlan is null or do not have protectGroup.");
            throw new LegoCheckedException(1073947393L);
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        if (protectGroups.stream().anyMatch(protectGroup -> protectGroup.getPoType() != 17 || VerifyUtil.isEmpty((Collection)protectGroup.getPolist()))) {
            LOG.error((Object)"Failed to execute openStack beginProcessor, because the protected group list contains non-SFS protected objects or poList is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        if (PROC_NAME_MAP.containsKey(this.getProcType())) {
            return PROC_NAME_MAP.get(this.getProcType());
        }
        return "ism.drm.recovery.prepare.process.name";
    }

    private static Map<Integer, String> createProcNameMap() {
        HashMap<Integer, String> procNameMap = new HashMap<Integer, String>();
        procNameMap.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue(), "ism.drm.clean.prepare.process.name");
        procNameMap.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), "ism.drm.testing.prepare.process.name");
        procNameMap.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue(), "ism.drm.planedmotion.prepare.process.name");
        procNameMap.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue(), "ism.drm.reprotect.prepare.process.name");
        procNameMap.put(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue(), "ism.drm.recovery.prepare.process.name");
        return Collections.unmodifiableMap(procNameMap);
    }
}

