/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackSfsRefactorNasProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6784081267028958378L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsRefactorNasProcessor.class);
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();

    protected boolean execute(RecoveryProcessorContext context) {
        boolean execuateResult = true;
        ProtectGroup protectGroup = context.getProtectGroup();
        LOG.info((Object)"Enter into OpenStackSfsRefactorNasProcessor,recoveryPlan name=%s, procType=%s.", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(context.getRecoveryPlan()), this.getProcType()});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() || this.isPlanedMotionExecuteType()) {
            String shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
            boolean switchResult = this.switchoverHypermetroDomain(protectGroup, "drProjectId", "drRegionId", shareTypeName, OpenstackEnumDefine.HypermetroDomainRole.PRIMARY.getValue());
            if (!switchResult) {
                LOG.error((Object)"Switch(%s) to active failed.", new Object[]{shareTypeName});
                return false;
            }
            shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "pd_share");
            execuateResult = this.switchoverHypermetroDomain(protectGroup, "projectId", "regionId", shareTypeName, OpenstackEnumDefine.HypermetroDomainRole.SECONDARY.getValue());
        }
        if (this.isPlanedMotionExecuteType()) {
            UrlBaseParams urlBaseParams = this.getUrlBaseParams(protectGroup, "drProjectId", "drRegionId");
            String shareTypeName = OpenStackCommonUtil.getShareTypeNameFromProtectObject(context, "dr_share");
            sfsFilemeterManager.addProtection(urlBaseParams, shareTypeName);
        }
        return execuateResult;
    }

    private boolean isPlanedMotionExecuteType() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType();
    }

    private UrlBaseParams getUrlBaseParams(ProtectGroup protectGroup, String projectKey, String regionIdKey) {
        String drProjUuid = protectGroup.getProperty(projectKey);
        String drRegionUuid = protectGroup.getProperty(regionIdKey);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        return new UrlBaseParams(drProjUuid, drRegionUuid, drTokenId);
    }

    private boolean switchoverHypermetroDomain(ProtectGroup protectGroup, String projectKey, String regionIdKey, String shareTypeName, String targetRole) {
        UrlBaseParams urlBaseParams = this.getUrlBaseParams(protectGroup, projectKey, regionIdKey);
        HypermetroDomain hypermetroDomain = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
        if (targetRole.equals(hypermetroDomain.getConfigRole())) {
            LOG.error((Object)"HypermetroDomain(%s) role is %s, no switchover is required.", new Object[]{shareTypeName, targetRole});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        sfsFilemeterManager.activeStandbySwitchover(urlBaseParams, shareTypeName);
        AsyncTaskResponse asyncTaskResponse = AsyncTaskResponse.queryTaskResponse(shareTypeName, response -> {
            HypermetroDomain hypermetro = sfsFilemeterManager.queryHypermetroDomain(urlBaseParams, shareTypeName);
            if (hypermetro == null) {
                LOG.error((Object)"The hypermetroDomain %s is not exist.", new Object[]{shareTypeName});
                return false;
            }
            if (targetRole.equals(hypermetro.getConfigRole())) {
                response.setSuccess(true);
                return true;
            }
            LOG.error((Object)"Expected hypermetroDomain role of %s is %s, but actual role is %s.", new Object[]{shareTypeName, targetRole, hypermetroDomain.getConfigRole()});
            return false;
        });
        if (asyncTaskResponse.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        LOG.error((Object)"Switchover hypermetroDomain(%s) role to %s failed.", new Object[]{shareTypeName, targetRole});
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() ? "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorNasProcessor.planedMotion" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorNasProcessor.reprotected" : "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorNasProcessor.disasterRecovery");
        return processName;
    }
}

