/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.openstack.sdk.bo.InterfaceSetBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OpenStackChsaInterfaceService {
    private static final Log LOG = LogFactory.getInstance(OpenStackChsaInterfaceService.class);
    private static final OpenStackChsaInterfaceService INSTANCE = new OpenStackChsaInterfaceService();

    private OpenStackChsaInterfaceService() {
    }

    public static OpenStackChsaInterfaceService getInstance() {
        return INSTANCE;
    }

    public List<InterfaceSetBO> updateInterfaceSet(List<InterfaceSetBO> vmInterfacesSets, List<VMInterface> vmInterfaces, String regionId) {
        if (VerifyUtil.isEmpty(vmInterfaces)) {
            return vmInterfacesSets;
        }
        Optional<Boolean> isSwitchNetwork = this.isSwitchNetWork(regionId);
        if (!isSwitchNetwork.isPresent()) {
            LOG.warn((Object)"Failed to update interface set, cause region config not find.");
            return vmInterfacesSets;
        }
        HashMap<String, InterfaceSetBO> portId2InterfaceSetMap = VerifyUtil.isEmpty(vmInterfacesSets) ? new HashMap<String, InterfaceSetBO>() : vmInterfacesSets.stream().collect(Collectors.toMap(InterfaceSetBO::getPortId, Function.identity()));
        for (VMInterface vmInterface : vmInterfaces) {
            InterfaceSetBO vmInterfacesSet = portId2InterfaceSetMap.computeIfAbsent(vmInterface.getPortId(), key -> this.buildDefaultInterfaceSetBO(vmInterface.getPortId()));
            if (!isSwitchNetwork.get().booleanValue()) continue;
            vmInterfacesSet.setRecoveryInterface("forbidden");
        }
        return new ArrayList<InterfaceSetBO>(portId2InterfaceSetMap.values());
    }

    private InterfaceSetBO buildDefaultInterfaceSetBO(String portId) {
        InterfaceSetBO vmInterfacesSet = new InterfaceSetBO();
        vmInterfacesSet.setPortId(portId);
        vmInterfacesSet.setTestInterface(Boolean.TRUE.toString());
        vmInterfacesSet.setRecoveryInterface(Boolean.TRUE.toString());
        return vmInterfacesSet;
    }

    private Optional<Boolean> isSwitchNetWork(String regionId) {
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionId);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            LOG.error((Object)"Openstack region is not exist.");
            return Optional.empty();
        }
        return Optional.of(((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork());
    }
}

