/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.openstack.adapter.manager.impl.NeutronManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPortFixedIp;
import com.huawei.ism.drm.openstack.sdk.msg.CreatePortInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PortIPInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PortInfo;
import com.huawei.ism.drm.openstack.sdk.service.INetWorkService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;

public class NetWorkServiceImpl
implements INetWorkService {
    private static final Log LOG = LogFactory.getInstance(NetWorkServiceImpl.class);
    private static final int MAX_PORT_NAME_LENGTH = 256;

    public OpenStackPort createPort(String openstackUuid, String regionUuid, String projUuid, OpenStackPort port) {
        CreatePortInfo createInfo;
        String tokenId;
        NeutronManager mgr;
        AsyncTaskResponse response;
        this.checkCreatePortParam(openstackUuid, regionUuid, projUuid, port);
        if (VerifyUtil.isEmpty((String)port.getName())) {
            port.setName("test_" + UUIDGenerator.getUUID());
        }
        if (!(response = (mgr = new NeutronManager()).createPort(regionUuid, tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid), projUuid, createInfo = this.getCreateParam(port))).isSuccess()) {
            throw new LegoCheckedException(1073948905L);
        }
        PortInfo info = (PortInfo)response.getTaskResult();
        return new OpenStackPort(openstackUuid, info);
    }

    private void checkCreatePortParam(String openstackUuid, String regionUuid, String projUuid, OpenStackPort port) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projUuid) || null == port) {
            LOG.error((Object)"Param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)port.getNetworkUuid())) {
            LOG.error((Object)"Network is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null != port.getFixedIps() && port.getFixedIps().size() > 1) {
            LOG.error((Object)"Error FixedIps param.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private CreatePortInfo getCreateParam(OpenStackPort port) {
        CreatePortInfo createInfo = new CreatePortInfo();
        createInfo.setName(port.getName().length() > 256 ? port.getName().substring(0, 256) : port.getName());
        createInfo.setNetworkId(OpenStackCommonUtil.getIdFromUuid(port.getNetworkUuid()));
        OpenStackPortFixedIp ipSetting = (OpenStackPortFixedIp)CommonUtil.getFirstElement((Collection)port.getFixedIps());
        if (null != ipSetting) {
            PortIPInfo ip = new PortIPInfo();
            ip.setIpAddress(ipSetting.getIp());
            ip.setSubnetId(OpenStackCommonUtil.getIdFromUuid(ipSetting.getSubnetUuid()));
            ArrayList<PortIPInfo> ips = new ArrayList<PortIPInfo>();
            ips.add(ip);
            createInfo.setFixedIps(ips);
        }
        return createInfo;
    }
}

