/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.arbitration.service.ArbitrationCenterHelper;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.AutoDisasterRecovery;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReProtect;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;

public class CheckArbitrationStatus
extends TimerTask {
    public static final int HA_ARBITRATION_STATUS_NORMAL = 0;
    public static final int HA_ARBITRATION_STATUS_CHECK = 1;
    public static final int HA_ARBITRATION_STATUS_FAILURE = 3;
    public static final String MANAGEMENT_ARBITRATION_REGION_ID_KEY = "config.hcs.node.region";
    private static final Log LOG = LogFactory.getInstance(CheckArbitrationStatus.class);
    private static final String ARB_FILE = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "arb.properties";
    private static final Properties PROPS = new Properties();
    private static final long AUTO_RECOVERY_DELAY_MILLIS = 600000L;
    private final Map<String, Integer> timesForRecoveryMap = new HashMap<String, Integer>();
    private final Map<String, Integer> timesForReprotectMap = new HashMap<String, Integer>();
    private final Map<String, Boolean> shouldDelayMap = new HashMap<String, Boolean>();
    private AutoDisasterRecovery autoDisasterRecovery = null;
    private AutoReProtect autoReProtect = null;

    @Override
    public void run() {
        List<String> isAutoExeRegion = this.getAutoExeRegion();
        this.checkManagementArb();
        for (String regionId : isAutoExeRegion) {
            String arbStatus;
            block8: {
                try {
                    String detail = ArbitrationCenterHelper.getInstance().getDetailStatus(regionId);
                    LOG.debug((Object)"Detail info: %s", new Object[]{detail});
                    JSONObject jsonObject = JSONObject.fromObject((Object)detail);
                    arbStatus = String.valueOf(jsonObject.get("localDcStatus"));
                    boolean cerAuthFlag = Boolean.parseBoolean(String.valueOf(jsonObject.get("cert_auth_flag")));
                    if (cerAuthFlag) {
                        AlarmReporter.restoreAlarm((long)52625462L, (String[])new String[]{this.getAlarmSourceIp() + regionId});
                    } else {
                        LOG.error((Object)"Cert auth failed");
                        AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{this.getAlarmSourceIp(), regionId});
                    }
                    String isMatch = String.valueOf(jsonObject.get("isMatch"));
                    if (!Boolean.parseBoolean(isMatch)) {
                        LOG.error((Object)"The remote info is not match");
                        this.timesForRecoveryMap.put(regionId, 0);
                        this.timesForReprotectMap.put(regionId, 0);
                    }
                    break block8;
                }
                catch (Exception e) {
                    LOG.error((Object)"Check arbStatus error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160784211993L});
                    AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{this.getAlarmSourceIp(), regionId});
                    this.timesForRecoveryMap.put(regionId, 0);
                    this.timesForReprotectMap.put(regionId, 0);
                }
                continue;
            }
            try {
                this.operateRecoveryByArbStatus(regionId, arbStatus);
            }
            catch (Exception e) {
                LOG.error((Object)"Operate Recovery error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public List<String> getAutoExeRegion() {
        ArrayList<String> isAutoExeRegion = new ArrayList<String>();
        try {
            Map<String, Boolean> isAutoExe = this.isAutoExe();
            for (Map.Entry<String, Boolean> isAutoEntry : isAutoExe.entrySet()) {
                if (!isAutoEntry.getValue().booleanValue()) {
                    LOG.debug((Object)"%s auto is false", new Object[]{isAutoEntry.getKey()});
                    this.timesForRecoveryMap.put(isAutoEntry.getKey(), 0);
                    this.timesForReprotectMap.put(isAutoEntry.getKey(), 0);
                    continue;
                }
                isAutoExeRegion.add(isAutoEntry.getKey());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Getting RegionId error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return isAutoExeRegion;
    }

    private void checkManagementArb() {
        if (Boolean.parseBoolean(PROPS.getProperty("arb.enable"))) {
            String regionId = LegoConfig.getNodeConfig().getKeyValue(MANAGEMENT_ARBITRATION_REGION_ID_KEY);
            try {
                String detail = ArbitrationCenterHelper.getInstance().getDetailStatus("");
                JSONObject jsonObject = JSONObject.fromObject((Object)detail);
                boolean cerAuthFlag = Boolean.parseBoolean(String.valueOf(jsonObject.get("cert_auth_flag")));
                if (cerAuthFlag) {
                    AlarmReporter.restoreAlarm((long)52625462L, (String[])new String[]{this.getAlarmSourceIp() + regionId});
                } else {
                    LOG.error((Object)"Failed to verify the management arbitration certificate.");
                    AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{this.getAlarmSourceIp(), regionId});
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Management arbitration verification error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                AlarmReporter.sendNoRepeatAlarm((long)52625462L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{this.getAlarmSourceIp(), regionId});
            }
        }
    }

    private String getAlarmSourceIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Get localHost Address For alarm param failed!");
            return "";
        }
    }

    private int getHaArbitrationStatus() {
        Integer status;
        Path path = Paths.get(PathUtil.getRuntimePath(), "tmp/haArbitrationStatus");
        File file = path.toFile();
        if (!file.exists()) {
            LOG.debug((Object)"Server ha module heartbeat is normal");
            return 0;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("status");
            status = NumberUtil.convertToInteger((Object)value, (int)1);
        }
        catch (IOException e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            status = 1;
        }
        LOG.info((Object)"Server ha module status is %s", new Object[]{String.valueOf(status)});
        return status;
    }

    private Map<String, Boolean> isAutoExe() {
        Map<String, Boolean> checkIsConfigArb = this.checkIsConfigArb();
        ICloudConfigService cloudService = (ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class);
        CloudConfig config = cloudService.getCloudConfigBy("system");
        if (null == config || null == config.getProps()) {
            return checkIsConfigArb;
        }
        for (Map.Entry<String, Boolean> entry : checkIsConfigArb.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String autoRecoveryValue = config.getProps().getOrDefault(entry.getKey() + "_" + "system_autorecovery", "true");
            checkIsConfigArb.put(entry.getKey(), Boolean.parseBoolean(autoRecoveryValue));
        }
        return checkIsConfigArb;
    }

    private Map<String, Boolean> checkIsConfigArb() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (!this.loadProperties()) {
            LOG.error((Object)"Read the arb.enable property of arb.properties file fail.");
            return result;
        }
        List regionIds = ArbProperties.getInstance().getRegions();
        for (String regionId : regionIds) {
            result.put(regionId, Boolean.parseBoolean(PROPS.getProperty(regionId + ".arb.enable")));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadProperties() {
        File file;
        FileInputStream fileInputStream;
        boolean result;
        block13: {
            result = true;
            fileInputStream = null;
            String path = new File("").getCanonicalPath();
            path = path.substring(0, path.length() - (File.separator + "LegoRuntime").length());
            file = new File(path + ARB_FILE);
            if (file.exists()) break block13;
            LOG.error((Object)"Arb.properties file is not exist");
            boolean bl = false;
            if (null == fileInputStream) return bl;
            try {
                fileInputStream.close();
                return bl;
            }
            catch (IOException e2) {
                LOG.error((Object)"Close load arb.properties file fileInputStream failed, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            }
            return bl;
        }
        fileInputStream = new FileInputStream(file);
        PROPS.load(fileInputStream);
        if (null == fileInputStream) return result;
        try {
            fileInputStream.close();
            return result;
        }
        catch (IOException e2) {
            LOG.error((Object)"Close load arb.properties file fileInputStream failed, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
        }
        return result;
        catch (IOException e) {
            try {
                result = false;
                LOG.error((Object)"Load arb.properties file is fail, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                if (null == fileInputStream) return result;
            }
            catch (Throwable throwable) {
                if (null == fileInputStream) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.error((Object)"Close load arb.properties file fileInputStream failed, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
                return result;
            }
            catch (IOException e2) {
                LOG.error((Object)"Close load arb.properties file fileInputStream failed, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            }
            return result;
        }
    }

    private void operateRecoveryByArbStatus(String regionId, String arbStatus) {
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(IServiceInstanceService.class);
        if (OpenstackEnumDefine.ArbStatusE.FAIL_REMOTE.getValue().equalsIgnoreCase(arbStatus) || OpenstackEnumDefine.ArbStatusE.FAIL_LOCAL.getValue().equalsIgnoreCase(arbStatus)) {
            this.timesForReprotectMap.put(regionId, 0);
            this.doRecovery(instService, regionId, arbStatus);
        } else if (OpenstackEnumDefine.ArbStatusE.OK.getValue().equalsIgnoreCase(arbStatus)) {
            LOG.debug((Object)"Begin auto reprotect");
            this.timesForRecoveryMap.put(regionId, 0);
            this.doReprotect(instService, regionId);
        } else {
            this.timesForReprotectMap.put(regionId, 0);
            this.timesForRecoveryMap.put(regionId, 0);
        }
    }

    private void doRecovery(IServiceInstanceService instService, String regionId, String arbStatus) {
        int status = this.getHaArbitrationStatus();
        if (status == 1) {
            LOG.info((Object)"Server is about to switch, waiting for check");
            return;
        }
        if (status == 3) {
            this.timesForRecoveryMap.put(regionId, 0);
            LOG.info((Object)"Server is about to switch, cancel the recovery operation");
            return;
        }
        int timesForRecovery = this.timesForRecoveryMap.getOrDefault(regionId, 0);
        if (++timesForRecovery == 3) {
            this.timesForRecoveryMap.put(regionId, 0);
            this.timesForReprotectMap.put(regionId, 0);
            if (null != this.autoReProtect) {
                this.autoReProtect.cleareSortedQueue();
            }
            Boolean shouldDelay = this.shouldDelayMap.getOrDefault(regionId, false);
            LOG.info((Object)"Start auto recovery, regionId: %s, shouldDelay: %s", new Object[]{regionId, shouldDelay});
            if (shouldDelay.booleanValue()) {
                this.shouldDelayMap.remove(regionId);
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted during auto recovery delay.");
                }
            }
            if (null == this.autoDisasterRecovery) {
                this.autoDisasterRecovery = AutoDisasterRecovery.getInstance();
                this.autoDisasterRecovery.start();
            }
            instService.autoDisaterRecovery(regionId, arbStatus);
        } else {
            this.timesForRecoveryMap.put(regionId, timesForRecovery);
        }
    }

    private void doReprotect(IServiceInstanceService instService, String regionId) {
        int timesForReprotect = this.timesForReprotectMap.getOrDefault(regionId, 0);
        if (++timesForReprotect == 3) {
            this.timesForRecoveryMap.put(regionId, 0);
            this.timesForReprotectMap.put(regionId, 0);
            this.shouldDelayMap.put(regionId, true);
            if (null != this.autoDisasterRecovery) {
                this.autoDisasterRecovery.cleareSortedQueue();
            }
            if (null == this.autoReProtect) {
                this.autoReProtect = AutoReProtect.getInstance();
                this.autoReProtect.start();
            }
            if (null == this.autoDisasterRecovery) {
                this.autoDisasterRecovery = AutoDisasterRecovery.getInstance();
                this.autoDisasterRecovery.start();
            }
            instService.autoReprotect(regionId);
        } else {
            this.timesForReprotectMap.put(regionId, timesForReprotect);
        }
    }
}

