/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ProtectExecutingVmsQueue {
    private static final Log LOG = LogFactory.getInstance(ProtectExecutingVmsQueue.class);
    private static ConcurrentLinkedQueue<String> executingVmsQueue = new ConcurrentLinkedQueue();

    private ProtectExecutingVmsQueue() {
    }

    public static void offer(String vmUuid) {
        if (ProtectExecutingVmsQueue.isContainVm(vmUuid)) {
            LOG.error((Object)"ExecutingVmsQueue has vmUuid: %s", new Object[]{vmUuid});
            return;
        }
        executingVmsQueue.offer(vmUuid);
    }

    public static synchronized boolean isContainVm(String vmUuid) {
        return executingVmsQueue.contains(vmUuid);
    }

    public static void remove(String vmUuid) {
        executingVmsQueue.remove(vmUuid);
    }
}

