/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.google.common.cache.Cache;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.UpdateProtectedVolumeBackTask;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class ConsistanceGroupCheck
implements IServiceInstChecker {
    private static final Log LOG = LogFactory.getInstance(ConsistanceGroupCheck.class);
    private static List<String> normalRepliaStatus = new ArrayList<String>();

    public void check(CheckContext context) {
        this.checkCgId(context);
        this.checkCgStatus(context);
    }

    public void checkCgStatus(CheckContext context) {
        ProtectGroup pg = context.getPg();
        if (34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType()) {
            String replicaStatus = this.queryReplicaStatus(context, null);
            this.checkReplicaStatus(pg, context, replicaStatus, null);
        } else {
            String replicaStatus = this.queryReplicaStatus(context, "activeside");
            boolean replicaStatusResult = this.checkReplicaStatus(pg, context, replicaStatus, "activeside");
            String hyperReplicaStatus = this.queryReplicaStatus(context, "hypermetorside");
            boolean hyperReplicaStatusResult = this.checkReplicaStatus(pg, context, hyperReplicaStatus, "hypermetorside");
            String hyperRemoteReplicaStatus = this.queryReplicaStatus(context, "standbyside");
            boolean hyperRemoteReplicaStatusResult = this.checkReplicaStatus(pg, context, hyperRemoteReplicaStatus, "standbyside");
            if (!(replicaStatusResult && hyperReplicaStatusResult && hyperRemoteReplicaStatusResult)) {
                return;
            }
            this.checkHyperReplkicaStatus(context, pg, hyperReplicaStatus);
            boolean active = this.isActiveSideRepStatusNormal(replicaStatus, hyperRemoteReplicaStatus);
            boolean standby = this.isStandbySideRepStatusNormal(replicaStatus, hyperRemoteReplicaStatus);
            if (active || standby) {
                return;
            }
            context.getCgStatusErrorIds().add(this.getOptCGUuid(pg, "activeside"));
            context.getHyperRemoteStatusErrorIds().add(this.getOptCGUuid(pg, "standbyside"));
        }
    }

    private void checkHyperReplkicaStatus(CheckContext context, ProtectGroup pg, String hyperReplicaStatus) {
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(hyperReplicaStatus) && !OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(hyperReplicaStatus)) {
                context.getHyperCgStatusErrorIds().add(this.getOptCGUuid(pg, "hypermetorside"));
            }
        } else if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(hyperReplicaStatus)) {
            context.getHyperCgStatusErrorIds().add(this.getOptCGUuid(pg, "hypermetorside"));
        }
    }

    private boolean isStandbySideRepStatusNormal(String replicaStatus, String remoteReplicaStatus) {
        return OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus) && (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(remoteReplicaStatus) || OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(remoteReplicaStatus));
    }

    private boolean isActiveSideRepStatusNormal(String replicaStatus, String remoteReplicaStatus) {
        return OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(remoteReplicaStatus) && (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicaStatus) || OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(replicaStatus));
    }

    private boolean checkReplicaStatus(ProtectGroup pg, CheckContext context, String replicaStatus, String side) {
        boolean checkResult = true;
        if (VerifyUtil.isEmpty((String)side)) {
            if (!OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(replicaStatus) && !OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(replicaStatus)) {
                context.getCgStatusErrorIds().add(this.getOptCGUuid(pg, side));
                checkResult = false;
            }
            pg.getProps().put("replicaCgRepStatus", replicaStatus);
        } else if ("activeside".equals(side)) {
            if (!normalRepliaStatus.contains(replicaStatus)) {
                context.getCgStatusErrorIds().add(this.getOptCGUuid(pg, side));
                checkResult = false;
            }
            pg.getProps().put("replicaCgRepStatus", replicaStatus);
        } else if ("hypermetorside".equals(side)) {
            if (!normalRepliaStatus.contains(replicaStatus)) {
                context.getHyperCgStatusErrorIds().add(this.getOptCGUuid(pg, side));
                checkResult = false;
            }
            pg.getProps().put("drHyperReplicaCgRepStatus", replicaStatus);
        } else {
            if (!normalRepliaStatus.contains(replicaStatus)) {
                context.getHyperRemoteStatusErrorIds().add(this.getOptCGUuid(pg, side));
                checkResult = false;
            }
            pg.getProps().put("drRemoteReplicaCgRepStatus", replicaStatus);
        }
        return checkResult;
    }

    private String queryReplicaStatus(CheckContext context, String side) {
        IDrExtendManager drExtendManager;
        VolumeReplicationCgInfo cgInfo;
        String optCGUuid;
        ProtectGroup pg = context.getPg();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        if ("hypermetorside".equals(side) && OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            regionUuid = (String)pg.getProps().get("drRegionId");
            projUuid = (String)pg.getProps().get("drProjectId");
            tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        }
        if (VerifyUtil.isEmpty((String)(optCGUuid = this.getOptCGUuid(pg, side)))) {
            LOG.error((Object)("Pg have no cgUuid: " + pg.getName()));
        }
        if (null == (cgInfo = (drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN())).queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, optCGUuid, new int[0]))) {
            LOG.error((Object)("The VolumeReplicationCgInfo is null: " + optCGUuid));
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
            LOG.error((Object)("The VolumeReplicationCgInfo status error: " + cgInfo.getId() + ", " + cgInfo.getStatus()));
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        return this.queryDRReplicaStatus(cgInfo.getReplicationStatus(), pg, drExtendManager, side);
    }

    private String getOptCGUuid(ProtectGroup pg, String side) {
        if (VerifyUtil.isEmpty((String)side)) {
            return (String)pg.getProps().get("replicaCgUuid");
        }
        if ("activeside".equals(side)) {
            return (String)pg.getProps().get("replicaCgUuid");
        }
        if ("hypermetorside".equals(side)) {
            return (String)pg.getProps().get("hyperProCgUuid");
        }
        return (String)pg.getProps().get("hyperProRemoteCgUuid");
    }

    private String queryDRReplicaStatus(String primaryReplicaStatus, ProtectGroup pg, IDrExtendManager drExtendManager, String side) {
        String drTokenId;
        String drProjUuid;
        String drRegionUuid;
        if (!OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue().equals(primaryReplicaStatus)) {
            return primaryReplicaStatus;
        }
        String optDrCGUuid = this.getOptDrCGUuid(pg, side);
        if (VerifyUtil.isEmpty((String)optDrCGUuid)) {
            LOG.error((Object)("Pg have no drCgUuid: " + pg.getName()));
        }
        if ("hypermetorside".equals(side) && !OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
            drTokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        } else {
            drRegionUuid = (String)pg.getProps().get("drRegionId");
            drProjUuid = (String)pg.getProps().get("drProjectId");
            drTokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        }
        VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(drRegionUuid, drTokenId, drProjUuid, optDrCGUuid, new int[0]);
        if (null == cgInfo) {
            LOG.error((Object)("The VolumeReplicationCgInfo is null: " + optDrCGUuid));
            return OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue();
        }
        return cgInfo.getReplicationStatus();
    }

    private String getOptDrCGUuid(ProtectGroup pg, String side) {
        if (VerifyUtil.isEmpty((String)side)) {
            return (String)pg.getProps().get("drReplicaCgUuid");
        }
        if ("activeside".equals(side)) {
            return (String)pg.getProps().get("drReplicaCgUuid");
        }
        if ("hypermetorside".equals(side)) {
            return (String)pg.getProps().get("hyperProdrCgUuid");
        }
        return (String)pg.getProps().get("hyperProRemotedrCgUuid");
    }

    private void checkCgId(CheckContext context) {
        List replicationInfos;
        ProtectGroup pg = context.getPg();
        int templateType = pg.getTemplate().getType();
        String replicaModel = UpdateProtectedVolumeBackTask.getReplicaModel(templateType);
        if (VerifyUtil.isEmpty((String)replicaModel)) {
            return;
        }
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            LOG.error((Object)("Pg have no cgUuid: " + pg.getName()));
            return;
        }
        String cgId = OpenStackCommonUtil.getIdFromUuid(cgUuid);
        Set cgIdNotInInsVmUuids = context.getCgIdNotInInsVmUuids();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN());
        String isManualRefresh = pg.getProperty("isManualRefresh");
        if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(0).equals(isManualRefresh)) {
            try {
                Cache<String, Object> cache = OpenstackCache.getCacheMap().get((Object)OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST);
                replicationInfos = (List)cache.get((Object)(regionUuid + projUuid), () -> {
                    List<VolumeReplicationInfo> replicationInfos0 = drExtendManager.getVolumeReplications(regionUuid, tokenId, projUuid, null, false);
                    if (replicationInfos0 != null) {
                        cache.put((Object)(regionUuid + projUuid), replicationInfos0);
                    }
                    return replicationInfos0;
                });
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Failed to get infos to cache:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Failed to get infos to cache");
            }
        } else {
            replicationInfos = drExtendManager.getVolumeReplications(regionUuid, tokenId, projUuid, null, false);
        }
        HashMap<String, VolumeReplicationInfo> replicationInfoMap = new HashMap<String, VolumeReplicationInfo>();
        for (VolumeReplicationInfo volumeReplicationInfo : replicationInfos) {
            if (!replicaModel.equals(volumeReplicationInfo.getReplicaModel())) continue;
            replicationInfoMap.put(volumeReplicationInfo.getVolumeId(), volumeReplicationInfo);
        }
        this.checkNotCsdrVhaMode(pg, cgId, cgIdNotInInsVmUuids, replicationInfoMap);
        this.checkCSDRVHACgIds(context, pg, replicationInfos, replicationInfoMap);
    }

    private void checkNotCsdrVhaMode(ProtectGroup pg, String cgId, Set<String> cgIdNotInInsVmUuids, Map<String, VolumeReplicationInfo> replicationInfoMap) {
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            for (ProtectObject po : pg.getPolist()) {
                String volConfigStr = (String)po.getProps().get("volumeConfig");
                JSONArray array = JSONArray.fromObject((Object)volConfigStr);
                this.addMoId(cgId, cgIdNotInInsVmUuids, replicationInfoMap, po, array);
            }
        }
    }

    private void addMoId(String cgId, Set<String> cgIdNotInInsVmUuids, Map<String, VolumeReplicationInfo> replicationInfoMap, ProtectObject po, JSONArray array) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            JSONObject json = array.getJSONObject(i);
            String volumeUuid = json.getString("volumeId");
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            VolumeReplicationInfo volumeReplicationInfo = replicationInfoMap.get(volumeId);
            if (VerifyUtil.isEmpty((Object)volumeReplicationInfo) || cgId.equals(volumeReplicationInfo.getReplicationcgId())) continue;
            cgIdNotInInsVmUuids.add(po.getMoUuid());
        }
    }

    private void checkCSDRVHACgIds(CheckContext context, ProtectGroup pg, List<VolumeReplicationInfo> replicationInfos, Map<String, VolumeReplicationInfo> replicationInfoMap) {
        if (34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType()) {
            return;
        }
        if (OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            this.checkAfterReprotect(pg, context, replicationInfos);
        } else {
            this.checkNormal(pg, replicationInfos, replicationInfoMap, context);
        }
    }

    private void checkAfterReprotect(ProtectGroup pg, CheckContext context, List<VolumeReplicationInfo> replicationInfos) {
        String replicaModel = "async";
        HashMap<String, List<String>> srcUuidToAsyncReplicaListMap = new HashMap<String, List<String>>();
        this.getSrcToAsyncReplicaListMap(replicaModel, replicationInfos, srcUuidToAsyncReplicaListMap);
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        String cgId = OpenStackCommonUtil.getIdFromUuid(cgUuid);
        String hyperCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        String hyperRemoteCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        if (VerifyUtil.isEmpty((String)hyperCgUuid) || VerifyUtil.isEmpty((String)hyperRemoteCgUuid)) {
            LOG.error((Object)("Pg have no hyperCgUuid/hyperRemoteCgUuid  pg: " + pg.getName()));
            return;
        }
        String hyperRemoteCgId = OpenStackCommonUtil.getIdFromUuid(hyperRemoteCgUuid);
        String hyperCgId = OpenStackCommonUtil.getIdFromUuid(hyperCgUuid);
        this.addMoUuid(pg, context, srcUuidToAsyncReplicaListMap, cgId, hyperRemoteCgId);
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drTokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN());
        replicationInfos = drExtendManager.getVolumeReplications(drRegionUuid, drTokenId, drProjUuid, null, false);
        HashMap<String, VolumeReplicationInfo> hyperReplicationInfoMap = new HashMap<String, VolumeReplicationInfo>();
        replicaModel = "hypermetro";
        for (VolumeReplicationInfo volumeReplicationInfo : replicationInfos) {
            if (!replicaModel.equals(volumeReplicationInfo.getReplicaModel())) continue;
            hyperReplicationInfoMap.put(volumeReplicationInfo.getVolumeId(), volumeReplicationInfo);
        }
        for (ProtectObject po : pg.getPolist()) {
            String hyperReplicaInfoStr = po.getProperty("hypermetor_replicationInfo");
            PoReplicaInfo hyperReplica = (PoReplicaInfo)JSONObject.toBean((String)hyperReplicaInfoStr, PoReplicaInfo.class);
            for (PoReplicaPairInfo pairInfo : hyperReplica.getPairInfos()) {
                String volumeUuid;
                String volumeId;
                VolumeReplicationInfo volumeReplicationInfo;
                if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || VerifyUtil.isEmpty((Object)(volumeReplicationInfo = (VolumeReplicationInfo)hyperReplicationInfoMap.get(volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid = pairInfo.getVolumeUuid())))) || hyperCgId.equals(volumeReplicationInfo.getReplicationcgId())) continue;
                context.getHyperCgIdNotInInsVmUuid().add(po.getMoUuid());
            }
        }
    }

    private void addMoUuid(ProtectGroup pg, CheckContext context, Map<String, List<String>> srcUuidToAsyncReplicaListMap, String cgId, String hyperRemoteCgId) {
        for (ProtectObject po : pg.getPolist()) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                String volumeUuid = json.getString("volumeId");
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
                List<String> cgIds = srcUuidToAsyncReplicaListMap.get(volumeId);
                if (VerifyUtil.isEmpty(cgIds)) continue;
                if (!cgIds.contains(cgId)) {
                    context.getCgIdNotInInsVmUuids().add(po.getMoUuid());
                }
                if (cgIds.contains(hyperRemoteCgId)) continue;
                context.getHyperRemoteCgIdNotInInsVmUuid().add(po.getMoUuid());
            }
        }
    }

    private void getSrcToAsyncReplicaListMap(String replicaModel, List<VolumeReplicationInfo> replicationInfos, Map<String, List<String>> srcUuidToAsyncReplicaListMap) {
        for (VolumeReplicationInfo volumeReplicationInfo : replicationInfos) {
            if (!replicaModel.equals(volumeReplicationInfo.getReplicaModel())) continue;
            if (srcUuidToAsyncReplicaListMap.containsKey(volumeReplicationInfo.getVolumeId())) {
                srcUuidToAsyncReplicaListMap.get(volumeReplicationInfo.getVolumeId()).add(volumeReplicationInfo.getReplicationcgId());
                continue;
            }
            ArrayList<String> volumeReplicationCGIds = new ArrayList<String>();
            volumeReplicationCGIds.add(volumeReplicationInfo.getReplicationcgId());
            srcUuidToAsyncReplicaListMap.put(volumeReplicationInfo.getVolumeId(), volumeReplicationCGIds);
        }
    }

    private void checkNormal(ProtectGroup pg, List<VolumeReplicationInfo> replicationInfos, Map<String, VolumeReplicationInfo> replicationInfoMap, CheckContext context) {
        String hyperCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        String hyperRemoteCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        if (VerifyUtil.isEmpty((String)hyperCgUuid) || VerifyUtil.isEmpty((String)hyperRemoteCgUuid)) {
            LOG.error((Object)("Pg have no hyperCgUuid/hyperRemoteCgUuid  pg: " + pg.getName()));
            return;
        }
        String hyperRemoteCgId = OpenStackCommonUtil.getIdFromUuid(hyperRemoteCgUuid);
        String hyperCgId = OpenStackCommonUtil.getIdFromUuid(hyperCgUuid);
        Map<String, VolumeReplicationInfo> hyperReplicationInfoMap = this.getReplicationInfoMap(replicationInfos);
        for (ProtectObject po : pg.getPolist()) {
            VolumeReplicationInfo volumeReplicationInfo;
            String volumeId;
            String volumeUuid;
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            PoReplicaInfo hyperRemoteReplica = (PoReplicaInfo)JSONObject.toBean((String)((String)po.getProps().get("remote_replicationInfo")), PoReplicaInfo.class);
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                volumeUuid = json.getString("volumeId");
                volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
                volumeReplicationInfo = hyperReplicationInfoMap.get(volumeId);
                if (VerifyUtil.isEmpty((Object)volumeReplicationInfo) || hyperCgId.equals(volumeReplicationInfo.getReplicationcgId())) continue;
                context.getHyperCgIdNotInInsVmUuid().add(po.getMoUuid());
            }
            for (PoReplicaPairInfo pairInfo : hyperRemoteReplica.getPairInfos()) {
                if (!OpenstackEnumDefine.VolProtectStatusE.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || VerifyUtil.isEmpty((Object)(volumeReplicationInfo = replicationInfoMap.get(volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid = pairInfo.getVolumeUuid())))) || hyperRemoteCgId.equals(volumeReplicationInfo.getReplicationcgId())) continue;
                context.getHyperRemoteCgIdNotInInsVmUuid().add(po.getMoUuid());
            }
        }
    }

    private Map<String, VolumeReplicationInfo> getReplicationInfoMap(List<VolumeReplicationInfo> replicationInfos) {
        HashMap<String, VolumeReplicationInfo> hyperReplicationInfoMap = new HashMap<String, VolumeReplicationInfo>();
        String replicaModel = "hypermetro";
        for (VolumeReplicationInfo volumeReplicationInfo : replicationInfos) {
            if (!replicaModel.equals(volumeReplicationInfo.getReplicaModel())) continue;
            hyperReplicationInfoMap.put(volumeReplicationInfo.getVolumeId(), volumeReplicationInfo);
        }
        return hyperReplicationInfoMap;
    }

    static {
        normalRepliaStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue());
        normalRepliaStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue());
        normalRepliaStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue());
        normalRepliaStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue());
    }
}

