/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public abstract class AbstractServiceInstRecoveryTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(AbstractServiceInstRecoveryTask.class);
    protected static final int EXISITING_QUE_SIZE = 10;
    private static final int DISASTER_RECOVERY_TIMEOUT = 3600;
    private static final int MONITORINTERVAL = 30;

    protected boolean checkPlanExcutionResult(InstanceInfoBO instBo, int excuteType) {
        String planId = instBo.getRecoveryPlanId();
        IRecoveryPlanService planServie = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        int times = 120;
        while (times > 0) {
            CommUtil.pauseThread((long)30000L);
            --times;
            RecoveryPlan planInDb = planServie.getRecoveryPlan(planId, false, false);
            if (null == planInDb) {
                LOGGER.error((Object)("The plan is not existed: " + planId));
                return false;
            }
            if (RecoveryBackTask.RUN_TASK_LOCKER.isLocked(planInDb.getPlanId())) continue;
            int successStatus = 100;
            int failedStatus = 100;
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType) {
                successStatus = DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue();
                failedStatus = DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED.getValue();
            } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == excuteType) {
                successStatus = DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue();
                failedStatus = DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED.getValue();
            }
            if (planInDb.getPlanStatus() == successStatus) {
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType) {
                    ServiceInstanceHelper.getInstance().changeStatus(instBo.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED);
                }
                return true;
            }
            if (planInDb.getPlanStatus() != failedStatus) continue;
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == excuteType) {
                ServiceInstanceHelper.getInstance().changeStatus(instBo.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED);
            }
            return false;
        }
        return false;
    }

    protected void sendAlarm(Boolean isSuccessed, long alarmId, InstanceInfoBO instBo) {
        if (isSuccessed == null) {
            return;
        }
        if (isSuccessed.booleanValue()) {
            AlarmReporter.restoreAlarm((long)alarmId, (String[])new String[]{instBo.getId()});
        } else {
            AlarmReporter.sendAlarm((long)alarmId, (String)instBo.getProtectGroupId(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{instBo.getId(), instBo.getName()});
        }
    }

    protected boolean checkLicense(InstanceInfoBO instanceInfoBO) {
        try {
            ILicenseControl licenseController = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(instanceInfoBO.getProtectGroupId(), true);
            licenseController.checkEnablePgCount(protectGroup);
            return true;
        }
        catch (LegoCheckedException le) {
            if (le.getErrorCode() == 1073947430L) {
                AlarmReporter.sendNoRepeatAlarm((long)52625481L, null, (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{"FLAG_SYSTEM_PROBATION_TIMEOUT_ALARM"});
            }
            LOGGER.error((Object)("Task excute error: " + instanceInfoBO.getRecoveryPlanId() + ExceptionUtil.getErrorMessage((Throwable)le)));
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Task excute error: " + instanceInfoBO.getRecoveryPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }
}

