/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.DeleteInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DeleteServerTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final int DEL_PG_TIMEOUT = 2147483;
    private static final int MONITORINTERVAL = 10;
    private static final Log LOG = LogFactory.getInstance(DeleteInstanceTask.class);
    private String instanceId;
    private String instanceName;
    private Set<String> serverIdSet;
    private String regionUuid;
    private String drRegionUuid;
    private String openstackUuid;
    private Set<ProtectObject> delProtectObjectSet;

    public DeleteServerTask(String proId, String type, String instanceId, String instanceName, Set<String> serverIdSet) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instanceName, (String)"ism.drm.instance.vm.delete", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.instanceId = instanceId;
        this.instanceName = instanceName;
        this.serverIdSet = serverIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.handleHighThan63();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOG.error((Object)("not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            ServiceInstance instance = ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.LOCKED);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            Map meterInfos = meterService.calculateMeterInfos(pg);
            meterInfos.put("change_type", "inst_update");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            this.checkVolSnapshots(instance);
            String pgId = instance.getProtectGroupId();
            if (!this.deleteServer(pgId)) {
                LOG.error((Object)("Not support delete this server,pgId:" + pgId));
                throw new LegoCheckedException(1073948109L);
            }
            this.updateRecoverySetting(instance);
            meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
            }
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
            try {
                ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
            }
            catch (Exception e) {
                LOG.error((Object)("set instance(" + this.instanceName + ") normal error."), (Throwable)e);
            }
        }
    }

    private void handleHighThan63() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String quotas = quotaService.calculateDeleteServerQuota(this.instanceId, this.serverIdSet);
            Map param = this.getExtendParam();
            param.put("order_quotas", quotas);
            this.setExtendParam(param);
        }
    }

    private boolean deleteServer(String pgId) {
        int times;
        if (VerifyUtil.isEmpty((String)pgId)) {
            return true;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
        if (null == pg) {
            return true;
        }
        this.regionUuid = (String)pg.getProps().get("regionId");
        this.drRegionUuid = (String)pg.getProps().get("drRegionId");
        this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
        Set<ProtectObject> pos = this.getServerInPg(pg);
        if (VerifyUtil.isEmpty(pos)) {
            return true;
        }
        this.delProtectObjectSet = pos;
        long taskId = this.getDeleteServerTaskId(pgId, pos, pgService);
        if (taskId == -1L) {
            return false;
        }
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(taskId);
        if (null == task) {
            LOG.error((Object)("Del " + this.getPoNames(pos) + "@" + this.instanceName + " task is null: " + taskId));
            return false;
        }
        for (times = 214748; times > 0; --times) {
            CommUtil.pauseThread((long)10000L);
            task = taskService.readTask(taskId);
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            LOG.error((Object)"Del %s @ %s task is fail:%s,reTryTimes=%s", new Object[]{this.getPoNames(pos), this.instanceName, taskId, 214748 - times});
            OpenStackCommonUtil.throwTaskError(task);
            return false;
        }
        LOG.error((Object)"Del %s @ %s task is timeout: %s,reTryTimes=%s", new Object[]{this.getPoNames(pos), this.instanceName, taskId, 214748 - times});
        return false;
    }

    private Set<ProtectObject> getServerInPg(ProtectGroup pg) {
        HashSet<ProtectObject> pos = new HashSet<ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            for (String serverId : this.serverIdSet) {
                if (!po.getMoUuid().contains(serverId)) continue;
                pos.add(po);
            }
        }
        return pos;
    }

    private long getDeleteServerTaskId(String pgId, Set<ProtectObject> pos, IProtectGroupService pgService) {
        try {
            return pgService.removeProtectObjects(pgId, pos);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Delete pg lego error.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete pg error.", (Throwable)e);
            return -1L;
        }
    }

    private void checkVolSnapshots(ServiceInstance instance) {
        if (VerifyUtil.isEmpty((Object)instance)) {
            LOG.error((Object)"CheckVolSnapshots failed, instance is null");
            return;
        }
        String pgId = instance.getProtectGroupId();
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, true);
        if (null == pg) {
            LOG.error((Object)"CheckVolSnapshots failed, pg is null");
            return;
        }
        ArrayList<String> volumesId = new ArrayList<String>();
        Set<ProtectObject> pos = this.getServerInPg(pg);
        if (VerifyUtil.isEmpty(pos)) {
            LOG.error((Object)"CheckVolSnapshots failed, po is null");
            return;
        }
        for (ProtectObject po : pos) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo || poReplicaInfo.getPairInfos().isEmpty()) continue;
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid());
                LOG.debug((Object)"Remotevol id is: %s", new Object[]{volId});
                volumesId.add(volId);
            }
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        volService.checkVolumesExitSnapshots((String)pg.getProps().get("drRegionId"), (String)pg.getProps().get("drProjectId"), volumesId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecoverySetting(ServiceInstance instance) {
        if (VerifyUtil.isEmpty(this.delProtectObjectSet)) {
            LOG.error((Object)"The delProtectObject is empty");
            return;
        }
        ArrayList<RecoverySetting> removeSettingList = new ArrayList<RecoverySetting>();
        for (ProtectObject delProtectObject : this.delProtectObjectSet) {
            this.updatePoRecoverySetting(removeSettingList, instance, delProtectObject);
        }
        if (VerifyUtil.isEmpty(removeSettingList)) {
            LOG.error((Object)"The removeSettingList is empty");
            return;
        }
        Session session = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            session.beginTransaction();
            for (RecoverySetting recoverySetting : removeSettingList) {
                session.delete((Object)recoverySetting);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)LOG);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void updatePoRecoverySetting(List<RecoverySetting> removeSettingList, ServiceInstance instance, ProtectObject delProtectObject) {
        String delOwnerId = delProtectObject.getUuid();
        if (VerifyUtil.isEmpty((String)delOwnerId)) {
            LOG.error((Object)"The delOwnerId is empty");
            return;
        }
        String planId = instance.getRecoveryPlanId();
        if (VerifyUtil.isEmpty((String)planId)) {
            LOG.error((Object)"The recoveryplan id is empty");
            return;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            LOG.error((Object)"The recoveryplan id is empty");
            return;
        }
        Set settings = recoveryPlan.getRecoverySettings();
        if (VerifyUtil.isEmpty((Collection)settings)) {
            LOG.error((Object)"The recoverySettings is empty");
            return;
        }
        for (RecoverySetting recoverySetting : settings) {
            if (!delOwnerId.equalsIgnoreCase(recoverySetting.getOwnerId())) continue;
            removeSettingList.add(recoverySetting);
        }
    }

    private String getPoNames(Set<ProtectObject> pos) {
        if (VerifyUtil.isEmpty(pos)) {
            return "";
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (ProtectObject po : pos) {
            nameSet.add(po.getName());
        }
        return ((Object)nameSet).toString();
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

