/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public class MonitorRecoveryTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(MonitorRecoveryTask.class);
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final int MONITORINTERVAL = 10000;
    private ServiceInstance instance;

    public MonitorRecoveryTask(ServiceInstance instance) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instance.getName(), (String)"ism.drm.instance.planned.migration", (String)"System", (String)"", null), 2147483, false);
        this.instance = instance;
    }

    protected void doWork() {
        String recoveryPlanId = this.instance.getRecoveryPlanId();
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        String instanceId = this.instance.getId();
        try {
            ServiceInstaceEnumDefine.ServiceInstanceStatusE status = this.monitorRecoveryPlanStatus(recoveryPlanId);
            instanceHelper.changeStatus(instanceId, status);
        }
        catch (Exception e) {
            LOG.error((Object)(this.instance.getName() + "  change status failed: the recovery" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private ServiceInstaceEnumDefine.ServiceInstanceStatusE monitorRecoveryPlanStatus(String recoveryPlanId) {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        while (true) {
            CommUtil.pauseThread((long)10000L);
            RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(recoveryPlanId);
            if (RecoveryBackTask.RUN_TASK_LOCKER.isLocked(recoveryPlanId)) continue;
            int status = recoveryPlan.getPlanStatus();
            if (status == DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue()) {
                this.dealAlarm(true);
                return ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL;
            }
            if (status == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue()) break;
        }
        this.dealAlarm(false);
        return ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED;
    }

    private void dealAlarm(boolean result) {
        if (result) {
            AlarmReporter.restoreAlarm((long)52625465L, (String[])new String[]{this.instance.getUuid()});
        } else {
            AlarmReporter.sendAlarm((long)52625465L, (String)this.instance.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{this.instance.getUuid(), this.instance.getName()});
        }
    }
}

