/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.task.AbstractServiceInstRecoveryTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ServiceInstReprotectTask
extends AbstractServiceInstRecoveryTask {
    private static final Log LOG = LogFactory.getInstance(ServiceInstReprotectTask.class);
    private static BlockingQueue<ServiceInstReprotectTask> excutingQue = new ArrayBlockingQueue<ServiceInstReprotectTask>(10);
    private InstanceInfoBO instBo;

    public ServiceInstReprotectTask(InstanceInfoBO serviceInst) {
        this.instBo = serviceInst;
    }

    public void removeFromExcutingQue() {
        excutingQue.remove(this);
    }

    public void putToExcutingQue() {
        if (VerifyUtil.isEmpty((Object)this.instBo)) {
            LOG.error((Object)"InstBo is null");
            return;
        }
        try {
            excutingQue.put(this);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Put element error: " + this.instBo.getId() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (VerifyUtil.isEmpty((Object)this.instBo)) {
            LOG.error((Object)"InstBo is null");
            return;
        }
        boolean isSuccessed = false;
        try {
            isSuccessed = this.checkLicense(this.instBo);
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            recoveryContext.put("isReserved", "true");
            User user = new User();
            user.setUserName("admin");
            IRecoveryManager recooveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
            recooveryManager.reprotectRecoveryPlan(this.instBo.getRecoveryPlanId(), recoveryContext, user);
            isSuccessed = this.checkPlanExcutionResult(this.instBo, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Task excute error: " + this.instBo.getRecoveryPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)));
                isSuccessed = false;
            }
            catch (Throwable throwable) {
                LOG.debug((Object)"Taks finall:%s", new Object[]{this.instBo.getRecoveryPlanId()});
                this.changeServiceInstStatus(isSuccessed);
                excutingQue.remove(this);
                ServiceInstanceHelper.getInstance().releaseLock(this.instBo.getId());
                this.sendAlarm(isSuccessed, 52625464L, this.instBo);
                throw throwable;
            }
            LOG.debug((Object)"Taks finall:%s", new Object[]{this.instBo.getRecoveryPlanId()});
            this.changeServiceInstStatus(isSuccessed);
            excutingQue.remove(this);
            ServiceInstanceHelper.getInstance().releaseLock(this.instBo.getId());
            this.sendAlarm(isSuccessed, 52625464L, this.instBo);
        }
        LOG.debug((Object)"Taks finall:%s", new Object[]{this.instBo.getRecoveryPlanId()});
        this.changeServiceInstStatus(isSuccessed);
        excutingQue.remove(this);
        ServiceInstanceHelper.getInstance().releaseLock(this.instBo.getId());
        this.sendAlarm(isSuccessed, 52625464L, this.instBo);
    }

    private void changeServiceInstStatus(boolean isSuccess) {
        if (isSuccess) {
            ServiceInstanceHelper.getInstance().changeStatus(this.instBo.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        } else {
            ServiceInstanceHelper.getInstance().changeStatus(this.instBo.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_FAILED);
        }
    }
}

