/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task.base;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.ArrayList;
import java.util.Map;

public abstract class AbstractDeleteInstanceTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(AbstractDeleteInstanceTask.class);
    protected String instanceId;
    private String instanceName;
    private String regionUuid;
    private String drRegionUuid;
    private String openstackUuid;

    public AbstractDeleteInstanceTask(String proId, String type, String instanceId, String instanceName) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instanceName, (String)"ism.drm.instance.delete", (String)proId, (String)type, (String)"", null), Integer.MAX_VALUE, true);
        this.instanceId = instanceId;
        this.instanceName = instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        this.handleHighThan63();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            LOG.error((Object)("Not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
        boolean deleteComplate = false;
        try {
            ServiceInstance instance = ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.DELETING);
            this.checkInstanceBeforeDeleteInstance(instance);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map<String, Object> meterInfos = this.calcMeterBeforeUpdate(instance, meterService);
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            String planId = instance.getRecoveryPlanId();
            if (!this.deleteRecoveryPlan(planId)) {
                LOG.error((Object)"Not support delete this recoveryPlan,planId:%s,instance name=%s, instance id=%s", new Object[]{planId, instance.getName(), instance.getId()});
                throw new LegoCheckedException(1073948688L);
            }
            this.deleteOtherRecoveryPlan(instance);
            String pgId = instance.getProtectGroupId();
            if (!this.deleteProtectGroup(pgId)) {
                LOG.error((Object)"Not support delete this ProtectGroup,pgId:%s,instance name=%s, instance id=%s", new Object[]{pgId, instance.getName(), instance.getId()});
                throw new LegoCheckedException(1073948105L);
            }
            this.deleteInstance(instance);
            ArrayList<String> sourceIdList = new ArrayList<String>();
            sourceIdList.add(this.instanceId);
            ((IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class)).deleteAlarmAndEventBySorceId(sourceIdList);
            deleteComplate = true;
            this.reportMeter(instance, meterService, meterInfos);
        }
        finally {
            this.finallyWork(deleteComplate);
        }
    }

    protected abstract void checkInstanceBeforeDeleteInstance(ServiceInstance var1);

    protected abstract void deleteOtherRecoveryPlan(ServiceInstance var1);

    private void finallyWork(boolean deleteComplate) {
        ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
        if (!deleteComplate) {
            try {
                ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.ServiceInstanceStatusE.ERR_DELETE);
            }
            catch (Exception e) {
                LOG.error((Object)("Set instance name(" + this.instanceName + ", instance id=" + this.instanceId + " err_delete error."), (Throwable)e);
            }
        }
    }

    protected abstract void handleHighThan63();

    protected abstract Map<String, Object> calcMeterBeforeUpdate(ServiceInstance var1, IMeterService var2);

    private void reportMeter(ServiceInstance instance, IMeterService meterService, Map<String, Object> meterInfos) {
        meterService.reportChangedMeterInfo(this.regionUuid, instance, this.openstackUuid, meterInfos);
        meterService.reportChangedMeterInfo(this.drRegionUuid, instance, this.openstackUuid, meterInfos);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private void deleteInstance(ServiceInstance instance) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)instance);
        }
        catch (Exception e) {
            LOG.error((Object)("Delete instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948105L, "delete instance error.", (Throwable)e);
        }
    }

    private boolean deleteProtectGroup(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            return true;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(pgId, false);
        if (pg == null) {
            return true;
        }
        this.regionUuid = (String)pg.getProps().get("regionId");
        this.drRegionUuid = (String)pg.getProps().get("drRegionId");
        this.openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
        long taskId = this.getDeletePgTaskId(pgId, pgService);
        if (taskId == -1L) {
            return false;
        }
        return OpenStackCommonUtil.getTaskResult(taskId, this.instanceName);
    }

    private long getDeletePgTaskId(String pgId, IProtectGroupService pgService) {
        try {
            return pgService.deleteProtectGroup(pgId, Boolean.valueOf(false));
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Delete pg error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Delete pg error.", (Throwable)ex);
            return -1L;
        }
    }

    protected boolean deleteRecoveryPlan(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            return true;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = planService.getRecoveryPlan(planId, false, false);
        if (plan == null) {
            return true;
        }
        try {
            planService.removeRecoveryPlan(planId);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete plan error.", (Throwable)e);
            return false;
        }
    }

    public void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

