/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.backup;

import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OpenStackBackupConstants {
    public static final String KEY_UNIFIED_BACKUP_SERVICE_URL = "config.hcs.cert.management.url";
    public static final String KEY_UNIFIED_BACKUP_REGION_GLOBAL_URL = "config.hcs.node.region";
    public static final String REQUEST_URL = "/rest/system/v2/action/register";
    public static final String RESPONSE_LANGUAGE = "language";
    public static final String LANGUAGE_ZH_CN = "zh_cn";
    public static final String LANGUAGE_EN_US = "en_us";
    public static final String IP = "ip";
    public static final String SYSTEM_TYPE = "systemType";
    public static final String SYSTEM_VERSION = "systemVersion";
    public static final String REGION_ID = "regionId";
    public static final String CONNECT_PARAMETERS = "connectParameters";
    public static final String REST_PORT = "restPort";
    public static final String REST_AUTH_TYPE = "restAuthType";
    public static final String CERTS = "certs";
    public static final String ACTION = "action";
    public static final String ACTIONURL = "actionUrl";
    public static final String FEATURE = "feature";
    public static final String IMPLEMENTS_FUNTIONS = "implementsFunctions";
    public static final String URL_LIST = "urlList";
    public static final String PING = "Ping";
    public static final String UNI_BACKUP = "UniBackup";
    public static final String ISM_DRM_BACKUP_REGISTER = "ism.drm.backup.register";
    public static final String BACKUP_REGISTER = "backup.register";
    public static final String DESCRPTION = "descrption";
    public static final String SUCCESS = "success";
    public static final String IS_EXISTS = "System to be added is already exists.";
    public static final String UNIFIED_BACKUP = "Unified Backup";
    public static final String DR_DOMAIN = "config.dr.domain";

    public static enum BackupRegisterUrl {
        CONNECTIVITY("connectivity", "/ws/bcs/version"),
        BACKUP_ACTION("backupaction", "/ws/bcs/manualpolicy"),
        BKSERVER("bkserver", "/ws/bcs/bkserver"),
        TASK_STATUS("taskstatus", "/ws/bcs/taskstatus"),
        SUB_SYSTEM("subsystem", "/ws/bcs/subsystem");

        private String action;
        private String uri;

        private BackupRegisterUrl(String action, String uri) {
            this.action = action;
            this.uri = uri;
        }

        public String getAction() {
            return this.action;
        }

        public String getUri() {
            return this.uri;
        }

        public static String stitchString() {
            JSONObject connectivity = new JSONObject();
            connectivity.put((Object)OpenStackBackupConstants.ACTION, (Object)CONNECTIVITY.getAction());
            connectivity.put((Object)OpenStackBackupConstants.ACTIONURL, (Object)CONNECTIVITY.getUri());
            JSONArray pingUrlList = new JSONArray();
            pingUrlList.add((Object)connectivity);
            JSONObject pingObject = new JSONObject();
            pingObject.put((Object)OpenStackBackupConstants.FEATURE, (Object)OpenStackBackupConstants.PING);
            pingObject.put((Object)OpenStackBackupConstants.URL_LIST, (Object)pingUrlList);
            List list = Arrays.stream(BackupRegisterUrl.values()).filter(obj -> obj != CONNECTIVITY).map(obj -> new JSONObject().set((Object)OpenStackBackupConstants.ACTION, (Object)obj.getAction()).set((Object)OpenStackBackupConstants.ACTIONURL, (Object)obj.getUri())).collect(Collectors.toList());
            JSONArray uniBackupList = new JSONArray();
            uniBackupList.addAll(list);
            JSONObject uniBackupObject = new JSONObject();
            uniBackupObject.put((Object)OpenStackBackupConstants.FEATURE, (Object)OpenStackBackupConstants.UNI_BACKUP);
            uniBackupObject.put((Object)OpenStackBackupConstants.URL_LIST, (Object)uniBackupList);
            JSONArray implementsFunctionsArray = new JSONArray();
            implementsFunctionsArray.add((Object)pingObject);
            implementsFunctionsArray.add((Object)uniBackupObject);
            return implementsFunctionsArray.toString();
        }
    }
}

