/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.bugmanagement;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.system.bugmanagement.task.OpenStackVersionReportTask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Locale;

public class OpenStackVersionReportService
implements SystemStatusChangedListener {
    private static final Log LOG = LogFactory.getInstance(OpenStackVersionReportService.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && this.available()) {
            LOG.info((Object)"Version report service creat a task to handle on register.");
            OpenStackVersionReportTask openStackVersionReportTask = new OpenStackVersionReportTask("ism.drm.version.report", "version.report");
            LOG.info((Object)"Submit a task for version report.");
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)openStackVersionReportTask);
            LOG.info((Object)String.format(Locale.ROOT, "Submit a task for version report success taskId is: %s", taskId));
        }
    }

    private boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.info((Object)"BugManagement server url is empty, Version Report management is not supported.");
            return false;
        }
        LOG.info((Object)"BugManagement Version Report is supported.");
        return true;
    }
}

