/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.system.backup.task.OpenStackBackupRegisterTask;
import com.huawei.ism.drm.openstack.system.unitepassword.OpenStackUnitePasswordConstants;
import com.huawei.ism.drm.openstack.system.unitepassword.UnitePasswordCommon;
import com.huawei.ism.drm.openstack.system.unitepassword.model.SubComponent;
import com.huawei.ism.drm.openstack.system.unitepassword.model.UnitePasswordAccountDto;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Complexity;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.util.PropUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TException;

public class UnitePasswordRegistTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final Log logger = LogFactory.getInstance(UnitePasswordRegistTask.class);
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();
    private static final int MAX_EXPIRED_TIME = 90;
    private static final Map<String, Long> EXPIRES = new HashMap<String, Long>();
    private static final Pattern DATE_PATTERN = Pattern.compile("^[0-9]{10}$");
    private NodeAgentLocalService.Iface client;

    public UnitePasswordRegistTask(String taskName, String taskType, NodeAgentLocalService.Iface client) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)taskName, (String)"System", (String)taskType, (String)"", (String[])new String[0]), 2147483, true);
        this.client = client;
    }

    private void initPasswordExpires(List<Node> nodeList) {
        if (nodeList.isEmpty()) {
            logger.error((Object)"The node list is empty when the password expiration time is initialized.");
            return;
        }
        try {
            this.initPasswordExpiresMap("DRManager", nodeList);
            this.initPasswordExpiresMap("OMUser", nodeList);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize the password expiration time.");
        }
    }

    private void initPasswordExpiresMap(String userName, List<Node> nodeList) throws TException {
        Map response = this.client.execute(new Command("manage_passwd").setParams(Arrays.asList("getPasswordExpires", userName, "", "")), nodeList, null);
        response.forEach((key, value) -> {
            logger.debug((Object)"Obtaining the node: %s execution result: %s", new Object[]{key.getAddresses().get(0), value.getDetails()});
            if (DATE_PATTERN.matcher(value.getDetails()).matches()) {
                String expiresKey = this.getKey(userName, (String)key.getAddresses().get(0));
                EXPIRES.put(expiresKey, value.getCode() * 1000L);
            } else if (value.getCode() != 0L) {
                logger.error((Object)"Failed to obtain the expiration time of the DRManager account on the node: %s.", new Object[]{key.getAddresses().get(0)});
            }
        });
    }

    protected void doWork() {
        boolean isNeedRetry;
        ArrayList<Node> nodeList = new ArrayList();
        try {
            nodeList = this.client.getNodeList();
        }
        catch (Exception e) {
            logger.error((Object)"Unite Password account get node list error.");
        }
        Map<String, String> map = this.queryPassWdFromMo();
        this.initPasswordExpires(nodeList);
        int retries = 0;
        do {
            long waitTime = OpenStackBackupRegisterTask.getWaitTimeExp(retries);
            if (retries > 0) {
                CommUtil.pauseThread((long)waitTime);
            }
            try {
                JSONObject accountJSONObject = this.getAccountJSONObject(map);
                isNeedRetry = !UnitePasswordCommon.register(accountJSONObject);
            }
            catch (Exception e) {
                isNeedRetry = true;
                logger.error((Object)"Unite Password account register failed, try again. error: %s , retry times: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), ++retries});
            }
        } while (isNeedRetry);
        logger.info((Object)"Unite Password account register Successful, Account Register task %s times.", new Object[]{String.valueOf(retries)});
    }

    private Map<String, String> queryPassWdFromMo() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.er.om.float");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)"Unite Password account register failed, server urlStr is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> osAccountPassword = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"component", (Object)"eReplication");
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        list.add(jsonObject);
        HashMap<String, String> entity = new HashMap<String, String>();
        try {
            entity.put("basePasswds", URLEncoder.encode(((Object)list).toString(), StandardCharsets.UTF_8.name()));
            OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
            String tokenId = TokenUtil.getInstance().getTokenId(open, null);
            String fullUrl = "https://" + urlStr + "/rest/mounpwdservice/v1/passwd?basePasswds={basePasswds}";
            logger.debug((Object)"Unite Password account register fullUrl is : %s", new Object[]{fullUrl});
            String response = ClientUtil.sendGetRequest(fullUrl, entity, tokenId, new int[0]);
            logger.info((Object)"Unite Password account register response: %s", new Object[]{response});
            List<UnitePasswordAccountDto> unitePasswordAccountDtoList = this.getUnitePasswordAccountList(response);
            for (UnitePasswordAccountDto unitePasswordAccountDto : unitePasswordAccountDtoList) {
                if (!unitePasswordAccountDto.getAccountType().equals(String.valueOf(OpenStackUnitePasswordConstants.ACCOUNTTYPE.HMOSACCOUNT.getCode())) || osAccountPassword.containsKey(unitePasswordAccountDto.getAccountName())) continue;
                logger.info((Object)"Select the password of account [%s] on node [%s] as the default password.", new Object[]{unitePasswordAccountDto.getAccountName(), unitePasswordAccountDto.getIp()});
                osAccountPassword.put(unitePasswordAccountDto.getAccountName(), unitePasswordAccountDto.getNewPasswd());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to invoke the MO interface to obtain the password.");
        }
        return osAccountPassword;
    }

    private List<UnitePasswordAccountDto> getUnitePasswordAccountList(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Response string is empty.");
            return Collections.emptyList();
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (VerifyUtil.isEmpty((Object)jsonNode) || jsonNode.path("data").isMissingNode()) {
            logger.error((Object)"Bad Request getUnitePasswordAccountList, response str=%s.", new Object[]{respStr});
            return Collections.emptyList();
        }
        List<UnitePasswordAccountDto> unitePasswordAccountDtoList = JsonUtil.jsonArrayToList(jsonNode.path("data").toString(), UnitePasswordAccountDto.class);
        logger.debug((Object)"GetUnitePasswordAccountList detail. response size=%s.", (long)unitePasswordAccountDtoList.size());
        return unitePasswordAccountDtoList;
    }

    private JSONObject getAccountJSONObject(Map<String, String> passwordMap) {
        JSONObject accountJSONObject = new JSONObject();
        String componentName = "eReplication";
        ArrayList<SubComponent> subComponents = new ArrayList<SubComponent>();
        SubComponent subComponent = new SubComponent();
        subComponent.setSubComponentName(componentName);
        ArrayList<Account> createdAccountList = new ArrayList<Account>();
        createdAccountList.add(this.createSyncAdminAccount());
        createdAccountList.addAll(this.createIAMServiceAccountList());
        createdAccountList.addAll(this.createdSystemAccountList(passwordMap));
        subComponent.setCreatedAccountList(createdAccountList);
        subComponents.add(subComponent);
        accountJSONObject.put((Object)"componentName", (Object)componentName);
        accountJSONObject.put((Object)"subComponents", subComponents);
        return accountJSONObject;
    }

    private List<Account> createdSystemAccountList(Map<String, String> passwordMap) {
        Path path = Paths.get(PathUtil.getInstallPath(), "NodeAgent/conf/nodeAgent.properties");
        Properties properties = PropUtil.loadProperties((Path)path);
        List<Account> systemAccountList = this.createRootAccount(passwordMap, properties);
        systemAccountList.addAll(this.createDRManagerAccount(passwordMap, properties));
        systemAccountList.addAll(this.createOMUserAccount(passwordMap, properties));
        return systemAccountList;
    }

    private List<Account> createRootAccount(Map<String, String> passwordMap, Properties properties) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        String rootName = "root";
        String rootPassword = passwordMap.getOrDefault(rootName, WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("root.password")));
        Complexity rootComplexity = new Complexity();
        for (int i = 1; i <= 4; ++i) {
            if (VerifyUtil.isEmpty((String)properties.getProperty("node_" + i))) continue;
            String[] ipAndRegion = properties.getProperty("node_" + i).split(";");
            String ip = ipAndRegion[0];
            String region = ipAndRegion[1];
            Account rootAccount = this.createSystemAccount(rootName, rootPassword, ip, region);
            rootAccount.setAccountDescription("{\"zh-cn\":\"\u5bf9\u670d\u52a1\u8fdb\u884c\u65e5\u5e38\u64cd\u4f5c\u548c\u7ef4\u62a4\uff08\u9700\u8981\u901a\u8fc7DRManager\u5e10\u6237\u767b\u5f55\u540e\uff0c\u518d\u6267\u884csu - root\u5207\u6362\u5230root\u5e10\u6237\uff09\u3002\",\"en-us\":\"used to perform routine operation and maintenance on services (Log in to the system as user DRManager and run the su - root command to switch to user root).\"}");
            rootAccount.setRiskMessage("{\"zh-cn\":\"\u66f4\u6539\u4efb\u4e00\u8282\u70b9\u5e10\u6237\u5bc6\u7801\u540e\uff0c\u9700\u540c\u6b65\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u5e10\u6237\u5bc6\u7801\uff0c\u4f7f\u6240\u6709\u8282\u70b9\u5bc6\u7801\u4fdd\u6301\u4e00\u81f4\u3002\",\"en-us\":\"After changing the password of a node account, you need to change the passwords of other nodes to ensure that the passwords of all nodes are the same.\"}");
            rootAccount.setPasswdComplexity(rootComplexity);
            rootAccount.setPasswdExpires(Long.valueOf(-1L));
            accounts.add(rootAccount);
        }
        return accounts;
    }

    private List<Account> createDRManagerAccount(Map<String, String> passwordMap, Properties properties) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        ArrayList<Account> dRManagerNoExpiresList = new ArrayList<Account>();
        String dRManagerName = "DRManager";
        String drManagerPassword = passwordMap.getOrDefault(dRManagerName, WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("DRManager.password")));
        long defaultExpires = Long.MAX_VALUE;
        Complexity needChangeComplexity = new Complexity();
        needChangeComplexity.setPasswdChangeMaxBetweenTime(90);
        for (int i = 1; i <= 4; ++i) {
            if (VerifyUtil.isEmpty((String)properties.getProperty("node_" + i))) continue;
            String[] ipAndRegion = properties.getProperty("node_" + i).split(";");
            String ip = ipAndRegion[0];
            String region = ipAndRegion[1];
            Account drManagerAccount = this.createSystemAccount(dRManagerName, drManagerPassword, ip, region);
            drManagerAccount.setAccountDescription("{\"zh-cn\":\"\u64cd\u4f5c\u7cfb\u7edf\u767b\u5f55\u7528\u6237\uff0c\u7528\u4e8e\u8fdc\u7a0b\u767b\u5f55\u5bb9\u707e\u670d\u52a1\u6240\u5728\u64cd\u4f5c\u7cfb\u7edf\u548c\u5de1\u68c0\u3002\u652f\u6301\u5207\u6362DRManager\u5e10\u6237\u5230OMUser\u5e10\u6237\u548croot\u5e10\u6237\u3002\",\"en-us\":\" User for logging in to the operating system. This account is used to remotely log in to the OS where the DR service is deployed and perform inspection. You can switch user DRManager to user OMUser and root.\"}");
            drManagerAccount.setRiskMessage("{\"zh-cn\":\"1.\u5e10\u6237\u8fc7\u671f\u5f71\u54cd\u5347\u7ea7\u3001\u6269\u5bb9\u53ca\u5de1\u68c0\u30022.\u66f4\u6539\u4efb\u4e00\u8282\u70b9\u5e10\u6237\u5bc6\u7801\u540e\uff0c\u9700\u540c\u6b65\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u5e10\u6237\u5bc6\u7801\uff0c\u4f7f\u6240\u6709\u8282\u70b9\u5bc6\u7801\u4fdd\u6301\u4e00\u81f4\u3002\",\"en-us\":\"1. Account expiration affects upgrade, capacity expansion, and inspection. 2. After changing the password of a node account, you need to change the passwords of other nodes to ensure that the passwords of all nodes are the same.\"}");
            drManagerAccount.setPasswdComplexity(needChangeComplexity);
            String expiresKey = this.getKey(dRManagerName, ip);
            if (EXPIRES.containsKey(expiresKey)) {
                defaultExpires = Math.min(defaultExpires, EXPIRES.get(expiresKey));
                drManagerAccount.setPasswdExpires(EXPIRES.get(expiresKey));
                accounts.add(drManagerAccount);
                continue;
            }
            drManagerAccount.setTimeUpdateSwitch(0);
            dRManagerNoExpiresList.add(drManagerAccount);
        }
        return this.addNoExpiresAccount(accounts, dRManagerNoExpiresList, defaultExpires);
    }

    private List<Account> createOMUserAccount(Map<String, String> passwordMap, Properties properties) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        ArrayList<Account> noExpiresList = new ArrayList<Account>();
        String omName = "OMUser";
        String omPassword = passwordMap.getOrDefault(omName, WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("OMUser.password")));
        long defaultExpires = Long.MAX_VALUE;
        Complexity needChangeComplexity = new Complexity();
        needChangeComplexity.setPasswdChangeMaxBetweenTime(90);
        for (int i = 1; i <= 4; ++i) {
            if (VerifyUtil.isEmpty((String)properties.getProperty("node_" + i))) continue;
            String[] ipAndRegion = properties.getProperty("node_" + i).split(";");
            String ip = ipAndRegion[0];
            String region = ipAndRegion[1];
            Account omAccount = this.createSystemAccount(omName, omPassword, ip, region);
            omAccount.setAccountDescription("{\"zh-cn\":\"\u8fd0\u7ef4\u5e10\u6237\uff0c\u7528\u4e8e\u6267\u884c\u5bb9\u707e\u670d\u52a1\u8fd0\u7ef4\u547d\u4ee4\uff08\u9700\u8981\u901a\u8fc7DRManager\u5e10\u6237\u767b\u5f55\u540e\uff0c\u518d\u6267\u884csu - OMUser\u5207\u6362\u5230OMUser\u5e10\u6237\uff09\u3002\",\"en-us\":\" O&M account, which is used to execute the DR service O&M commands(Log in to the system as user DRManager and run the su - OMUser command to switch to user OMUser).\"}");
            omAccount.setRiskMessage("{\"zh-cn\":\"\u66f4\u6539\u4efb\u4e00\u8282\u70b9\u5e10\u6237\u5bc6\u7801\u540e\uff0c\u9700\u540c\u6b65\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u5e10\u6237\u5bc6\u7801\uff0c\u4f7f\u6240\u6709\u8282\u70b9\u5bc6\u7801\u4fdd\u6301\u4e00\u81f4\u3002\",\"en-us\":\"After changing the password of a node account, you need to change the passwords of other nodes to ensure that the passwords of all nodes are the same.\"}");
            omAccount.setPasswdComplexity(needChangeComplexity);
            String expiresKey = this.getKey(omName, ip);
            if (EXPIRES.containsKey(expiresKey)) {
                defaultExpires = Math.min(defaultExpires, EXPIRES.get(expiresKey));
                omAccount.setPasswdExpires(EXPIRES.get(expiresKey));
                accounts.add(omAccount);
                continue;
            }
            omAccount.setTimeUpdateSwitch(0);
            noExpiresList.add(omAccount);
        }
        return this.addNoExpiresAccount(accounts, noExpiresList, defaultExpires);
    }

    private String getKey(String name, String ip) {
        return StringUtils.joinWith((String)"-", (Object[])new Object[]{name, ip});
    }

    private List<Account> addNoExpiresAccount(List<Account> systemAccountList, List<Account> noExpiresAccounts, long defaultExpires) {
        if (CollectionUtils.isEmpty(noExpiresAccounts)) {
            return systemAccountList;
        }
        long maxExpiredTime = Instant.now().plus(90L, ChronoUnit.DAYS).toEpochMilli();
        long expires = Math.min(maxExpiredTime, defaultExpires);
        for (Account account : noExpiresAccounts) {
            account.setPasswdExpires(Long.valueOf(expires));
            systemAccountList.add(account);
        }
        return systemAccountList;
    }

    private Account createSystemAccount(String accountName, String accountPassword, String ip, String region) {
        Account account = new Account();
        account.setAccountName(accountName);
        account.setAccountType(OpenStackUnitePasswordConstants.ACCOUNTTYPE.HMOSACCOUNT.getCode());
        account.setPasswd(accountPassword);
        account.setOldPasswd(accountPassword);
        account.setRegion(region);
        account.setIp(ip);
        account.setTimeUpdateSwitch(1);
        account.setUrlModify(OpenStackUnitePasswordConstants.UnitePasswordRegisterUrl.URL_MODIFY.getUrl());
        account.setUrlValid(OpenStackUnitePasswordConstants.UnitePasswordRegisterUrl.URL_VALID.getUrl());
        account.setUrlSyncStatus(OpenStackUnitePasswordConstants.UnitePasswordRegisterUrl.URL_SYNCSTATUS.getUrl());
        account.setOperationType(OpenStackUnitePasswordConstants.OPERATIONTYPE.ADD.getCode());
        account.setModifyType(OpenStackUnitePasswordConstants.MODIFYTYPE.ONLY_MODIFY.getCode());
        return account;
    }

    private List<Account> createIAMServiceAccountList() {
        ArrayList<Account> iAMServiceAccountList = new ArrayList<Account>();
        String iamServiceName = LegoConfig.getInstance().getKeyValue("IAM.service.name");
        for (int updatetimes = 0; VerifyUtil.isEmpty((String)iamServiceName) && updatetimes < 5; ++updatetimes) {
            CommUtil.pauseThread((long)5000L);
            logger.error((Object)"iamServiceName is empty, reload logo.properties.");
            LegoConfig.updateInstance();
            iamServiceName = LegoConfig.getInstance().getKeyValue("IAM.service.name");
        }
        logger.info((Object)"iamServiceName is %s", new Object[]{iamServiceName});
        UnitePasswordRegistTask.createIAMAccount(iAMServiceAccountList, iamServiceName);
        iAMServiceAccountList.add(this.createOpSvcAccount());
        return iAMServiceAccountList;
    }

    private Account createOpSvcAccount() {
        String opSvcPwd = WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("op.svc.eReplicationPwd"));
        return UnitePasswordRegistTask.getIamAccount("op_svc_eReplication", opSvcPwd);
    }

    private static Account getIamAccount(String name, String pwd) {
        Account account = new Account();
        account.setAccountName(name);
        account.setAccountType(OpenStackUnitePasswordConstants.ACCOUNTTYPE.MMAPPACCOUNT.getCode());
        account.setPasswd(pwd);
        account.setOldPasswd(pwd);
        account.setRegion(LegoConfig.getNodeConfig().getKeyValue("config.hcs.node.region"));
        account.setIp(LEGOMOGENERATOR.getInstallServerIp());
        account.setAccountDescription("{\"zh-cn\":\"IAM\u9274\u6743\u5e10\u53f7\",\"en-us\":\"IAM authentication account\"}");
        account.setPasswdExpires(Long.valueOf(-1L));
        account.setOperationType(OpenStackUnitePasswordConstants.OPERATIONTYPE.ADD.getCode());
        account.setUrlValid(OpenStackUnitePasswordConstants.UnitePasswordRegisterUrl.URL_VALID.getUrl());
        account.setModifyType(OpenStackUnitePasswordConstants.MODIFYTYPE.NOT_SUPPORT.getCode());
        return account;
    }

    protected static void createIAMAccount(List<Account> iAMServiceAccountList, String iamServiceName) {
        String[] iamServiceNames = iamServiceName.split(",");
        String iamServicePassword = WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("IAM.service.password"));
        for (String serviceName : iamServiceNames) {
            Account account = UnitePasswordRegistTask.getIamAccount(serviceName, iamServicePassword);
            iAMServiceAccountList.add(account);
        }
    }

    private Account createSyncAdminAccount() {
        String syncUserPwd = WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue("sys.default.syncUserPwd"));
        return UnitePasswordCommon.buildSyncAdminAccount(syncUserPwd, OpenStackUnitePasswordConstants.OPERATIONTYPE.ADD.getCode());
    }
}

