/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.base;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.cloudservice.bo.PolicyRequest;
import com.huawei.ism.drm.cloudservice.bo.RecoveryContinueRequest;
import com.huawei.ism.drm.cloudservice.bo.RecoveryPolicy;
import com.huawei.ism.drm.cloudservice.bo.UpdateInstanceRequest;
import com.huawei.ism.drm.cloudservice.bo.UpdateServerRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.RedirectRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.InstanceTypeConverter;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteLogBO;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.InterfaceSetBO;
import com.huawei.ism.drm.openstack.sdk.bo.PageForExecuteLogs;
import com.huawei.ism.drm.openstack.sdk.bo.PageForInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PageForVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.RecoverySettingBO;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.StringUtils;

public class BaseRestServiceImpl
extends RedirectRestService {
    private static final Log logger = LogFactory.getInstance(BaseRestServiceImpl.class);
    private static final List<String> PROTECT_TYPE_LIST = Arrays.asList("replication", "vha", "csha_csdr", "vha_csdr");

    public Response queryServiceInstanceList(String projectId, int marker, int limit, ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType) throws RestException {
        boolean cast;
        String sortKey = this.getHttpServletRequest().getParameter("sort_key");
        String sortType = this.getHttpServletRequest().getParameter("sort_type");
        String statusParam = this.getHttpServletRequest().getParameter("status");
        String nameParam = this.getHttpServletRequest().getParameter("name");
        String instId = this.getHttpServletRequest().getParameter("id");
        String protectType = this.getHttpServletRequest().getParameter("protect_type");
        String azName = this.getHttpServletRequest().getParameter("available_zone");
        String drAzName = this.getHttpServletRequest().getParameter("salve_available_zone");
        String regionId = this.getHttpServletRequest().getParameter("regionId");
        String vmName = this.getHttpServletRequest().getParameter("vm_name");
        String vmType = this.getHttpServletRequest().getParameter("vm_type");
        String objectType = this.getHttpServletRequest().getParameter("object_type");
        this.recordRequestLog("projectId is " + projectId + ", sortKey : " + sortKey + ", sortType : " + sortType + ", status : " + statusParam + ", name : " + nameParam + ", instId : " + instId + ", marker : " + marker + ", limit : " + limit + ", regionId : " + regionId + ", vmName : " + vmName + ", vmType : " + vmType + ", objectType : " + objectType);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        this.addToMapNonnull(conditionMap, "projectId", projectId);
        this.addToMapNonnull(conditionMap, "name", nameParam);
        this.addToMapNonnull(conditionMap, "status", statusParam);
        this.addToMapNonnull(conditionMap, "id", instId);
        this.addToMapNonnull(conditionMap, "protectType", protectType);
        this.addToMapNonnull(conditionMap, "availableZone", azName);
        this.addToMapNonnull(conditionMap, "salveAvailableZone", drAzName);
        this.addToMapNonnull(conditionMap, "regionId", regionId);
        this.addToMapNonnull(conditionMap, "vmName", vmName);
        this.addToMapNonnull(conditionMap, "objectType", objectType);
        Response errorResponse = this.checkServiceInstanceConditionMap(conditionMap);
        if (null != errorResponse) {
            return errorResponse;
        }
        boolean bl = cast = instanceType == null;
        if (cast) {
            String type = this.getHttpServletRequest().getParameter("instance_type");
            instanceType = InstanceTypeConverter.new2Enum(type, true);
        }
        conditionMap.put("instanceType", instanceType);
        this.addServiceInstanceQueryPageParam(conditionMap, sortKey, sortType, marker, limit);
        this.addToMapNonnull(conditionMap, "vmType", vmType);
        PageForInstanceInfo pageServiceInstance = this.getInstanceService().queryServiceInstances(conditionMap);
        if (cast) {
            InstanceTypeConverter.old2New(pageServiceInstance.getInstances());
        }
        return this.getResponse(Response.Status.OK, JSONObject.fromObject((Object)pageServiceInstance));
    }

    private void addToMapNonnull(Map<String, Object> conditionMap, String key, Object value) {
        if (!VerifyUtil.isEmpty((Object)value)) {
            conditionMap.put(key, value);
        }
    }

    private Response checkServiceInstanceConditionMap(Map<String, Object> conditionMap) throws RestException {
        Optional errorMessage = ParamChecker.checkNotEmptyParam((String)"projectId", (Object)((String)conditionMap.get("projectId")), ParamChecker::checkGeneralId);
        if (errorMessage.isPresent()) {
            return this.wrong(Response.Status.BAD_REQUEST, (String)errorMessage.get());
        }
        if (!ParamChecker.checkList((String)((String)conditionMap.get("status")), status -> ServiceInstaceEnumDefine.ServiceInstanceStatusE.getType((String)status.trim()) != null, (int)ServiceInstaceEnumDefine.ServiceInstanceStatusE.values().length)) {
            return this.wrong(Response.Status.BAD_REQUEST, "status is incorrect.");
        }
        if (!ParamChecker.checkNameQuery((String)((String)conditionMap.get("name")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "name is incorrect.");
        }
        if (!ParamChecker.checkGeneralId((String)((String)conditionMap.get("id")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "id is incorrect.");
        }
        if (!VerifyUtil.isEmpty((String)((String)conditionMap.get("protectType"))) && !PROTECT_TYPE_LIST.contains((String)conditionMap.get("protectType"))) {
            return this.wrong(Response.Status.BAD_REQUEST, "protect_type is incorrect.");
        }
        if (!ParamChecker.checkGeneralId((String)((String)conditionMap.get("availableZone")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "available_zone is incorrect.");
        }
        if (!ParamChecker.checkGeneralId((String)((String)conditionMap.get("salveAvailableZone")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "salve_available_zone is incorrect.");
        }
        if (!ParamChecker.checkGeneralId((String)((String)conditionMap.get("regionId")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "regionId is incorrect.");
        }
        if (!ParamChecker.checkNameQuery((String)((String)conditionMap.get("vmName")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "vm_name is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)ServiceInstaceEnumDefine.ObjectType.getObjectType((String)MapUtils.getString(conditionMap, (Object)"objectType")))) {
            return this.wrong(Response.Status.BAD_REQUEST, "object_type is incorrect.");
        }
        return null;
    }

    private void addServiceInstanceQueryPageParam(Map<String, Object> conditionMap, String sortKey, String sortType, int marker, int limit) {
        if (VerifyUtil.isEmpty((String)sortKey) || "create_time".equals(sortKey)) {
            sortKey = "createTime";
        }
        conditionMap.put("sortKey", sortKey);
        if (VerifyUtil.isEmpty((String)sortType)) {
            sortType = "desc";
        }
        conditionMap.put("sortType", sortType);
        marker = Math.max(marker - 1, 0);
        conditionMap.put("marker", marker);
        limit = Math.max(limit, 1);
        limit = Math.min(limit, 512);
        conditionMap.put("limit", limit);
    }

    public Response queryServiceInstance(String projectId, String instanceId, ServiceInstaceEnumDefine.ServiceInstanceTypeE instanceType) throws RestException {
        this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        JSONObject jsonResult = new JSONObject();
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("updateReplicaStatus", Boolean.TRUE.toString());
        InstanceInfoBO instanceInfo = this.getInstanceService().queryServiceInstance(projectId, instanceId, conditions);
        if (null == instanceInfo || instanceType != null && !instanceType.getValue().equals(instanceInfo.getType())) {
            return this.wrong(Response.Status.NOT_FOUND, "instance not found : " + instanceId);
        }
        if (instanceType == null) {
            InstanceTypeConverter.old2New(instanceInfo);
        }
        JSONObject instance = JSONObject.fromObject((Object)instanceInfo);
        jsonResult.put((Object)"instance", (Object)instance);
        return this.getResponse(Response.Status.OK, jsonResult);
    }

    private String validateData(String projectId, String instanceId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return "project_id is empty.";
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return "project_id is incorrect.";
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return "instance_id is empty.";
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return "instance_id is incorrect.";
        }
        return null;
    }

    public Response updateServiceInstBasicInfo(String projectId, String instanceId, UpdateInstanceRequest request) throws RestException {
        if (request == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is null");
        }
        this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + request.toString());
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        InstanceInfoBO instBo = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        String error = this.validateRequest(instBo, request);
        if (error != null) {
            return this.wrong(Response.Status.BAD_REQUEST, error);
        }
        ServiceInstance inst = new ServiceInstance();
        ProtectGroup pg = this.getProtectGroup(request, instBo, inst);
        String startPriority = request.getInstance().getStartPriority();
        if (startPriority != null && !this.updateProtectGroupStartPriorityCheck(startPriority, pg, inst)) {
            return this.wrong(Response.Status.BAD_REQUEST, "param illegal:" + startPriority);
        }
        inst.setUuid(instanceId);
        try {
            ProtectGroupValidator.updateProtectGroupBasicInfoCheck((String)instanceId, (String)inst.getName(), (String)inst.getDescription());
        }
        catch (LegoCheckedException e) {
            return this.wrong(Response.Status.BAD_REQUEST, "param illegal:" + e.getErrorCode());
        }
        try {
            this.getInstanceService().updateServiceInsBasicInfo(projectId, inst, pg);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instBo.getName(), request.getInstance().getName()});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instBo.getType());
            return this.getResponse(Response.Status.OK, JSONObject.fromObject((Object)request));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"updateServiceInstBasicInfo failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"updateServiceInstBasicInfo failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private ProtectGroup getProtectGroup(UpdateInstanceRequest request, InstanceInfoBO instBo, ServiceInstance inst) {
        ProtectGroup pg = new ProtectGroup();
        inst.setStartPriority(3);
        if (null == request.getInstance().getName()) {
            inst.setName(instBo.getName());
            pg.setName(instBo.getName());
        } else {
            inst.setName(request.getInstance().getName());
            pg.setName(request.getInstance().getName());
        }
        if (null == request.getInstance().getDescription()) {
            inst.setDescription(instBo.getDescription());
            pg.setDescription(instBo.getDescription());
        } else {
            inst.setDescription(request.getInstance().getDescription());
            pg.setDescription(request.getInstance().getDescription());
        }
        return pg;
    }

    private boolean updateProtectGroupStartPriorityCheck(String startPriority, ProtectGroup pg, ServiceInstance inst) {
        if (startPriority != null) {
            try {
                if (!VerifyUtil.isEmpty((String)startPriority)) {
                    if (5 < Integer.parseInt(startPriority) || 1 > Integer.parseInt(startPriority)) {
                        return false;
                    }
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("StartPriority", startPriority);
                    pg.setProps(props);
                    inst.setStartPriority(Integer.parseInt(startPriority));
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private String validateRequest(InstanceInfoBO instBo, UpdateInstanceRequest request) {
        if (null == request || null == request.getInstance()) {
            return "request is null.";
        }
        String name = request.getInstance().getName();
        if (name != null && !CommUtil.checkDrmNameParam((String)name)) {
            return "name is incorrect.";
        }
        String description = request.getInstance().getDescription();
        if (!CommUtil.checkDrmDescParam((String)description)) {
            return "description is incorrect.";
        }
        String instanceType = InstanceTypeConverter.old2New(instBo.getType());
        String startPriority = request.getInstance().getStartPriority();
        if (!("csha".equals(instanceType) || "csha_csdr".equals(instBo.getProtectType()) || VerifyUtil.isEmpty((String)startPriority))) {
            return "param is illegal.";
        }
        return null;
    }

    public Response modifyPolicy(String projectId, String instanceId, PolicyRequest request) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (VerifyUtil.isEmpty((Object)request) ? "" : request.toString()));
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (!VerifyUtil.isEmpty((Object)resultResponse)) {
            return resultResponse;
        }
        if (VerifyUtil.isEmpty((Object)request) || VerifyUtil.isEmpty((Object)request.getPolicy())) {
            return this.wrong(Response.Status.BAD_REQUEST, "policy is empty.");
        }
        if (!this.validatePolicy(request.getPolicy())) {
            return this.wrong(Response.Status.BAD_REQUEST, "policy param is not correct.");
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"modifyPolicy failed.");
            throw e;
        }
        try {
            if (VerifyUtil.isEmpty((Object)instanceInfoBO) || !ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(instanceInfoBO.getType())) {
                return this.wrong(Response.Status.NOT_FOUND, "instance not found : " + instanceId);
            }
            if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(instanceInfoBO.getReplicationType())) {
                return this.wrong(Response.Status.BAD_REQUEST, "Not support replication type. type=" + instanceInfoBO.getReplicationType());
            }
            if (!ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue().equals(instanceInfoBO.getStatus())) {
                logger.error((Object)("instance status is " + instanceInfoBO.getStatus()));
                throw new LegoCheckedException(1073948693L);
            }
            this.getInstanceService().modifPolicy(projectId, instanceId, this.convertPolicyToSchedule(request.getPolicy()));
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "modifPolicy ok.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getPolicy().getPeriodInterval(), instanceInfoBO.getPolicy().getPeriodType(), instanceInfoBO.getPolicy().getTimePoint(), request.getPolicy().getPeriodInterval(), request.getPolicy().getPeriodType(), request.getPolicy().getTimePoint()});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, "modifPolicy ok.");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"modifyPolicy failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"modifyPolicy failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private InstanceInfoBO getInstanceInfoBO(String projectId, String instanceId) {
        InstanceInfoBO instanceInfoBO;
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_modify_operationname", 3, instanceId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        return instanceInfoBO;
    }

    private Schedule convertPolicyToSchedule(PolicyBO policy) {
        Schedule autoSchedule = new Schedule();
        autoSchedule.setScheduleMode(0);
        autoSchedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        autoSchedule.setScheduleId(UUIDGenerator.getUUID());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 30);
        Date beginTime = cal.getTime();
        autoSchedule.setStartTime(String.valueOf(beginTime.getTime()));
        try {
            autoSchedule.setPeriodInterval(Integer.parseInt(policy.getPeriodInterval()));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"convertPolicyToSchedule failed.");
            throw new LegoCheckedException(1073947393L, "PeriodInterval is error.", (Throwable)e);
        }
        if ("minute".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(0);
        } else if ("hour".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(1);
        } else {
            autoSchedule.setPeriodType(2);
            String[] schduleTime = policy.getTimePoint().split(":");
            if (null == schduleTime || schduleTime.length != 2) {
                logger.error((Object)"convertPolicyToSchedule failed.");
                throw new LegoCheckedException(1073947393L, "TimePoint is error.");
            }
            autoSchedule.setHours(schduleTime[0]);
            autoSchedule.setMinutes(schduleTime[1]);
        }
        return autoSchedule;
    }

    private boolean validatePolicy(PolicyBO policy) {
        if (null == policy) {
            logger.error((Object)"policy is null.");
            return false;
        }
        try {
            policy.validate();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"policy is invalid.", (Throwable)e);
            return false;
        }
        return true;
    }

    public Response checkServiceInstance(String projectId, String instanceId) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        try {
            String taskId = this.getInstanceService().checkServiceInstance(projectId, instanceId);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"checkServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"checkServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response test(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        try {
            HashMap<String, String> conditions = new HashMap<String, String>();
            conditions.put("updateReplicaStatus", Boolean.TRUE.toString());
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, conditions);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        String replicationStatus = instanceInfoBO.getReplicaStatus();
        if (OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue().equals(replicationStatus)) {
            logger.error((Object)("Failed to test instance.replicaionstatus is copying.instanceName=" + instanceInfoBO.getName()));
            throw new LegoCheckedException(1073948134L);
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue());
        if (!instanceType.contains(instanceInfoBO.getType())) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().drilling(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"test failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"test failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response clear(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue());
        if (!instanceType.contains(instanceInfoBO.getType())) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().clearDrilling(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"clear failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"clear failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response queryVMList(String projectId, String instanceId, int marker, int limit) throws RestException {
        this.recordRequestLog("projectId is " + projectId + ", instanceId is " + instanceId + ", marker is " + marker + ",limit is " + limit);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        marker = marker < 1 ? 1 : marker;
        limit = limit < 1 || limit > 512 ? 512 : limit;
        PageForVmInfo vmHostList = this.getSfsInstanceService().queryServers(projectId, instanceId, --marker, limit);
        return this.getResponse(Response.Status.OK, JSONObject.fromObject((Object)vmHostList));
    }

    public Response queryVM(String projectId, String instanceId, String serverId) throws RestException {
        this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId + ",serverId:" + serverId);
        Response resultResponse = this.checkProjectAndInstanceAndServerID(projectId, instanceId, serverId);
        if (null != resultResponse) {
            return resultResponse;
        }
        VmInfoBO vmHost = this.getInstanceService().queryServer(projectId, instanceId, serverId, true);
        if (null == vmHost) {
            return this.wrong(Response.Status.NOT_FOUND, "vm not exits vm id is : " + serverId);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"server", (Object)JSONObject.fromObject((Object)vmHost).toString());
        return this.getResponse(Response.Status.OK, returnJson);
    }

    public Response updateServerInfo(String projectId, String instanceId, String serverId, UpdateServerRequest updateServerRequest) throws RestException {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId + ",serverId:" + serverId + ",server info is " + (null == updateServerRequest ? "" : updateServerRequest.toString()));
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serverId);
        Response resultResponse = this.checkProjectAndInstanceAndServerID(projectId, instanceId, serverId);
        if (null != resultResponse) {
            return resultResponse;
        }
        if (null == updateServerRequest || null == updateServerRequest.getServer()) {
            return this.wrong(Response.Status.BAD_REQUEST, "param is error.");
        }
        if (!VerifyUtil.isEmpty((String)this.checkRecoverySetting(updateServerRequest.getServer().getRecoverySetting()))) {
            return this.wrong(Response.Status.BAD_REQUEST, "RecoverySetting is error.");
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"updateServerInfo failed.");
            throw e;
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)vmInfoBO.getName());
        try {
            this.getInstanceService().updateServerInfo(projectId, instanceId, serverId, updateServerRequest.getServer());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, "modify success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"updateServerInfo failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"updateServerInfo failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private String checkRecoverySetting(RecoverySettingBO recoverySettingBO) {
        if (null == recoverySettingBO || VerifyUtil.isEmpty((String)recoverySettingBO.getStartPriority()) && VerifyUtil.isEmpty((Collection)recoverySettingBO.getInterfaceSetting())) {
            String error = "RecoverySettingBO is empty";
            logger.error((Object)error);
            return error;
        }
        Stream<Function> validaters = Stream.of(this::validateStartPriority, this::validateStartDelayTime, this::validateInterfaceSetting);
        return validaters.map(e -> (String)e.apply(recoverySettingBO)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private String validateStartPriority(RecoverySettingBO recoverySettingBO) {
        String startPriority = recoverySettingBO.getStartPriority();
        if (VerifyUtil.isEmpty((String)startPriority)) {
            return null;
        }
        if (!NumberUtil.between((String)startPriority, (int)1, (int)10)) {
            logger.error((Object)("startPriority illegal:" + startPriority));
            return "startPriority illegal";
        }
        return null;
    }

    private String validateStartDelayTime(RecoverySettingBO recoverySettingBO) {
        String startupWaitingTime = recoverySettingBO.getStartDelayTime();
        if (VerifyUtil.isEmpty((String)startupWaitingTime)) {
            return null;
        }
        if (!NumberUtil.between((String)startupWaitingTime, (int)0, (int)3600)) {
            logger.error((Object)("startupWaitingTime illegal: " + startupWaitingTime));
            return "startupWaitingTime illegal";
        }
        return null;
    }

    private String validateInterfaceSetting(RecoverySettingBO recoverySettingBO) {
        List interfaceSetting = recoverySettingBO.getInterfaceSetting();
        if (!VerifyUtil.isEmpty((Collection)interfaceSetting)) {
            if (interfaceSetting.size() > 16) {
                logger.error((Object)("InterfaceSetting illegal: " + interfaceSetting));
                return "interface of server is more than 16.";
            }
            HashSet<String> rightParam = new HashSet<String>();
            rightParam.add("false");
            rightParam.add("true");
            rightParam.add("forbidden");
            for (InterfaceSetBO bo : interfaceSetting) {
                if (!VerifyUtil.isEmpty((String)bo.getPortId()) && ParamChecker.checkGeneralId((String)bo.getPortId()) && !VerifyUtil.isEmpty((String)bo.getRecoveryInterface()) && !VerifyUtil.isEmpty((String)bo.getTestInterface()) && rightParam.contains(bo.getRecoveryInterface()) && rightParam.contains(bo.getTestInterface())) continue;
                logger.error((Object)("InterfaceSetBO illegal: " + bo));
                return "param illegal";
            }
        }
        return null;
    }

    public Response queryVolumeListByServerId(String projectId, String instanceId, String serverId) throws RestException {
        this.recordRequestLog("project_id=" + projectId + ",instance_id=" + instanceId + ",server_id=" + serverId);
        Response resultResponse = this.checkProjectAndInstanceAndServerID(projectId, instanceId, serverId);
        if (null != resultResponse) {
            return resultResponse;
        }
        List queryVolumesByServerId = this.getInstanceService().queryVolumes(projectId, instanceId, serverId);
        JSONObject resultJson = new JSONObject();
        JSONArray volumes = JSONArray.fromObject((Object)queryVolumesByServerId);
        resultJson.put((Object)"volumes", (Object)volumes);
        return this.getResponse(Response.Status.OK, resultJson);
    }

    public Response queryLogsByType(String projectId, String instanceId, int marker, int limit, boolean isReplication) throws RestException {
        this.recordRequestLog("query " + (isReplication ? "replications" : "recoveryLogs") + " , the projectId : " + projectId + ", the instanceId : " + instanceId + ", marker : " + marker + ", limit : " + limit);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        marker = marker < 1 ? 1 : marker;
        limit = limit < 1 || limit > 512 ? 512 : limit;
        PageForExecuteLogs queryRecoveryLogs = isReplication ? this.getInstanceService().queryReplicationLogs(projectId, instanceId, marker, limit) : this.getInstanceService().queryRecoveryLogs(projectId, instanceId, --marker, limit);
        if (null == queryRecoveryLogs) {
            queryRecoveryLogs = new PageForExecuteLogs();
        }
        return this.getResponse(Response.Status.OK, JSONObject.fromObject((Object)queryRecoveryLogs));
    }

    public Response queryRecoveryLog(String projectId, String instanceId, String logId) throws RestException {
        this.recordRequestLog("query recoveryLogs , the projectId : " + projectId + " ,the instanceId : " + instanceId + " ,the logId : " + logId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        if (VerifyUtil.isEmpty((String)logId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "logId is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)logId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "logId is incorrect.");
        }
        ExecuteLogBO recoveryLog = this.getInstanceService().queryRecoveryLog(projectId, instanceId, logId);
        JSONObject jsonResult = new JSONObject();
        if (null == recoveryLog) {
            return this.wrong(Response.Status.NOT_FOUND, "recovery log with id(" + logId + ") not found.");
        }
        jsonResult.put((Object)"log", (Object)recoveryLog);
        return this.getResponse(Response.Status.OK, jsonResult);
    }

    public Response queryReplicationLog(String projectId, String instanceId, String logId) throws RestException {
        this.recordRequestLog("query replicationLogs , the projectId : " + projectId + " ,the instanceId : " + instanceId + " ,the logId : " + logId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        if (VerifyUtil.isEmpty((String)logId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "logId is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)logId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "logId is incorrect.");
        }
        ExecuteLogBO recoveryLog = this.getInstanceService().queryReplicationLog(projectId, instanceId, logId);
        JSONObject jsonResult = new JSONObject();
        if (null == recoveryLog) {
            return this.getResponse(Response.Status.NOT_FOUND, "replication log with id(" + logId + ") not found.");
        }
        jsonResult.put((Object)"log", (Object)recoveryLog);
        return this.getResponse(Response.Status.OK, jsonResult);
    }

    public Response plannedMigration(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue());
        CheckRecoveryParam checkRecoveryParam = new CheckRecoveryParam(projectId, instanceId, instanceType).invoke();
        if (checkRecoveryParam.is()) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        InstanceInfoBO instanceInfoBO = checkRecoveryParam.getInstanceInfoBO();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().plannedMigration(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"plannedMigration failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"plannedMigration failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private Response setRecoveryPolicy(RecoveryPolicy recoveryPolicy, Map<String, String> recoveryContext) throws RestException {
        if (!VerifyUtil.isEmpty((Object)recoveryPolicy)) {
            Boolean isConfirmReprotection;
            String azId;
            String regionId;
            String recoveryAzId;
            String recoveryRegionId = recoveryPolicy.getRecoveryRegionId();
            if (!VerifyUtil.isEmpty((String)recoveryRegionId)) {
                if (!ParamChecker.checkGeneralId((String)recoveryRegionId)) {
                    return this.wrong(Response.Status.BAD_REQUEST, "recovery_region_id is incorrect.");
                }
                recoveryContext.put("recovery_region_id", recoveryRegionId);
            }
            if (!VerifyUtil.isEmpty((String)(recoveryAzId = recoveryPolicy.getRecoveryAzId()))) {
                if (!ParamChecker.checkGeneralId((String)recoveryAzId)) {
                    return this.wrong(Response.Status.BAD_REQUEST, "recovery_az_id is incorrect.");
                }
                recoveryContext.put("recovery_az_id", recoveryAzId);
            }
            if (!VerifyUtil.isEmpty((String)(regionId = recoveryPolicy.getRegionId()))) {
                if (!ParamChecker.checkGeneralId((String)regionId)) {
                    return this.wrong(Response.Status.BAD_REQUEST, "region_id is incorrect.");
                }
                recoveryContext.put("region_id", regionId);
            }
            if ((azId = recoveryPolicy.getAzId()) != null) {
                if (!ParamChecker.checkGeneralId((String)azId)) {
                    return this.wrong(Response.Status.BAD_REQUEST, "az_id is incorrect.");
                }
                recoveryContext.put("az_id", azId);
            }
            if ((isConfirmReprotection = recoveryPolicy.getConfirmReprotection()) != null) {
                recoveryContext.put("is_confirm_reprotection", isConfirmReprotection.toString());
            }
        }
        return null;
    }

    private void setRecoveryContinueParams(RecoveryContinueRequest continueRequest, Map<String, String> recoveryContext) {
        if (continueRequest == null) {
            return;
        }
        Boolean isContinue = continueRequest.getIsContinue();
        if (isContinue == null) {
            logger.error((Object)"is_continue is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        recoveryContext.put("recovery_continue_key", isContinue.toString());
    }

    public Response actionContinue(String projectId, String instanceId, String actionType, RecoveryContinueRequest continueRequest) throws RestException {
        if (!StringUtils.hasText((String)actionType) || !DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Parameter actionType is incorrect.");
        }
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (resultResponse != null) {
            return resultResponse;
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue());
        CheckRecoveryParam checkRecoveryParam = new CheckRecoveryParam(projectId, instanceId, instanceType).invoke();
        if (checkRecoveryParam.is()) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        InstanceInfoBO instanceInfoBo = checkRecoveryParam.getInstanceInfoBO();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBo.getName());
        Boolean isContinue = continueRequest.getIsContinue();
        Object ix = null;
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            this.setRecoveryContinueParams(continueRequest, recoveryContext);
            this.getInstanceService().plannedMigrationContinue(projectId, instanceId, recoveryContext);
            String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId + ",actionType:" + actionType + ",isContinue:" + isContinue);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)this.getContinueOperationName(actionType, isContinue));
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (Exception ex) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)this.getContinueOperationName(actionType, isContinue));
            if (ex instanceof LegoCheckedException) {
                throw ex;
            }
            throw new LegoCheckedException(-1L);
        }
    }

    private String getContinueOperationName(String actionType, Boolean isContinue) {
        if (DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType) && isContinue.booleanValue()) {
            return "recoveryPlan_enableContinuePlannedMigration_operateName";
        }
        if (DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType) && !isContinue.booleanValue()) {
            return "recoveryPlan_cancelContinuePlannedMigration_operateName";
        }
        return "";
    }

    public Response hotMigration(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue());
        CheckRecoveryParam checkRecoveryParam = new CheckRecoveryParam(projectId, instanceId, instanceType).invoke();
        if (checkRecoveryParam.is()) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        InstanceInfoBO instanceInfoBO = checkRecoveryParam.getInstanceInfoBO();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().hotMigration(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"hotMigration failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"hotMigration failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response disasterRecovery(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue());
        CheckRecoveryParam checkRecoveryParam = new CheckRecoveryParam(projectId, instanceId, instanceType).invoke();
        if (checkRecoveryParam.is()) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        InstanceInfoBO instanceInfoBO = checkRecoveryParam.getInstanceInfoBO();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().diasterRecovery(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"disasterRecovery failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"disasterRecovery failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response reprotect(String projectId, String instanceId, RecoveryPolicy recoveryPolicy) throws RestException {
        String reqId = this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        Response resultResponse = this.checkProjectAndInstanceID(projectId, instanceId);
        if (null != resultResponse) {
            return resultResponse;
        }
        List<String> instanceType = Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue(), ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue());
        CheckRecoveryParam checkRecoveryParam = new CheckRecoveryParam(projectId, instanceId, instanceType).invoke();
        if (checkRecoveryParam.is()) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance type is incorrect.");
        }
        InstanceInfoBO instanceInfoBO = checkRecoveryParam.getInstanceInfoBO();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        try {
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            Response errorResponse = this.setRecoveryPolicy(recoveryPolicy, recoveryContext);
            if (errorResponse != null) {
                return errorResponse;
            }
            this.getInstanceService().reprotect(projectId, instanceId, recoveryContext);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, (String)null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"reprotect failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"reprotect failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private Response checkProjectAndInstanceID(String projectId, String instanceId) throws RestException {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is incorrect.");
        }
        return null;
    }

    private Response checkProjectAndInstanceAndServerID(String projectId, String instanceId, String serverId) throws RestException {
        Response response = this.checkProjectAndInstanceID(projectId, instanceId);
        if (response != null) {
            return response;
        }
        if (VerifyUtil.isEmpty((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is incorrect.");
        }
        return null;
    }

    private class CheckRecoveryParam {
        private boolean myResult;
        private String projectId;
        private String instanceId;
        private InstanceInfoBO instanceInfoBO;
        private List<String> instanceType;

        public CheckRecoveryParam(String projectId, String instanceId, List<String> instanceType) {
            this.projectId = projectId;
            this.instanceId = instanceId;
            this.instanceType = instanceType;
        }

        boolean is() {
            return this.myResult;
        }

        public InstanceInfoBO getInstanceInfoBO() {
            return this.instanceInfoBO;
        }

        public CheckRecoveryParam invoke() {
            try {
                HashMap conditions = new HashMap();
                this.instanceInfoBO = BaseRestServiceImpl.this.getInstanceService().queryServiceInstance(this.projectId, this.instanceId, conditions);
            }
            catch (LegoCheckedException e) {
                BaseRestServiceImpl.this.writeFailedOperationLogNoException("instance_plannedMigration_operationname", 3, this.instanceId, (Exception)((Object)e), "Cloud DR Service");
                throw e;
            }
            if ("csha_csdr".equals(this.instanceInfoBO.getProtectType()) && !this.instanceType.contains(ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue())) {
                this.myResult = true;
                return this;
            }
            if ("vha_csdr".equals(this.instanceInfoBO.getProtectType()) && !this.instanceType.contains(ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue())) {
                this.myResult = true;
                return this;
            }
            if (!("csha_csdr".equals(this.instanceInfoBO.getProtectType()) || "vha_csdr".equals(this.instanceInfoBO.getProtectType()) || this.instanceType.contains(this.instanceInfoBO.getType()))) {
                this.myResult = true;
                return this;
            }
            this.myResult = false;
            return this;
        }
    }
}

